/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.index;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.common.EncoderUtil;
import org.tukaani.xz.index.IndexBase;
import org.tukaani.xz.index.IndexRecord;

public class IndexEncoder
extends IndexBase {
    private final ArrayList<IndexRecord> records = new ArrayList();

    public IndexEncoder() {
        super(new XZIOException("XZ Stream or its Index has grown too big"));
    }

    @Override
    public void add(long l2, long l3) throws XZIOException {
        super.add(l2, l3);
        this.records.add(new IndexRecord(l2, l3));
    }

    public void encode(OutputStream outputStream) throws IOException {
        CRC32 cRC32 = new CRC32();
        CheckedOutputStream checkedOutputStream = new CheckedOutputStream(outputStream, cRC32);
        checkedOutputStream.write(0);
        EncoderUtil.encodeVLI(checkedOutputStream, this.recordCount);
        for (IndexRecord indexRecord : this.records) {
            EncoderUtil.encodeVLI(checkedOutputStream, indexRecord.unpadded);
            EncoderUtil.encodeVLI(checkedOutputStream, indexRecord.uncompressed);
        }
        for (int i2 = this.getIndexPaddingSize(); i2 > 0; --i2) {
            checkedOutputStream.write(0);
        }
        long l2 = cRC32.getValue();
        for (int i3 = 0; i3 < 4; ++i3) {
            outputStream.write((byte)(l2 >>> i3 * 8));
        }
    }
}

