/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jahia.configuration.configurators.AbstractConfigurator;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jahia.configuration.logging.AbstractLogger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public abstract class AbstractXMLConfigurator
extends AbstractConfigurator {
    public AbstractXMLConfigurator(Map dbProps, JahiaConfigInterface jahiaConfigInterface) {
        super(dbProps, jahiaConfigInterface);
    }

    public AbstractXMLConfigurator(Map dbProps, JahiaConfigInterface jahiaConfigInterface, AbstractLogger logger) {
        super(dbProps, jahiaConfigInterface, logger);
    }

    public void insertElementAfter(Document jdomDocument, String xPathExpression, Element element) throws JDOMException {
        Element rootElement = jdomDocument.getRootElement();
        String namespaceURI = rootElement.getNamespaceURI();
        XPath previousElementXPath = XPath.newInstance((String)xPathExpression);
        if (namespaceURI != null && !"".equals(namespaceURI)) {
            previousElementXPath.addNamespace("xp", namespaceURI);
        }
        Element previousElement = (Element)previousElementXPath.selectSingleNode((Object)jdomDocument);
        int previousElementIndex = previousElement.getParent().indexOf((Content)previousElement);
        previousElement.getParent().getContent().add(previousElementIndex + 1, element);
    }

    public void setElementAttribute(Element scopeElement, String xPathExpression, String attributeName, String attributeValue) throws JDOMException {
        XPath xPath = XPath.newInstance((String)xPathExpression);
        String namespaceURI = scopeElement.getDocument().getRootElement().getNamespaceURI();
        if (namespaceURI != null && !"".equals(namespaceURI)) {
            xPath.addNamespace("xp", namespaceURI);
        }
        List elementList = xPath.selectNodes((Object)scopeElement);
        for (Element element : elementList) {
            element.setAttribute(attributeName, attributeValue);
        }
    }

    public Element getElement(Element scopeElement, String xPathExpression) throws JDOMException {
        return this.getElement(scopeElement, xPathExpression, null);
    }

    public Element getElement(Element scopeElement, String xPathExpression, Namespace namespace) throws JDOMException {
        XPathFactory instance = XPathFactory.instance();
        XPathExpression xPath = namespace != null ? instance.compile(xPathExpression, Filters.element(), null, new Namespace[]{namespace}) : instance.compile(xPathExpression, Filters.element());
        return (Element)xPath.evaluateFirst((Object)scopeElement);
    }

    public List<Element> getElements(Element scopeElement, String xPathExpression) throws JDOMException {
        String namespaceURI = scopeElement.getDocument().getRootElement().getNamespaceURI();
        XPathFactory instance = XPathFactory.instance();
        Namespace namespace = null;
        if (namespaceURI != null && !"".equals(namespaceURI)) {
            namespace = Namespace.getNamespace((String)namespaceURI);
        }
        XPathExpression xPath = namespace != null ? instance.compile(xPathExpression, Filters.element(), null, new Namespace[]{namespace}) : instance.compile(xPathExpression, Filters.element());
        return new LinkedList<Element>(xPath.evaluate((Object)scopeElement));
    }

    protected void removeElementIfExists(Element scopeElement, String xPathExpression) throws JDOMException {
        Element el = this.getElement(scopeElement, xPathExpression);
        if (el != null) {
            el.getParent().removeContent((Content)el);
        }
    }

    protected void removeAllElements(Element scopeElement, String xPathExpression) throws JDOMException {
        for (Element el : this.getElements(scopeElement, xPathExpression)) {
            el.getParent().removeContent((Content)el);
        }
    }

    protected final void write(Document document, File destination) throws IOException {
        String lineSeparator = System.getProperty("line.separator");
        Format format = Format.getPrettyFormat().setLineSeparator(lineSeparator);
        this.write(document, destination, format);
    }

    protected final void write(Document document, File destination, Format format) throws IOException {
        XMLOutputter outputter = new XMLOutputter(format);
        try (FileOutputStream out = new FileOutputStream(destination);){
            outputter.output(document, (OutputStream)out);
        }
    }
}

