/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.util.Map;
import org.jahia.configuration.configurators.AbstractXMLConfigurator;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class RootUserConfigurator
extends AbstractXMLConfigurator {
    private String rootPassword;
    private JahiaConfigInterface cfg;

    public RootUserConfigurator(Map dbProperties, JahiaConfigInterface jahiaConfigInterface, String rootPassword) {
        super(dbProperties, jahiaConfigInterface);
        this.rootPassword = rootPassword;
        this.cfg = jahiaConfigInterface;
    }

    @Override
    public void updateConfiguration(ConfigFile sourceConfigFile, String destFileName) throws Exception {
        if (sourceConfigFile == null) {
            return;
        }
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        Document jdomDocument = saxBuilder.build(sourceConfigFile.getInputStream());
        Element beansElement = jdomDocument.getRootElement();
        Element rootNameElement = this.getElement(beansElement, "/content/users/ROOT_NAME_PLACEHOLDER");
        Element element = rootNameElement = rootNameElement != null ? rootNameElement : this.getElement(beansElement, "/content/users/root");
        if (rootNameElement != null) {
            Element grantElement;
            rootNameElement.setName(this.cfg.getJahiaRootUsername());
            Namespace jahiaNamespace = rootNameElement.getNamespace("j");
            Element element2 = rootNameElement.getChild("files") != null ? (rootNameElement.getChild("files").getChild("private") != null ? (rootNameElement.getChild("files").getChild("private").getChild("acl", jahiaNamespace) != null ? rootNameElement.getChild("files").getChild("private").getChild("acl", jahiaNamespace).getChild("GRANT_u_root") : null) : null) : (grantElement = null);
            if (grantElement != null) {
                grantElement.setName("GRANT_u_" + this.cfg.getJahiaRootUsername());
                grantElement.setAttribute("principal", "u:" + this.cfg.getJahiaRootUsername(), jahiaNamespace);
            }
            rootNameElement.setAttribute("password", this.rootPassword, jahiaNamespace);
            if (this.cfg.getJahiaRootFirstname() != null && this.cfg.getJahiaRootFirstname().length() > 0) {
                rootNameElement.setAttribute("firstName", this.cfg.getJahiaRootFirstname(), jahiaNamespace);
            }
            if (this.cfg.getJahiaRootLastname() != null && this.cfg.getJahiaRootLastname().length() > 0) {
                rootNameElement.setAttribute("lastName", this.cfg.getJahiaRootLastname(), jahiaNamespace);
            }
            if (this.cfg.getJahiaRootEmail() != null && this.cfg.getJahiaRootEmail().length() > 0) {
                rootNameElement.setAttribute("email", this.cfg.getJahiaRootEmail(), jahiaNamespace);
            }
            if (this.cfg.getJahiaRootPreferredLang() != null && this.cfg.getJahiaRootPreferredLang().length() > 0) {
                rootNameElement.setAttribute("preferredLanguage", this.cfg.getJahiaRootPreferredLang());
            }
        }
        this.write(jdomDocument, new File(destFileName));
    }
}

