/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.deployers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jahia.configuration.deployers.ServerDeploymentInterface;

public abstract class AbstractServerDeploymentImpl
implements ServerDeploymentInterface {
    private File configDir;
    private File dataDir;
    private Properties deployersProperties;
    private String id;
    private String name;
    private File targetServerDirectory;

    public AbstractServerDeploymentImpl(String id, String name, File targetServerDirectory) {
        this.id = id;
        this.name = name;
        this.targetServerDirectory = targetServerDirectory;
    }

    @Override
    public boolean deployJdbcDriver(File driverJar) throws IOException {
        return this.deploySharedLibraries(driverJar);
    }

    @Override
    public boolean deploySharedLibraries(File ... pathToLibraries) throws IOException {
        File targetDirectory = this.getSharedLibraryDirectory();
        for (File currentLibraryPath : pathToLibraries) {
            FileUtils.copyFileToDirectory((File)currentLibraryPath, (File)targetDirectory);
        }
        return true;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    protected Properties getDeployersProperties() {
        if (this.deployersProperties == null) {
            this.deployersProperties = new Properties();
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/jahia/configuration/deployers/JahiaDeployers.properties");
            if (is != null) {
                try {
                    this.deployersProperties.load(is);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }
        return this.deployersProperties;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected abstract File getSharedLibraryDirectory();

    @Override
    public File getTargetServerDirectory() {
        return this.targetServerDirectory;
    }

    @Override
    public String getWarExcludes() {
        return (String)this.getDeployersProperties().get("warExcludes." + this.getId());
    }

    @Override
    public String getWebappDeploymentDirNameOverride() {
        return null;
    }

    public void init() {
    }

    @Override
    public boolean isAutoDeploySupported() {
        return true;
    }

    @Override
    public boolean isEarDeployment() {
        return false;
    }

    public void setConfigDir(File configDir) {
        this.configDir = configDir;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    @Override
    public boolean undeploySharedLibraries(File ... pathToLibraries) throws IOException {
        File targetDirectory = this.getSharedLibraryDirectory();
        for (File currentLibraryPath : pathToLibraries) {
            File targetFile = new File(targetDirectory, currentLibraryPath.getName());
            targetFile.delete();
        }
        return true;
    }
}

