/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.bootstrap.decorators;

import javax.jcr.RepositoryException;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapColumnDecorator
extends JCRNodeDecorator {
    private static Logger logger = LoggerFactory.getLogger(BootstrapColumnDecorator.class);

    public BootstrapColumnDecorator(JCRNodeWrapper node) {
        super(node);
    }

    @NotNull
    @Min(value=1L)
    public Long getSpan() {
        try {
            JCRPropertyWrapper property = this.getProperty("span");
            if (property != null) {
                return property.getLong();
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    @NotNull
    @Min(value=0L)
    public Long getOffset() {
        try {
            JCRPropertyWrapper property = this.getProperty("offset");
            if (property != null) {
                return property.getLong();
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage());
        }
        return null;
    }
}

