<%@ taglib prefix="jcr" uri="http://www.jahia.org/tags/jcr" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="utility" uri="http://www.jahia.org/tags/utilityLib" %>
<%@ taglib prefix="template" uri="http://www.jahia.org/tags/templateLib" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="functions" uri="http://www.jahia.org/tags/functions" %>
<%@ taglib prefix="ui" uri="http://www.jahia.org/tags/uiComponentsLib" %>
<%--@elvariable id="currentNode" type="org.jahia.services.content.JCRNodeWrapper"--%>
<%--@elvariable id="propertyDefinition" type="org.jahia.services.content.nodetypes.ExtendedPropertyDefinition"--%>
<%--@elvariable id="type" type="org.jahia.services.content.nodetypes.ExtendedNodeType"--%>
<%--@elvariable id="out" type="java.io.PrintWriter"--%>
<%--@elvariable id="script" type="org.jahia.services.render.scripting.Script"--%>
<%--@elvariable id="scriptInfo" type="java.lang.String"--%>
<%--@elvariable id="workspace" type="java.lang.String"--%>
<%--@elvariable id="renderContext" type="org.jahia.services.render.RenderContext"--%>
<%--@elvariable id="currentResource" type="org.jahia.services.render.Resource"--%>
<%--@elvariable id="url" type="org.jahia.services.render.URLGenerator"--%>
<jsp:useBean id="datas" class="java.util.LinkedHashMap"/>
<template:addResources type="css" resources="fullcalendar.css"/>
<template:addResources type="javascript" resources="jquery.min.js"/>
<template:addResources type="javascript" resources="fullcalendar.js"/>
<template:addResources type="javascript" resources="i18n/calendar-${renderContext.mainResourceLocale}.js"/>
<c:set var="linked" value="${ui:getBindedComponent(currentNode, renderContext, 'j:bindedComponent')}"/>

<c:choose>
    <c:when test="${not empty linked}">
        <template:addCacheDependency node="${linked}"/>
        <template:addCacheDependency flushOnPathMatchingRegexp="${linked.path}/.*"/>
    </c:when>
    <c:otherwise>
        <c:if test="${renderContext.editMode && !renderContext.settings.productionMode}">
            <fmt:message key="jahiaCalendar.not.bound"/>
        </c:if>
    </c:otherwise>
</c:choose>

<c:forEach items="${linked.nodes}" var="linkedChild" varStatus="status">
    <fmt:formatDate pattern="yyyy-MM-dd"
                    value="${linkedChild.properties[currentNode.properties.startDateProperty.string].date.time}"
                    var="startDate"/>
    <c:choose>
        <c:when test="${empty datas[startDate]}">
            <c:set target="${datas}" property="${startDate}" value="1"/>
        </c:when>
        <c:otherwise>
            <c:set target="${datas}" property="${startDate}" value="${datas[startDate]+1}"/>
        </c:otherwise>
    </c:choose>
</c:forEach>
<script type="text/javascript">
    function MergeJSON(o, ob) {
        for (var z in ob) {
            o[z] = ob[z];
        }
        return o;
    }
    $(document).ready(function () {
        // page is now ready, initialize the calendar...
        var calendarOptions = {
            <c:if test="${not empty param.calStartDate}">
            year: ${fn:substring(param.calStartDate,0,4)},
            month:(${fn:substring(param.calStartDate,5,7)}-1),
            date: ${fn:substring(param.calStartDate,8,10)},
            </c:if>
            events:[
                <c:forEach items="${datas}" var="data" varStatus="status">
                <c:url value="${url.base}${renderContext.mainResource.node.path}.html" var="eventUrl">
                <c:param name="filter" value="{name:'${currentNode.properties.startDateProperty.string}',value:'${data.key}',op:'eq',uuid:'${linked.identifier}',format:'yyyy-MM-dd',type:'date'}"/>
                <c:param name="calStartDate" value="${data.key}"/>
                </c:url>
                <c:if test="${not status.first}">,
                </c:if>
                {
                    title:'${data.value}',
                    start:'${data.key}',
                    url:"${eventUrl}"
                }
                </c:forEach>
            ]
        };
        if (!(typeof i18nDefaults === "undefined")) {
            MergeJSON(calendarOptions, i18nDefaults);
        }
        $('#calendar${currentNode.identifier}').fullCalendar(calendarOptions);
        $('#calendar${currentNode.identifier} a').each(function(elem){
            jQuery(this).attr("rel","nofollow");
        });
    });
</script>
<div class="calendar" id="calendar${currentNode.identifier}"></div>
