/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.channels.filters;

import javax.jcr.Value;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelExclusionFilter
extends AbstractFilter {
    protected static transient Logger logger = LoggerFactory.getLogger(ChannelExclusionFilter.class);
    private ChannelService channelService;

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        if (resource.getNode().isNodeType("jmix:channelSelection")) {
            if (!resource.getNode().hasProperty("j:channelSelection")) {
                logger.warn("Channel selection activated on resource " + resource.getPath() + " but no channels selected, please select channels for this function to be activated properly.");
                return null;
            }
            JCRPropertyWrapper channelExclusionProperty = resource.getNode().getProperty("j:channelSelection");
            String includeOrExclude = resource.getNode().hasProperty("j:channelIncludeOrExclude") ? resource.getNode().getProperty("j:channelIncludeOrExclude").getString() : "exclude";
            Value[] channelExclusionValues = channelExclusionProperty.getValues();
            Channel currentChannel = renderContext.getChannel();
            for (Value channelExclusionValue : channelExclusionValues) {
                if (channelExclusionValue.getString() == null) continue;
                boolean inList = this.channelService.matchChannel(channelExclusionValue.getString(), currentChannel);
                if (inList && includeOrExclude.equals("exclude")) {
                    return this.getExcludedResult(resource, renderContext);
                }
                if (!inList || !includeOrExclude.equals("include")) continue;
                return null;
            }
            if (includeOrExclude.equals("include")) {
                return this.getExcludedResult(resource, renderContext);
            }
        }
        return null;
    }

    public String getExcludedResult(Resource resource, RenderContext context) {
        if (!context.isEditMode() || context.getChannel() != null && !context.getChannel().getIdentifier().equals("generic")) {
            return "";
        }
        if (!resource.hasWrapper("unselectedChannel")) {
            resource.pushWrapper("unselectedChannel");
        }
        return null;
    }
}

