/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.csp;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.settings.SettingsBean;

public final class AddContentSecurityPolicy
extends AbstractFilter {
    private static final String CSP_SEPARATOR = ";";
    private static final String CSP_PROPERTY = "policy";
    private static final String CSP_HEADER = "Content-Security-Policy";
    private static final String CSP_REPORT_ONLY_HEADER = "Content-Security-Policy-Report-Only";
    private static final String CSP_WEB_NONCE_PLACEHOLDER = "nonce-";
    public static final String CSP_NONCE_PLACEHOLDER_PROP = "contentSecurityPolicy.nonce.placeHolder";
    private final Base64.Encoder encoder = Base64.getUrlEncoder();
    private final String cspNoncePlaceHolder = SettingsBean.getInstance().getPropertiesFile().getProperty("contentSecurityPolicy.nonce.placeHolder", "XXXXX");

    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        HttpServletResponse response = renderContext.getResponse();
        StringBuilder contentSecurityPolicy = new StringBuilder();
        JCRSiteNode site = renderContext.getSite();
        String siteContentSecurityPolicy = site.hasProperty(CSP_PROPERTY) ? site.getProperty(CSP_PROPERTY).getString() : null;
        String nonce = this.getNonceValue();
        if (StringUtils.isNotEmpty((String)siteContentSecurityPolicy)) {
            String cspHeader;
            contentSecurityPolicy.append(siteContentSecurityPolicy.replace(CSP_WEB_NONCE_PLACEHOLDER, CSP_WEB_NONCE_PLACEHOLDER + nonce));
            if (site.hasProperty("cspReportOnly") && site.getProperty("cspReportOnly").getBoolean()) {
                String reportUri = renderContext.getRequest().getContextPath() + resource.getNodePath() + ".contentSecurityPolicyReportOnly.do";
                contentSecurityPolicy.append(CSP_SEPARATOR).append(" report-uri ").append(reportUri);
                cspHeader = CSP_REPORT_ONLY_HEADER;
            } else {
                cspHeader = CSP_HEADER;
            }
            response.setHeader(cspHeader, contentSecurityPolicy.toString());
        }
        if (site.getInstalledModules().contains("content-security-policy")) {
            return previousOut.replaceAll("nonce=\"" + this.cspNoncePlaceHolder + "\"", "nonce=\"" + nonce + "\"");
        }
        return previousOut;
    }

    private String getNonceValue() {
        UUID uuid = UUID.randomUUID();
        byte[] src = ByteBuffer.wrap(new byte[16]).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
        return this.encoder.encodeToString(src).substring(0, 22);
    }
}

