/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.external.ExternalItemImpl;
import org.jahia.modules.external.ExternalSessionImpl;

public class ExtensionItem
extends ExternalItemImpl
implements Item {
    private Item item;
    private String path;

    public ExtensionItem(Item item, String path, ExternalSessionImpl session) throws RepositoryException {
        super(session);
        this.item = item;
        this.path = path;
        this.session = session;
    }

    public String getPath() throws RepositoryException {
        return this.path;
    }

    public String getName() throws RepositoryException {
        return this.item.getName();
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        if (this.path.equals("/")) {
            throw new ItemNotFoundException();
        }
        String parentPath = StringUtils.substringBeforeLast((String)this.path, (String)"/");
        try {
            this.controlManager.checkRead(parentPath);
        }
        catch (PathNotFoundException e) {
            throw new AccessDeniedException(parentPath);
        }
        try {
            return this.session.getNode(parentPath);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(parentPath);
        }
    }

    @Override
    public boolean isNode() {
        return this.item.isNode();
    }

    @Override
    public boolean isNew() {
        return this.item.isNew();
    }

    @Override
    public boolean isModified() {
        return this.item.isModified();
    }

    @Override
    public boolean isSame(Item otherItem) throws RepositoryException {
        return this.item.isSame(otherItem);
    }

    @Override
    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.item.accept(visitor);
    }

    @Override
    public void refresh(boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        this.item.refresh(keepChanges);
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        if (this.isNode()) {
            if (!this.canRemoveNode()) {
                throw new AccessDeniedException(this.getPath());
            }
        } else {
            this.checkModify();
        }
        this.item.remove();
    }
}

