/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.external.ExtensionItem;
import org.jahia.modules.external.ExternalSessionImpl;

public class ExtensionProperty
extends ExtensionItem
implements Property {
    private Property property;
    private Node parentNode;

    public ExtensionProperty(Property property, String path, ExternalSessionImpl session, Node parentNode) throws RepositoryException {
        super((Item)property, path, session);
        this.property = property;
        this.parentNode = parentNode;
    }

    @Override
    public Node getParent() throws RepositoryException {
        return this.parentNode;
    }

    public void setValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.property.setValue(value);
    }

    public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.property.setValue(values);
    }

    public void setValue(String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.property.setValue(value);
    }

    public void setValue(String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.property.setValue(values);
    }

    public void setValue(InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.property.setValue(value);
    }

    public void setValue(Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.property.setValue(value);
    }

    public void setValue(long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.property.setValue(value);
    }

    public void setValue(double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.property.setValue(value);
    }

    public void setValue(BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.property.setValue(value);
    }

    public void setValue(Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.property.setValue(value);
    }

    public void setValue(boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.property.setValue(value);
    }

    public void setValue(Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.property.setValue(value);
    }

    public Value getValue() throws ValueFormatException, RepositoryException {
        this.checkRead();
        if (StringUtils.equals((String)this.getName(), (String)"jcr:uuid")) {
            return this.getSession().getValueFactory().createValue(this.parentNode.getIdentifier());
        }
        return this.property.getValue();
    }

    public Value[] getValues() throws ValueFormatException, RepositoryException {
        this.checkRead();
        return this.property.getValues();
    }

    public String getString() throws ValueFormatException, RepositoryException {
        this.checkRead();
        return this.property.getValue().getString();
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        this.checkRead();
        final Binary binary = this.property.getValue().getBinary();
        return new AutoCloseInputStream(binary.getStream()){

            public void close() throws IOException {
                super.close();
                binary.dispose();
            }
        };
    }

    public Binary getBinary() throws ValueFormatException, RepositoryException {
        this.checkRead();
        return this.property.getValue().getBinary();
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        this.checkRead();
        return this.property.getValue().getLong();
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        this.checkRead();
        return this.property.getValue().getDouble();
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        this.checkRead();
        return this.property.getValue().getDecimal();
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        this.checkRead();
        return this.property.getValue().getDate();
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        this.checkRead();
        return this.property.getValue().getBoolean();
    }

    public Node getNode() throws ItemNotFoundException, ValueFormatException, RepositoryException {
        this.checkRead();
        return this.property.getNode();
    }

    public Property getProperty() throws ItemNotFoundException, ValueFormatException, RepositoryException {
        this.checkRead();
        return this.property.getProperty();
    }

    public long getLength() throws ValueFormatException, RepositoryException {
        this.checkRead();
        return this.property.getLength();
    }

    public long[] getLengths() throws ValueFormatException, RepositoryException {
        this.checkRead();
        return this.property.getLengths();
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        return this.property.getDefinition();
    }

    public int getType() throws RepositoryException {
        return this.property.getType();
    }

    public boolean isMultiple() throws RepositoryException {
        return this.property.isMultiple();
    }
}

