/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import com.google.common.base.Objects;
import javax.jcr.Item;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.jahia.utils.security.PathWrapper;

public class ExternalPathWrapperImpl
implements PathWrapper {
    private String jcrPath;
    private Session session;

    public ExternalPathWrapperImpl(String jcrPath, Session session) {
        this.jcrPath = jcrPath;
        this.session = session;
    }

    public Object getInnerObject() {
        return this.jcrPath;
    }

    public int getLength() {
        return this.jcrPath.length();
    }

    public boolean isRoot() {
        return "/".equals(this.jcrPath);
    }

    public String getPathStr() {
        return this.jcrPath;
    }

    public String getNodeName() throws NamespaceException {
        return StringUtils.substringAfterLast((String)this.jcrPath, (String)"/");
    }

    public boolean itemExist() throws RepositoryException {
        return this.session.itemExists(this.jcrPath);
    }

    public Item getItem() throws RepositoryException {
        return this.session.getItem(this.jcrPath);
    }

    public PathWrapper getAncestor() throws RepositoryException {
        if (this.jcrPath.lastIndexOf(47) > 0) {
            return new ExternalPathWrapperImpl(this.jcrPath.substring(0, this.jcrPath.lastIndexOf(47)), this.session);
        }
        return new ExternalPathWrapperImpl("/", this.session);
    }

    public PathWrapper getNewPathWrapper(String path) throws RepositoryException {
        return new ExternalPathWrapperImpl(path, this.session);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalPathWrapperImpl that = (ExternalPathWrapperImpl)o;
        return Objects.equal((Object)this.jcrPath, (Object)that.jcrPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.jcrPath});
    }
}

