/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.util.Arrays;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.ArrayUtils;

public class ExternalQuery
implements QueryObjectModel {
    private Column[] columns;
    private Constraint constraints;
    private long limit = -1L;
    private long offset = 0L;
    private Ordering[] orderings;
    private Source source;

    public ExternalQuery(Source source, Constraint constraints, Ordering[] orderings, Column[] columns) {
        this.source = source;
        this.constraints = constraints;
        this.orderings = Arrays.copyOf(orderings, orderings.length);
        this.columns = Arrays.copyOf(columns, columns.length);
    }

    public void bindValue(String varName, Value value) throws IllegalArgumentException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public QueryResult execute() throws InvalidQueryException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String[] getBindVariableNames() throws RepositoryException {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public Column[] getColumns() {
        return Arrays.copyOf(this.columns, this.columns.length);
    }

    public Constraint getConstraint() {
        return this.constraints;
    }

    public String getLanguage() {
        return "JCR-SQL2";
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public Ordering[] getOrderings() {
        return Arrays.copyOf(this.orderings, this.orderings.length);
    }

    public Source getSource() {
        return this.source;
    }

    public String getStatement() {
        return null;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void setLimit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("limit must not be negative");
        }
        this.limit = limit;
    }

    public void setOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset must not be negative");
        }
        this.offset = offset;
    }

    public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ExternalQuery{");
        sb.append("columns=").append(Arrays.toString(this.columns));
        sb.append(", constraints=").append(this.constraints);
        sb.append(", limit=").append(this.limit);
        sb.append(", offset=").append(this.offset);
        sb.append(", orderings=").append(Arrays.toString(this.orderings));
        sb.append(", source=").append(this.source);
        sb.append('}');
        return sb.toString();
    }
}

