/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.modules.external.ExternalDataSource;
import org.jahia.modules.external.ExternalSessionImpl;
import org.jahia.modules.external.ExternalValueImpl;

public class ExternalRepositoryImpl
implements Repository {
    private static final Set<String> STANDARD_KEYS = new HashSet<String>(){
        private static final long serialVersionUID = -7206797627602056140L;
        {
            this.add("query.full.text.search.supported");
            this.add("query.joins");
            this.add("query.languages");
            this.add("query.stored.queries.supported");
            this.add("query.xpath.doc.order");
            this.add("query.xpath.pos.index");
            this.add("jcr.repository.name");
            this.add("jcr.repository.vendor");
            this.add("jcr.repository.vendor.url");
            this.add("jcr.specification.name");
            this.add("jcr.specification.version");
            this.add("write.supported");
            this.add("identifier.stability");
            this.add("level.1.supported");
            this.add("level.2.supported");
            this.add("option.node.type.management.supported");
            this.add("node.type.management.autocreated.definitions.supported");
            this.add("node.type.management.inheritance");
            this.add("node.type.management.multiple.binary.properties.supported");
            this.add("node.type.management.multivalued.properties.supported");
            this.add("node.type.management.orderable.child.nodes.supported");
            this.add("node.type.management.overrides.supported");
            this.add("node.type.management.primary.item.name.supported");
            this.add("node.type.management.property.types");
            this.add("node.type.management.residual.definitions.supported");
            this.add("node.type.management.same.name.siblings.supported");
            this.add("node.type.management.value.constraints.supported");
            this.add("node.type.management.update.in.use.suported");
            this.add("option.access.control.supported");
            this.add("option.journaled.observation.supported");
            this.add("option.lifecycle.supported");
            this.add("option.locking.supported");
            this.add("option.observation.supported");
            this.add("option.node.and.property.with.same.name.supported");
            this.add("option.query.sql.supported");
            this.add("option.retention.supported");
            this.add("option.shareable.nodes.supported");
            this.add("option.simple.versioning.supported");
            this.add("option.transactions.supported");
            this.add("option.unfiled.content.supported");
            this.add("option.update.mixin.node.types.supported");
            this.add("option.update.primary.node.type.supported");
            this.add("option.versioning.supported");
            this.add("option.workspace.management.supported");
            this.add("option.xml.export.supported");
            this.add("option.xml.import.supported");
            this.add("option.activities.supported");
            this.add("option.baselines.supported");
        }
    };
    private ExternalDataSource dataSource;
    private DefaultNamePathResolver namePathResolver;
    private NamespaceRegistry namespaceRegistry;
    private String providerKey;
    private Map<String, Object> repositoryDescriptors = new HashMap<String, Object>();
    private ExternalContentStoreProvider storeProvider;

    public ExternalRepositoryImpl(ExternalContentStoreProvider storeProvider, ExternalDataSource dataSource, NamespaceRegistry nsRegistry) {
        this.storeProvider = storeProvider;
        this.dataSource = dataSource;
        this.namespaceRegistry = nsRegistry;
        this.namePathResolver = new DefaultNamePathResolver(nsRegistry);
        this.initDescriptors();
    }

    public ExternalDataSource getDataSource() {
        return this.dataSource;
    }

    public String getDescriptor(String s) {
        Object descriptorObject = this.repositoryDescriptors.get(s);
        if (descriptorObject instanceof Value) {
            return descriptorObject.toString();
        }
        return null;
    }

    public String[] getDescriptorKeys() {
        return this.repositoryDescriptors.keySet().toArray(new String[this.repositoryDescriptors.size()]);
    }

    public Value getDescriptorValue(String key) {
        Object descriptorObject = this.repositoryDescriptors.get(key);
        if (descriptorObject instanceof Value) {
            return (Value)descriptorObject;
        }
        return null;
    }

    public Value[] getDescriptorValues(String key) {
        Object descriptorObject = this.repositoryDescriptors.get(key);
        if (descriptorObject instanceof Value[]) {
            return (Value[])descriptorObject;
        }
        return null;
    }

    public DefaultNamePathResolver getNamePathResolver() {
        return this.namePathResolver;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public String getProviderKey() {
        return this.providerKey;
    }

    public ExternalContentStoreProvider getStoreProvider() {
        return this.storeProvider;
    }

    private void initDescriptors() {
        this.repositoryDescriptors.put("jcr.specification.version", new ExternalValueImpl("2.0"));
        this.repositoryDescriptors.put("jcr.specification.name", new ExternalValueImpl("Content Repository for Java Technology API"));
        this.repositoryDescriptors.put("jcr.repository.vendor", new ExternalValueImpl("Jahia"));
        this.repositoryDescriptors.put("jcr.repository.vendor.url", new ExternalValueImpl("http://www.jahia.org"));
        this.repositoryDescriptors.put("jcr.repository.name", new ExternalValueImpl("The Web Integration Software"));
        this.repositoryDescriptors.put("jcr.repository.version", new ExternalValueImpl("1.0"));
        this.repositoryDescriptors.put("write.supported", new ExternalValueImpl(this.dataSource instanceof ExternalDataSource.Writable || this.getStoreProvider().getExtensionProvider() != null));
        this.repositoryDescriptors.put("identifier.stability", new ExternalValueImpl("identifier.stability.session.duration"));
        this.repositoryDescriptors.put("node.type.management.inheritance", new ExternalValueImpl("node.type.management.inheritance.minimal"));
        this.repositoryDescriptors.put("node.type.management.overrides.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("node.type.management.primary.item.name.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("node.type.management.orderable.child.nodes.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("node.type.management.residual.definitions.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("node.type.management.autocreated.definitions.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("node.type.management.same.name.siblings.supported", new ExternalValueImpl(false));
        ArrayList<ExternalValueImpl> propertyTypes = new ArrayList<ExternalValueImpl>();
        propertyTypes.add(new ExternalValueImpl(2L));
        propertyTypes.add(new ExternalValueImpl(7L));
        propertyTypes.add(new ExternalValueImpl(8L));
        this.repositoryDescriptors.put("node.type.management.property.types", propertyTypes.toArray(new ExternalValueImpl[propertyTypes.size()]));
        this.repositoryDescriptors.put("node.type.management.multivalued.properties.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("node.type.management.multiple.binary.properties.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("node.type.management.value.constraints.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("node.type.management.update.in.use.suported", new ExternalValueImpl(false));
        if (this.dataSource instanceof ExternalDataSource.Searchable || this.getStoreProvider().getExtensionProvider() != null) {
            this.repositoryDescriptors.put("query.languages", new ExternalValueImpl[]{new ExternalValueImpl("JCR-SQL2")});
        } else {
            this.repositoryDescriptors.put("query.languages", new ExternalValueImpl[0]);
        }
        this.repositoryDescriptors.put("query.stored.queries.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("query.full.text.search.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("query.joins", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("level.1.supported", new ExternalValueImpl(true));
        this.repositoryDescriptors.put("level.2.supported", new ExternalValueImpl(true));
        this.repositoryDescriptors.put("query.xpath.pos.index", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("query.xpath.doc.order", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.access.control.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.activities.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.baselines.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.journaled.observation.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.lifecycle.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.locking.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.node.and.property.with.same.name.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.node.type.management.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.observation.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.query.sql.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.retention.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.shareable.nodes.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.simple.versioning.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.transactions.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.unfiled.content.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.update.mixin.node.types.supported", new ExternalValueImpl(this.dataSource instanceof ExternalDataSource.Writable || this.getStoreProvider().getExtensionProvider() != null));
        this.repositoryDescriptors.put("option.update.primary.node.type.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.versioning.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.workspace.management.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.xml.export.supported", new ExternalValueImpl(false));
        this.repositoryDescriptors.put("option.xml.import.supported", new ExternalValueImpl(false));
        if (this.storeProvider.isSlowConnection()) {
            this.repositoryDescriptors.put("jahia.provider.slowConnection", new ExternalValueImpl(true));
        }
    }

    public boolean isSingleValueDescriptor(String key) {
        return this.repositoryDescriptors.get(key) instanceof Value;
    }

    public boolean isStandardDescriptor(String key) {
        return STANDARD_KEYS.contains(key);
    }

    public Session login() throws LoginException, RepositoryException {
        return new ExternalSessionImpl(this, null, null);
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return new ExternalSessionImpl(this, credentials, null);
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return new ExternalSessionImpl(this, credentials, workspaceName);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return new ExternalSessionImpl(this, null, workspaceName);
    }

    public void setProviderKey(String providerKey) {
        this.providerKey = providerKey;
    }
}

