/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.admin.mount;

import java.io.Serializable;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.external.admin.mount.AbstractMountPointFactory;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRMountPointNode;
import org.jahia.services.render.RenderContext;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.jahia.utils.Url;
import org.json.JSONArray;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractMountPointFactoryHandler<T extends AbstractMountPointFactory>
implements Serializable {
    private static final long serialVersionUID = 6394236759186947423L;
    private static final String SITES_QUERY = "select * from [jnt:virtualsite] as f where ischildnode(f,['/sites'])";
    private static final String FILES_NODENAME = "files";
    private static final String JNT_FOLDER = "jnt:folder";

    public T init(RequestContext requestContext, T mountPointFactory) throws RepositoryException {
        if (mountPointFactory == null) {
            return null;
        }
        String mountPointIdentifier = requestContext.getRequestParameters().get("edit");
        if (StringUtils.isNotEmpty((String)mountPointIdentifier)) {
            return (T)((AbstractMountPointFactory)JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<T>((AbstractMountPointFactory)mountPointFactory, mountPointIdentifier){
                final /* synthetic */ AbstractMountPointFactory val$mountPointFactory;
                final /* synthetic */ String val$mountPointIdentifier;
                {
                    this.val$mountPointFactory = abstractMountPointFactory;
                    this.val$mountPointIdentifier = string;
                }

                public T doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    this.val$mountPointFactory.populate(session.getNodeByIdentifier(this.val$mountPointIdentifier));
                    return this.val$mountPointFactory;
                }
            }));
        }
        return mountPointFactory;
    }

    public Boolean save(final T mountPoint) throws RepositoryException {
        return (Boolean)JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRMountPointNode jcrMountPointNode;
                JCRNodeWrapper mounts = session.getNode("/mounts");
                if (mountPoint.isEdit()) {
                    jcrMountPointNode = (JCRMountPointNode)session.getNode(mountPoint.getInEditMountPointNodePath());
                    if (!jcrMountPointNode.getName().equals(mountPoint.getName() + "-mount")) {
                        jcrMountPointNode.rename(AbstractMountPointFactoryHandler.this.findAvailableNodeName((Node)mounts, JCRContentUtils.escapeLocalNodeName((String)mountPoint.getName()), "-mount"));
                    }
                } else {
                    jcrMountPointNode = (JCRMountPointNode)mounts.addNode(AbstractMountPointFactoryHandler.this.findAvailableNodeName((Node)mounts, JCRContentUtils.escapeLocalNodeName((String)mountPoint.getName()), "-mount"), mountPoint.getMountNodeType());
                }
                jcrMountPointNode.setMountStatus(JCRMountPointNode.MountStatus.mounted);
                if (StringUtils.isNotEmpty((String)mountPoint.getLocalPath())) {
                    jcrMountPointNode.setProperty("mountPoint", session.getNode(mountPoint.getLocalPath()).getIdentifier());
                } else if (mountPoint.isEdit() && jcrMountPointNode.hasProperty("mountPoint")) {
                    jcrMountPointNode.getProperty("mountPoint").remove();
                }
                mountPoint.setProperties((JCRNodeWrapper)jcrMountPointNode);
                session.save();
                JCRStoreProvider provider = jcrMountPointNode.getMountProvider();
                return provider != null && provider.isAvailable();
            }
        });
    }

    public String getAdminURL(RequestContext requestContext) {
        RenderContext renderContext = this.getRenderContext(requestContext);
        Locale locale = LocaleContextHolder.getLocale();
        String server = Url.getServer((HttpServletRequest)renderContext.getRequest());
        String context = renderContext.getURLGenerator().getContext();
        return server + context + "/cms/adminframe/default/" + locale + "/settings.manageMountPoints.html";
    }

    private RenderContext getRenderContext(RequestContext requestContext) {
        return (RenderContext)requestContext.getExternalContext().getRequestMap().get("renderContext");
    }

    protected JSONArray getSiteFolders(Workspace workspace) throws RepositoryException {
        return this.getSiteFolders(workspace, true, FILES_NODENAME, JNT_FOLDER);
    }

    protected JSONArray getSiteFolders(Workspace workspace, String nodeName) throws RepositoryException {
        return this.getSiteFolders(workspace, true, nodeName, JNT_FOLDER);
    }

    protected JSONArray getSiteFolders(Workspace workspace, String nodeName, String folderType) throws RepositoryException {
        return this.getSiteFolders(workspace, true, nodeName, folderType);
    }

    protected JSONArray getSiteFolders(Workspace workspace, boolean local) throws RepositoryException {
        return this.getSiteFolders(workspace, local, FILES_NODENAME, JNT_FOLDER);
    }

    protected JSONArray getSiteFolders(Workspace workspace, boolean local, String nodeName, String folderType) throws RepositoryException {
        JSONArray folders = new JSONArray();
        Query sitesQuery = workspace.getQueryManager().createQuery(SITES_QUERY, "JCR-SQL2");
        NodeIterator sites = sitesQuery.execute().getNodes();
        while (sites.hasNext()) {
            Node siteFiles;
            Node site = sites.nextNode();
            try {
                siteFiles = site.getNode(nodeName);
                folders.put((Object)this.escape(siteFiles.getPath()));
            }
            catch (RepositoryException e) {
                continue;
            }
            StringBuilder filter = new StringBuilder("isdescendantnode(f,['").append(JCRContentUtils.sqlEncode((String)siteFiles.getPath())).append("'])");
            for (JCRStoreProvider provider : JCRStoreService.getInstance().getSessionFactory().getProviderList()) {
                if (provider.isDefault() || !StringUtils.startsWith((String)provider.getMountPoint(), (String)siteFiles.getPath())) continue;
                filter.append(" and (not isdescendantnode(f,['").append(JCRContentUtils.sqlEncode((String)provider.getMountPoint())).append("']))");
            }
            Query siteFoldersQuery = workspace.getQueryManager().createQuery("select * from [" + folderType + "] as f where " + filter, "JCR-SQL2");
            NodeIterator siteFolders = siteFoldersQuery.execute().getNodes();
            while (siteFolders.hasNext()) {
                Node siteFolder = siteFolders.nextNode();
                folders.put((Object)this.escape(siteFolder.getPath()));
            }
        }
        return folders;
    }

    protected String escape(String path) {
        return StringUtils.isNotEmpty((String)path) ? StringEscapeUtils.escapeXml((String)path) : path;
    }

    private String findAvailableNodeName(Node dest, String name, String suffix) {
        int und;
        int i = 1;
        String basename = name;
        int dot = basename.lastIndexOf(46);
        String ext = "";
        if (dot > 0) {
            ext = basename.substring(dot);
            basename = basename.substring(0, dot);
        }
        if ((und = basename.lastIndexOf(45)) > -1 && Patterns.NUMBERS.matcher(basename.substring(und + 1)).matches()) {
            basename = basename.substring(0, und);
        }
        try {
            while (true) {
                dest.getNode(name + suffix);
                String newSuffix = "-" + i++ + ext;
                name = basename + newSuffix;
                int maxNameSize = SettingsBean.getInstance().getMaxNameSize();
                if (name.length() <= maxNameSize) continue;
                name = basename.substring(0, (basename.length() <= maxNameSize ? basename.length() : maxNameSize) - newSuffix.length()) + newSuffix;
            }
        }
        catch (RepositoryException e) {
            return name + suffix;
        }
    }
}

