/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.events;

import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.jahia.modules.external.ExternalData;
import org.jahia.modules.external.ExternalSessionImpl;
import org.jahia.modules.external.events.EventService;
import org.jahia.modules.external.events.model.ApiEventImpl;
import org.jahia.services.content.ApiEvent;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventServiceImpl
implements EventService {
    private static final Logger logger = LoggerFactory.getLogger(EventServiceImpl.class);

    @Override
    public void sendEvents(Iterable<? extends ApiEvent> events, JCRStoreProvider provider) throws RepositoryException {
        EventServiceImpl.doSendEvents(events, provider);
    }

    @Override
    public void sendAddedNodes(Iterable<ExternalData> data, JCRStoreProvider provider) throws RepositoryException {
        EventServiceImpl.doSendEvents(() -> StreamSupport.stream(data.spliterator(), false).map(this::addedEventFromData).iterator(), provider);
    }

    @Override
    public ApiEvent addedEventFromData(ExternalData data) {
        return new ApiEventImpl(data);
    }

    public static void doSendEvents(Iterable<? extends ApiEvent> events, JCRStoreProvider provider) throws RepositoryException {
        logger.info("Received API events for " + provider.getKey());
        JCRCallback callback = jcrSessionWrapper -> {
            for (ApiEvent apiEvent : events) {
                logger.debug("Event {} for {}", (Object)apiEvent.getType(), (Object)apiEvent.getPath());
                ExternalData data = (ExternalData)apiEvent.getInfo().get("externalData");
                if (data != null) {
                    logger.debug("External data included for {}", (Object)data.getPath());
                    ExternalSessionImpl externalSession = (ExternalSessionImpl)jcrSessionWrapper.getProviderSession(provider);
                    externalSession.registerNode(data);
                }
                JCRObservationManager.addEvent((Event)apiEvent, (String)provider.getMountPoint(), (String)"");
            }
            return null;
        };
        logger.debug("Processing API events for default");
        JCRObservationManager.doWorkspaceWriteCall((JCRSessionWrapper)JCRSessionFactory.getInstance().getCurrentSystemSession("default", null, null), (int)14, (JCRCallback)callback);
        logger.debug("Processing API events for live");
        JCRObservationManager.doWorkspaceWriteCall((JCRSessionWrapper)JCRSessionFactory.getInstance().getCurrentSystemSession("live", null, null), (int)14, (JCRCallback)callback);
        logger.info("API events processed");
    }
}

