/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.events.model;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.jackrabbit.util.ISO8601;
import org.hibernate.validator.constraints.NotEmpty;
import org.jahia.modules.external.ExternalData;
import org.jahia.modules.external.events.model.EventInfoAdapter;
import org.jahia.modules.external.events.validation.ValidExternalData;
import org.jahia.modules.external.events.validation.ValidISO8601;
import org.jahia.services.content.ApiEvent;

public class ApiEventImpl
implements ApiEvent {
    @Pattern(regexp="NODE_ADDED|NODE_REMOVED|PROPERTY_ADDED|PROPERTY_REMOVED|PROPERTY_CHANGED|NODE_MOVED")
    private String type = "NODE_ADDED";
    @NotEmpty
    private String path;
    private String userID = "";
    private String identifier;
    @ValidExternalData
    private Map info = new HashMap();
    private String userData;
    @ValidISO8601
    private String date;

    public ApiEventImpl() {
    }

    public ApiEventImpl(ExternalData data) {
        this.setPath(data.getPath());
        this.setIdentifier(data.getId());
        this.info.put("externalData", data);
    }

    public int getType() {
        return EventType.valueOf(this.type).getValue();
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @XmlJavaTypeAdapter(value=EventInfoAdapter.class)
    public Map getInfo() {
        return this.info;
    }

    public void setInfo(Map info) {
        this.info = info;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public long getDate() {
        return ISO8601.parse((String)this.date).getTimeInMillis();
    }

    public void setDate(String date) {
        this.date = date;
    }

    public static enum EventType {
        NODE_ADDED(1),
        NODE_REMOVED(2),
        PROPERTY_ADDED(4),
        PROPERTY_REMOVED(8),
        PROPERTY_CHANGED(16),
        NODE_MOVED(32);

        private final int value;

        private EventType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

