/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.events.model;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Array;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.Binary;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.jahia.modules.external.ExternalBinaryImpl;
import org.jahia.modules.external.ExternalData;

public class EventInfoAdapter
extends XmlAdapter<Map<String, Object>, Map<String, Object>> {
    public Map<String, Object> unmarshal(Map<String, Object> info) throws Exception {
        Map dataAsMap = (Map)info.get("externalData");
        if (dataAsMap != null) {
            HashMap<String, Object> transformed = new HashMap<String, Object>(info);
            ExternalData data = new ExternalData((String)dataAsMap.get("id"), (String)dataAsMap.get("path"), (String)dataAsMap.get("type"), dataAsMap.containsKey("properties") ? this.convertMembersFromListToArray((Map)dataAsMap.get("properties"), String.class) : Collections.emptyMap());
            if (dataAsMap.containsKey("mixin")) {
                data.setMixin((List)dataAsMap.get("mixin"));
            }
            if (dataAsMap.containsKey("i18nProperties")) {
                Map i18nProperties = (Map)dataAsMap.get("i18nProperties");
                HashMap<String, Map<String, String[]>> convertedI18nProperties = new HashMap<String, Map<String, String[]>>();
                for (Map.Entry entry : i18nProperties.entrySet()) {
                    convertedI18nProperties.put((String)entry.getKey(), this.convertMembersFromListToArray((Map)entry.getValue(), String.class));
                }
                data.setI18nProperties(convertedI18nProperties);
            }
            if (dataAsMap.containsKey("binaryProperties")) {
                data.setBinaryProperties(this.convertMembersFromListToArray((Map)dataAsMap.get("binaryProperties"), Binary.class, s -> new ExternalBinaryImpl(new ByteArrayInputStream(Base64.getDecoder().decode((String)s)))));
            }
            transformed.put("externalData", data);
            return transformed;
        }
        return info;
    }

    public Map<String, Object> marshal(Map<String, Object> info) throws Exception {
        return info;
    }

    private <T> Map<String, T[]> convertMembersFromListToArray(Map<String, List<T>> map, Class<T> itemType) {
        return this.convertMembersFromListToArray(map, itemType, u -> u);
    }

    private <T, U> Map<String, T[]> convertMembersFromListToArray(Map<String, List<U>> map, Class<T> itemType, Function<U, T> f) {
        HashMap<String, T[]> m = new HashMap<String, T[]>();
        for (Map.Entry<String, List<U>> entry : map.entrySet()) {
            List<U> list = entry.getValue();
            m.put(entry.getKey(), list.stream().map(f).collect(Collectors.toList()).toArray((Object[])Array.newInstance(itemType, list.size())));
        }
        return m;
    }
}

