/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.events.rest;

import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.modules.external.events.EventServiceImpl;
import org.jahia.modules.external.events.model.ApiEventImpl;
import org.jahia.modules.external.events.rest.EventApiConfig;
import org.jahia.modules.external.events.validation.ValidList;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRStoreProvider;

@Path(value="/external-provider/events")
@Produces(value={"application/json"})
public class EventResource {
    private EventApiConfig eventApiConfig;

    @Inject
    public EventResource(EventApiConfig eventApiConfig) {
        this.eventApiConfig = eventApiConfig;
    }

    @POST
    @Path(value="/{providerKey:.*}")
    @Consumes(value={"application/json"})
    public Response postEvents(@Valid ValidList<ApiEventImpl> events, @PathParam(value="providerKey") String providerKey, @HeaderParam(value="apiKey") String apiKey) throws RepositoryException {
        if (!(JCRSessionFactory.getInstance().getProviders().get(providerKey) instanceof ExternalContentStoreProvider)) {
            Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)("No external provider found (invalidValue = " + providerKey + ")"));
            return response.build();
        }
        JCRStoreProvider provider = (JCRStoreProvider)JCRSessionFactory.getInstance().getProviders().get(providerKey);
        if (!this.eventApiConfig.checkApiKey(apiKey, providerKey)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (provider instanceof ExternalContentStoreProvider) {
            EventServiceImpl.doSendEvents(events, provider);
        }
        return Response.ok().build();
    }
}

