/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.events.rest;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.BeanDescriptor;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.Parameter;
import org.jahia.services.content.JCRSessionFactory;

public class SimpleValidationFeature
implements Feature {
    public boolean configure(FeatureContext context) {
        context.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bindFactory(ConfiguredValidatorFactory.class, Singleton.class).to(ConfiguredValidator.class).in(PerLookup.class);
            }
        });
        context.register(ValidationExceptionMapper.class);
        return true;
    }

    public static class ValidationExceptionMapper
    implements ExceptionMapper<ValidationException> {
        public Response toResponse(ValidationException exception) {
            if (exception instanceof ConstraintViolationException) {
                ConstraintViolationException cve = (ConstraintViolationException)exception;
                Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                response.type(MediaType.TEXT_PLAIN_TYPE);
                StringBuilder builder = new StringBuilder();
                for (ConstraintViolation violation : cve.getConstraintViolations()) {
                    builder.append(violation.getMessage());
                    builder.append(' ');
                    builder.append('(');
                    builder.append("path = ");
                    builder.append(violation.getPropertyPath());
                    builder.append(',');
                    builder.append(' ');
                    builder.append("invalidValue = ");
                    builder.append(violation.getInvalidValue());
                    builder.append(')');
                    builder.append('\n');
                }
                response.entity((Object)builder.toString());
                return response.build();
            }
            return Response.serverError().entity((Object)exception.getMessage()).build();
        }
    }

    public static class ConfiguredValidatorImpl
    implements ConfiguredValidator {
        private final Validator delegate;

        public ConfiguredValidatorImpl(Validator delegate) {
            this.delegate = delegate;
        }

        public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
            return this.delegate.validate(object, (Class[])groups);
        }

        public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
            return this.delegate.validateProperty(object, propertyName, (Class[])groups);
        }

        public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
            return this.delegate.validateValue(beanType, propertyName, value, (Class[])groups);
        }

        public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
            return this.delegate.getConstraintsForClass(clazz);
        }

        public <T> T unwrap(Class<T> type) {
            return (T)this.delegate.unwrap(type);
        }

        public ExecutableValidator forExecutables() {
            return this.delegate.forExecutables();
        }

        public void validateResourceAndInputParams(Object resource, Invocable resourceMethod, Object[] args) throws ConstraintViolationException {
            HashSet<ConstraintViolation<Object>> constraintViolations = new HashSet<ConstraintViolation<Object>>();
            BeanDescriptor beanDescriptor = this.getConstraintsForClass(resource.getClass());
            if (beanDescriptor.isBeanConstrained()) {
                constraintViolations.addAll(this.validate(resource, new Class[0]));
            }
            block2: for (int i = 0; i < resourceMethod.getParameters().size(); ++i) {
                Parameter parameter = (Parameter)resourceMethod.getParameters().get(i);
                for (Annotation annotation : parameter.getAnnotations()) {
                    if (!Valid.class.isAssignableFrom(annotation.annotationType())) continue;
                    try {
                        if (args == null || args[i] == null) continue block2;
                        constraintViolations.addAll(this.validate(args[i], new Class[0]));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    continue block2;
                }
            }
            if (!constraintViolations.isEmpty()) {
                throw new ConstraintViolationException(constraintViolations);
            }
        }

        public void validateResult(Object resource, Invocable resourceMethod, Object result) throws ConstraintViolationException {
        }
    }

    public static class ConfiguredValidatorFactory
    implements Factory<ConfiguredValidator> {
        public ConfiguredValidator provide() {
            return new ConfiguredValidatorImpl(JCRSessionFactory.getInstance().getValidatorFactoryBean().getValidator());
        }

        public void dispose(ConfiguredValidator configuredValidator) {
        }
    }
}

