/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.id;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.jcr.RepositoryException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.jahia.modules.external.ExternalProviderInitializerService;
import org.jahia.modules.external.id.ExternalProviderID;
import org.jahia.modules.external.id.UuidMapping;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalProviderInitializerServiceImpl
implements ExternalProviderInitializerService {
    private static final String ID_CACHE_NAME = "ExternalIdentifierMapping";
    private static final Logger logger = LoggerFactory.getLogger(ExternalProviderInitializerServiceImpl.class);
    private SessionFactory hibernateSessionFactory;
    private Cache idCache;
    private List<String> overridableItemsForLocks;
    private List<String> overridableItemsForACLs;
    private JCRStoreProvider extensionProvider;

    @Override
    public void delete(List<String> externalIds, String providerKey, boolean includeDescendants) throws RepositoryException {
        if (externalIds.isEmpty()) {
            return;
        }
        try (StatelessSession session = null;){
            session = this.hibernateSessionFactory.openStatelessSession();
            session.beginTransaction();
            LinkedList<Integer> hashes = new LinkedList<Integer>();
            for (String string : externalIds) {
                hashes.add(string.hashCode());
            }
            List results = session.createQuery("from UuidMapping where providerKey=:providerKey and externalIdHash in (:idHashes)").setString("providerKey", providerKey).setParameterList("idHashes", hashes).setReadOnly(true).list();
            for (Object result : results) {
                UuidMapping uuidMapping = (UuidMapping)result;
                if (!externalIds.contains(uuidMapping.getExternalId())) continue;
                session.delete((Object)uuidMapping);
            }
            if (includeDescendants) {
                Query query = session.createQuery("from UuidMapping where providerKey=:providerKey and externalId like :externalId").setString("providerKey", providerKey);
                for (String externalId : externalIds) {
                    query.setString("externalId", externalId + "/%");
                    List descendants = query.list();
                    for (Object mapping : descendants) {
                        UuidMapping m = (UuidMapping)mapping;
                        session.delete((Object)m);
                        this.invalidateCache(m.getExternalId(), providerKey);
                    }
                }
            }
            session.getTransaction().commit();
            for (String externalId : externalIds) {
                this.invalidateCache(externalId, providerKey);
            }
        }
    }

    private String getCacheKey(String externalId, String providerKey) {
        return providerKey + "-" + externalId;
    }

    @Override
    public String getExternalIdentifier(String internalId) throws RepositoryException {
        String externalId = null;
        try (StatelessSession session = null;){
            session = this.getHibernateSessionFactory().openStatelessSession();
            session.beginTransaction();
            UuidMapping mapping = (UuidMapping)session.get(UuidMapping.class, (Serializable)((Object)internalId));
            if (mapping != null) {
                externalId = mapping.getExternalId();
            }
            session.getTransaction().commit();
        }
        return externalId;
    }

    public SessionFactory getHibernateSessionFactory() {
        return this.hibernateSessionFactory;
    }

    public Cache getIdentifierCache() {
        return this.idCache;
    }

    @Override
    public String getInternalIdentifier(String externalId, String providerKey) throws RepositoryException {
        String uuid;
        String cacheKey = this.getCacheKey(externalId, providerKey);
        Cache idCache = this.getIdentifierCache();
        Element cacheElement = idCache.get((Serializable)((Object)cacheKey));
        String string = uuid = cacheElement != null ? (String)cacheElement.getObjectValue() : null;
        if (uuid == null) {
            try (StatelessSession session = null;){
                session = this.getHibernateSessionFactory().openStatelessSession();
                session.beginTransaction();
                List results = session.createQuery("from UuidMapping where providerKey=:providerKey and externalIdHash=:idHash").setString("providerKey", providerKey).setLong("idHash", (long)externalId.hashCode()).setReadOnly(true).list();
                for (Object result : results) {
                    UuidMapping uuidMapping = (UuidMapping)result;
                    if (!uuidMapping.getExternalId().equals(externalId)) continue;
                    uuid = uuidMapping.getInternalUuid();
                    idCache.put(new Element((Object)cacheKey, (Object)uuid, true));
                }
                session.getTransaction().commit();
            }
        }
        return uuid;
    }

    @Override
    public Integer getProviderId(String providerKey) throws RepositoryException {
        ExternalProviderID providerId;
        block9: {
            providerId = null;
            SessionFactory hibernateSession = this.getHibernateSessionFactory();
            try (Session session = null;){
                session = hibernateSession.openSession();
                List list = session.createQuery("from ExternalProviderID where providerKey=:providerKey").setString("providerKey", providerKey).setReadOnly(true).setFlushMode(FlushMode.MANUAL).list();
                if (list.size() > 0) {
                    providerId = (ExternalProviderID)list.get(0);
                    break block9;
                }
                providerId = new ExternalProviderID();
                providerId.setProviderKey(providerKey);
                try {
                    session.beginTransaction();
                    session.save((Object)providerId);
                    session.getTransaction().commit();
                }
                catch (Exception e) {
                    session.getTransaction().rollback();
                    throw new RepositoryException("Issue when storing external provider ID for provider " + providerId, (Throwable)e);
                }
            }
        }
        return providerId.getId();
    }

    private void invalidateCache(String externalId, String providerKey) {
        this.getIdentifierCache().remove((Serializable)((Object)this.getCacheKey(externalId, providerKey)));
    }

    @Override
    public String mapInternalIdentifier(String externalId, String providerKey, String providerId) throws RepositoryException {
        UuidMapping uuidMapping = new UuidMapping();
        uuidMapping.setExternalId(externalId);
        uuidMapping.setProviderKey(providerKey);
        uuidMapping.setInternalUuid(providerId + "-" + StringUtils.substringAfter((String)UUID.randomUUID().toString(), (String)"-"));
        Session session = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader previousClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            session = this.getHibernateSessionFactory().openSession();
            session.beginTransaction();
            session.save((Object)uuidMapping);
            session.getTransaction().commit();
            this.getIdentifierCache().put(new Element((Object)this.getCacheKey(externalId, providerKey), (Object)uuidMapping.getInternalUuid(), true));
        }
        catch (Exception e) {
            if (session != null) {
                session.getTransaction().rollback();
            }
            throw new RepositoryException("Error storing mapping for external node " + externalId + " [provider: " + providerKey + "]", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.close();
            }
            currentThread.setContextClassLoader(previousClassLoader);
        }
        return uuidMapping.getInternalUuid();
    }

    @Override
    public void removeProvider(String providerKey) throws RepositoryException {
        SessionFactory hibernateSession = this.getHibernateSessionFactory();
        try (StatelessSession session = null;){
            session = hibernateSession.openStatelessSession();
            session.beginTransaction();
            int deletedCount = session.createQuery("delete from ExternalProviderID where providerKey=:providerKey").setString("providerKey", providerKey).executeUpdate();
            if (deletedCount > 0) {
                logger.info("Deleted external provider entry for key {}", (Object)providerKey);
                deletedCount = session.createQuery("delete from UuidMapping where providerKey=:providerKey").setString("providerKey", providerKey).executeUpdate();
                logger.info("Deleted {} identifier mapping entries for external provider with key {}", (Object)deletedCount, (Object)providerKey);
            } else {
                logger.info("No external provider entry found for key {}", (Object)providerKey);
            }
            session.getTransaction().commit();
        }
    }

    public void setHibernateSessionFactory(SessionFactory hibernateSession) {
        this.hibernateSessionFactory = hibernateSession;
    }

    public void setCacheProvider(EhCacheProvider cacheProvider) {
        this.idCache = cacheProvider.getCacheManager().getCache(ID_CACHE_NAME);
        if (this.idCache == null) {
            cacheProvider.getCacheManager().addCache(ID_CACHE_NAME);
            this.idCache = cacheProvider.getCacheManager().getCache(ID_CACHE_NAME);
        }
    }

    @Override
    public void updateExternalIdentifier(String oldExternalId, String newExternalId, String providerKey, boolean includeDescendants) throws RepositoryException {
        try (Session session = null;){
            ArrayList<String> invalidate = new ArrayList<String>();
            session = this.getHibernateSessionFactory().openSession();
            session.beginTransaction();
            List results = session.createQuery("from UuidMapping where providerKey=:providerKey and externalIdHash=:idHash").setString("providerKey", providerKey).setLong("idHash", (long)oldExternalId.hashCode()).list();
            for (Object result : results) {
                UuidMapping uuidMapping = (UuidMapping)result;
                if (!uuidMapping.getExternalId().equals(oldExternalId)) continue;
                uuidMapping.setExternalId(newExternalId);
                invalidate.add(oldExternalId);
            }
            if (includeDescendants) {
                List descendants = session.createQuery("from UuidMapping where providerKey=:providerKey and externalId like :externalId").setString("providerKey", providerKey).setString("externalId", oldExternalId + "/%").list();
                for (Object mapping : descendants) {
                    UuidMapping m = (UuidMapping)mapping;
                    m.setExternalId(newExternalId + StringUtils.substringAfter((String)m.getExternalId(), (String)oldExternalId));
                    invalidate.add(m.getExternalId());
                }
            }
            session.getTransaction().commit();
            for (String id : invalidate) {
                this.invalidateCache(id, providerKey);
            }
        }
    }

    public void setOverridableItemsForLocks(List<String> overridableItemsForLocks) {
        this.overridableItemsForLocks = overridableItemsForLocks;
    }

    public void setOverridableItemsForACLs(List<String> overridableItemsForACLs) {
        this.overridableItemsForACLs = overridableItemsForACLs;
    }

    public void setExtensionProvider(JCRStoreProvider extensionProvider) {
        this.extensionProvider = extensionProvider;
    }

    @Override
    public List<String> getOverridableItemsForLocks() {
        return this.overridableItemsForLocks;
    }

    @Override
    public List<String> getOverridableItemsForACLs() {
        return this.overridableItemsForACLs;
    }

    @Override
    public JCRStoreProvider getExtensionProvider() {
        return this.extensionProvider;
    }
}

