/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.apitokens.graphql;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.connection.GraphQLConnection;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.jahia.api.usermanager.JahiaUserManagerService;
import org.jahia.modules.apitokens.TokenDetails;
import org.jahia.modules.apitokens.TokenService;
import org.jahia.modules.apitokens.graphql.GqlScope;
import org.jahia.modules.apitokens.graphql.GqlToken;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;
import org.jahia.modules.graphql.provider.dxm.predicate.SorterHelper;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.relay.PaginationHelper;
import org.jahia.modules.graphql.provider.dxm.util.ContextUtil;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.securityfilter.PermissionService;

@GraphQLName(value="PersonalApiTokensQuery")
@GraphQLDescription(value="Queries for Personal Api Tokens")
public class GqlPersonalApiTokensQuery {
    @Inject
    @GraphQLOsgiService
    private TokenService tokensService;
    @Inject
    @GraphQLOsgiService
    private JCRTemplate jcrTemplate;
    @Inject
    @GraphQLOsgiService
    private JahiaUserManagerService userManagerService;
    @Inject
    @GraphQLOsgiService
    private PermissionService permissionService;

    @GraphQLField
    @GraphQLDescription(value="Check if the token is valid for authentication")
    public boolean verifyToken(@GraphQLName(value="token") @GraphQLDescription(value="The token") @GraphQLNonNull String token) {
        try {
            TokenDetails tokenDetails = this.tokensService.verifyToken(token, this.jcrTemplate.getSessionFactory().getCurrentUserSession());
            if (tokenDetails != null) {
                return tokenDetails.isValid();
            }
            return false;
        }
        catch (Exception e) {
            throw new DataFetchingException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Get token details, based on key")
    public GqlToken getTokenByKey(@GraphQLName(value="key") @GraphQLDescription(value="The token key") @GraphQLNonNull String key) {
        try {
            TokenDetails tokenDetails = this.tokensService.getTokenDetails(key, this.jcrTemplate.getSessionFactory().getCurrentUserSession());
            if (tokenDetails != null) {
                return new GqlToken(tokenDetails);
            }
            return null;
        }
        catch (Exception e) {
            throw new DataFetchingException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Get token details, based on user and token name")
    public GqlToken getTokenByUserAndName(@GraphQLName(value="userId") @GraphQLDescription(value="The user id") @GraphQLNonNull String userId, @GraphQLName(value="site") @GraphQLDescription(value="The site the user belongs to, null if global user") String site, @GraphQLName(value="tokenName") @GraphQLDescription(value="The token name") @GraphQLNonNull String tokenName) {
        JCRUserNode userNode = this.userManagerService.lookupUser(userId, site);
        if (userNode == null) {
            throw new DataFetchingException("Cannot find user");
        }
        try {
            TokenDetails tokenDetails = this.tokensService.getTokenDetails(userNode.getPath(), tokenName, this.jcrTemplate.getSessionFactory().getCurrentUserSession());
            if (tokenDetails != null) {
                return new GqlToken(tokenDetails);
            }
            return null;
        }
        catch (Exception e) {
            throw new DataFetchingException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="List tokens attached to the provided user ID and site key")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    public DXPaginatedData<GqlToken> getTokens(@GraphQLName(value="userId") @GraphQLDescription(value="If a userId is provided, only returns tokens assigned to that user.") String userId, @GraphQLName(value="site") @GraphQLDescription(value="The site the user belongs to, null if global user") String site, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput fieldSorter, DataFetchingEnvironment environment) {
        PaginationHelper.Arguments arguments = PaginationHelper.parseArguments((DataFetchingEnvironment)environment);
        try {
            String userPath = null;
            if (userId != null) {
                JCRUserNode userNode = this.userManagerService.lookupUser(userId, site);
                if (userNode == null) {
                    throw new DataFetchingException("Unknown user");
                }
                userPath = userNode.getPath();
            }
            Stream<GqlToken> tokens = this.tokensService.getTokensDetails(userPath, this.jcrTemplate.getSessionFactory().getCurrentUserSession()).map(GqlToken::new);
            if (fieldSorter != null) {
                tokens = tokens.sorted(SorterHelper.getFieldComparator((FieldSorterInput)fieldSorter, (FieldEvaluator)FieldEvaluator.forConnection((DataFetchingEnvironment)environment)));
            }
            return PaginationHelper.paginate(tokens, n -> PaginationHelper.encodeCursor((String)n.getKey()), (PaginationHelper.Arguments)arguments);
        }
        catch (Exception e) {
            throw new DataFetchingException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Get available scopes")
    public Collection<GqlScope> getAvailableScopes(DataFetchingEnvironment environment) {
        HttpServletRequest httpRequest = ContextUtil.getHttpServletRequest((Object)environment.getContext());
        return this.permissionService.getAvailableScopes().stream().filter(s -> "true".equals(s.getMetadata().get("visible"))).filter(s -> s.isValid(httpRequest)).map(GqlScope::new).collect(Collectors.toList());
    }
}

