/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.apitokens.graphql;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import javax.inject.Inject;
import org.jahia.api.usermanager.JahiaUserManagerService;
import org.jahia.modules.apitokens.TokenDetails;
import org.jahia.modules.apitokens.graphql.TokenState;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.user.GqlUser;
import org.joda.time.DateTime;

@GraphQLName(value="PersonalApiToken")
@GraphQLDescription(value="Token details")
public class GqlToken {
    private TokenDetails tokenDetails;
    @Inject
    @GraphQLOsgiService
    private JahiaUserManagerService userManagerService;

    public GqlToken(TokenDetails tokenDetails) {
        this.tokenDetails = tokenDetails;
    }

    @GraphQLField
    @GraphQLDescription(value="The name of the token")
    public String getName() {
        return this.tokenDetails.getName();
    }

    @GraphQLField
    @GraphQLDescription(value="The key of the token, used for looking it up")
    public String getKey() {
        return this.tokenDetails.getKey();
    }

    @GraphQLField
    @GraphQLDescription(value="The user associated to the token")
    public GqlUser getUser() {
        return new GqlUser(this.userManagerService.lookupUserByPath(this.tokenDetails.getUserPath()).getJahiaUser());
    }

    @GraphQLField
    @GraphQLDescription(value="Creation date and time")
    public String getCreatedAt() {
        return this.tokenDetails.getCreationDate() != null ? new DateTime(this.tokenDetails.getCreationDate().getTime().getTime()).toString() : null;
    }

    @GraphQLField
    @GraphQLDescription(value="Last modification date and time")
    public String getUpdatedAt() {
        return this.tokenDetails.getModificationDate() != null ? new DateTime(this.tokenDetails.getModificationDate().getTime().getTime()).toString() : null;
    }

    @GraphQLField
    @GraphQLDescription(value="Expiration date")
    public String getExpireAt() {
        return this.tokenDetails.getExpirationDate() != null ? new DateTime(this.tokenDetails.getExpirationDate().getTime().getTime()).toString() : null;
    }

    @GraphQLField
    @GraphQLDescription(value="Token state")
    public TokenState getState() {
        return this.tokenDetails.isActive() ? TokenState.ACTIVE : TokenState.DISABLED;
    }
}

