/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.messages;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.i18n.client.Dictionary;
import java.util.MissingResourceException;

public class Messages {
    public static final String DICTIONARY_NAME = "jahia_gwt_messages";

    public static String get(String key) {
        return Messages.get(key, key);
    }

    public static String get(String key, String defaultValue) {
        String value = defaultValue;
        if (key != null) {
            try {
                Dictionary dict = Dictionary.getDictionary((String)DICTIONARY_NAME);
                value = dict.get(Messages.normalizeKey(key));
            }
            catch (MissingResourceException e) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Can't retrieve [" + key + "]. Using default value: " + defaultValue), (Throwable)e);
                }
            }
            catch (Exception e) {
                Log.error((String)("Can't retrieve [" + key + "]. Using default value: " + defaultValue + ". Cause: " + e.getMessage()), (Throwable)e);
            }
        } else if (Log.isDebugEnabled()) {
            Log.debug((String)("Provided key is null. Using default value: " + defaultValue));
        }
        return value;
    }

    private static String normalizeKey(String key) {
        String normalized;
        String string = normalized = key.indexOf(46) != -1 ? key.replace('.', '_') : key;
        if (normalized.indexOf(45) != -1) {
            normalized = normalized.replace('-', '_');
        }
        return normalized;
    }

    public static String getWithArgs(String key, String defaultValue, Object[] args) {
        String msg = Messages.get(key, defaultValue);
        if (msg != null && msg.contains("{0}") && args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String placeholder = "{" + i + "}";
                if (!msg.contains(placeholder)) continue;
                msg = msg.replace(placeholder, String.valueOf(args[i]));
            }
        }
        return msg;
    }
}

