/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget;

import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTBitSet;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.util.content.CopyPasteEngine;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;

public class LinkerSelectionContext {
    public static final int BOTH = 1;
    public static final int MAIN_NODE_ONLY = 2;
    public static final int SELECTED_NODE_ONLY = 3;
    private GWTJahiaNode mainNode;
    private List<GWTJahiaNode> selectedNodes;
    private GWTJahiaNode singleSelection;
    private List<GWTJahiaNode> multipleSelection;
    private GWTJahiaNode parent;
    private boolean isSecondarySelection;
    private boolean pasteAllowed;
    private GWTBitSet permissions;
    private boolean isRootNode;
    private boolean parentWriteable;
    private boolean lockable;
    private boolean locked;
    private boolean file;
    private boolean zip;
    private boolean image;

    public void setMainNode(GWTJahiaNode selectedTreeNode) {
        this.mainNode = selectedTreeNode;
    }

    public void setSelectedNodes(List<GWTJahiaNode> selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    public void refresh(int context) {
        switch (context) {
            case 2: {
                this.multipleSelection = new ArrayList<GWTJahiaNode>();
                if (this.mainNode != null) {
                    this.multipleSelection.add(this.mainNode);
                }
                this.singleSelection = this.mainNode;
                this.isSecondarySelection = false;
                break;
            }
            case 3: {
                if (this.selectedNodes == null) break;
                this.multipleSelection = this.selectedNodes;
                this.singleSelection = this.selectedNodes.size() == 1 ? this.selectedNodes.get(0) : null;
                this.isSecondarySelection = false;
                break;
            }
            default: {
                if (this.selectedNodes != null) {
                    this.multipleSelection = this.selectedNodes;
                    if (this.selectedNodes.size() == 1) {
                        this.singleSelection = this.selectedNodes.get(0);
                    } else if (this.selectedNodes.size() == 0) {
                        this.singleSelection = this.mainNode;
                        if (this.mainNode != null) {
                            this.multipleSelection = new ArrayList<GWTJahiaNode>();
                            this.multipleSelection.add(this.mainNode);
                        }
                    } else {
                        this.singleSelection = null;
                    }
                    this.isSecondarySelection = false;
                    break;
                }
                this.multipleSelection = new ArrayList<GWTJahiaNode>();
                if (this.mainNode != null) {
                    this.multipleSelection.add(this.mainNode);
                }
                this.singleSelection = this.mainNode;
                this.isSecondarySelection = true;
            }
        }
        this.permissions = null;
        this.isRootNode = false;
        this.parentWriteable = true;
        this.parent = null;
        this.lockable = true;
        this.locked = true;
        this.file = true;
        this.zip = true;
        this.image = true;
        for (GWTJahiaNode node : this.multipleSelection) {
            if (this.permissions == null) {
                this.permissions = node.getPermissions();
            } else {
                this.permissions = (GWTBitSet)this.permissions.clone();
                this.permissions.and(node.getPermissions());
            }
            if (node.getParent() != null) {
                this.parent = (GWTJahiaNode)node.getParent();
            } else if (this.mainNode != null) {
                this.parent = this.mainNode;
            }
            this.parentWriteable = this.parent != null && PermissionsUtils.isPermitted("jcr:addChildNodes", this.parent) && this.parent.isLocked() == false;
            this.isRootNode |= node.get("isRootNode") != null;
            this.lockable = this.lockable && node.isLockable() != false;
            this.locked = this.locked && node.isLocked() != false;
            this.file = this.file && node.isFile() != false;
            int extIndex = node.getName().lastIndexOf(".");
            if (extIndex <= 0 || !node.getName().substring(extIndex).equalsIgnoreCase(".zip")) {
                this.zip = false;
            }
            this.image = node.getNodeTypes().contains("jmix:image");
        }
        this.pasteAllowed = this.singleSelection != null ? CopyPasteEngine.getInstance().canCopyTo(this.singleSelection) : false;
    }

    public GWTJahiaNode getMainNode() {
        return this.mainNode;
    }

    public List<GWTJahiaNode> getSelectedNodes() {
        return this.selectedNodes;
    }

    public GWTJahiaNode getSingleSelection() {
        return this.singleSelection;
    }

    public List<GWTJahiaNode> getMultipleSelection() {
        return this.multipleSelection;
    }

    public boolean isSecondarySelection() {
        return this.isSecondarySelection;
    }

    public GWTJahiaNode getParent() {
        return this.parent;
    }

    public boolean isPasteAllowed() {
        return this.pasteAllowed;
    }

    public GWTBitSet getSelectionPermissions() {
        return this.permissions;
    }

    public boolean isRootNode() {
        return this.isRootNode;
    }

    public boolean isParentWriteable() {
        return this.parentWriteable;
    }

    public boolean isLockable() {
        return this.lockable;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isFile() {
        return this.file;
    }

    public boolean isZip() {
        return this.zip;
    }

    public boolean isImage() {
        return this.image;
    }
}

