/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FormEvent;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import org.jahia.ajax.gwt.client.core.CommonEntryPoint;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.messages.Messages;

public class LoginBox
extends Window {
    private static LoginBox instance;

    public static LoginBox getInstance() {
        if (instance == null) {
            instance = new LoginBox();
        }
        return instance;
    }

    public LoginBox() {
        this.addStyleName("login-box");
        this.setSize(400, 200);
        this.setModal(true);
        this.setBlinkModal(true);
        this.setHeadingHtml(Messages.get("label.login", "Login"));
        this.setLayout((Layout)new FitLayout());
        final FormPanel form = new FormPanel();
        form.setHeaderVisible(false);
        form.setFrame(false);
        form.setAction(JahiaGWTParameters.getContextPath() + "/cms/login?doLogin=true&restMode=true&site=" + JahiaGWTParameters.getSiteKey());
        form.setMethod(FormPanel.Method.POST);
        form.setLabelWidth(125);
        VerticalPanel vpLabels = new VerticalPanel();
        vpLabels.add((Widget)new Label(Messages.get("message.sessionExpired", "You have been performed no actions for some time. Due to security concerns we have ended your session. Please log in again.")));
        final Label lbWrongCredentials = new Label(Messages.get("message_invalidUsernamePassword", "Invalid username/password"));
        lbWrongCredentials.setVisible(false);
        lbWrongCredentials.setStyleAttribute("color", "red");
        vpLabels.add((Widget)lbWrongCredentials);
        form.add((Widget)vpLabels);
        TextField username = new TextField();
        username.setName("username");
        username.setFieldLabel(Messages.get("label.username", "Username"));
        username.setAllowBlank(false);
        username.setValue((Object)JahiaGWTParameters.getCurrentUser());
        username.setReadOnly(true);
        username.addKeyListener(new KeyListener(){

            public void componentKeyPress(ComponentEvent event) {
                if (event.getKeyCode() == 13) {
                    lbWrongCredentials.setVisible(false);
                    form.submit();
                }
            }
        });
        form.add((Widget)username);
        TextField password = new TextField();
        password.setPassword(true);
        password.setName("password");
        password.setFieldLabel(Messages.get("label.password", "Password"));
        password.setAllowBlank(false);
        password.addKeyListener(new KeyListener(){

            public void componentKeyPress(ComponentEvent event) {
                if (event.getKeyCode() == 13) {
                    lbWrongCredentials.setVisible(false);
                    form.submit();
                }
            }
        });
        form.add((Widget)password);
        Button btnSubmit = new Button(Messages.get("label.login", "Login"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                lbWrongCredentials.setVisible(false);
                form.submit();
            }
        });
        btnSubmit.addStyleName("button-submit");
        form.addButton(btnSubmit);
        Button btnCancel = new Button(Messages.get("label.cancel", "Cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                LoginBox.this.hide();
                String portOrigin = Window.Location.getPort();
                String port = portOrigin == null || portOrigin.equals("80") || portOrigin.equals("") ? "" : ":" + portOrigin;
                Window.Location.assign((String)(Window.Location.getProtocol() + "//" + Window.Location.getHostName() + port + JahiaGWTParameters.getContextPath()));
            }
        });
        btnCancel.addStyleName("button-cancel");
        form.addButton(btnCancel);
        form.setButtonAlign(Style.HorizontalAlignment.CENTER);
        form.addListener(Events.Submit, (Listener)new Listener<FormEvent>(){

            public void handleEvent(FormEvent formEvent) {
                if (!formEvent.getResultHtml().contains("OK")) {
                    lbWrongCredentials.setVisible(true);
                } else {
                    if (CommonEntryPoint.getSessionCheckTimer() != null) {
                        CommonEntryPoint.getSessionCheckTimer().run();
                    }
                    LoginBox.this.hide();
                }
            }
        });
        this.add((Component)form);
    }
}

