/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.calendar;

import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseModel;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.util.DateWrapper;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.DatePicker;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.google.gwt.dom.client.Node;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;

public class CalendarPicker
extends DatePicker {
    private HorizontalPanel hoursPanel;
    private DateTimeFormat format = DateTimeFormat.getShortTimeFormat();
    private HourModel hour;
    private MinuteModel minute;
    private ComboBox hours;
    private ComboBox minutes;

    public CalendarPicker(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.setValue(date, true);
        DateWrapper dateWrapper = new DateWrapper(this.getValue());
        this.hour = new HourModel(dateWrapper.getHours());
        this.minute = new MinuteModel(dateWrapper.getMinutes());
    }

    public CalendarPicker() {
        this(null);
    }

    public DateTimeFormat getFormat() {
        return this.format;
    }

    public void setFormat(DateTimeFormat format) {
        this.format = format;
    }

    public HourModel getHour() {
        return this.hour;
    }

    public int getSelectedHour() {
        HourModel hourModel = this.hour;
        if (!this.hours.getSelection().isEmpty()) {
            hourModel = (HourModel)((Object)this.hours.getSelection().get(0));
        }
        return Integer.parseInt(hourModel.getValue());
    }

    public ComboBox getHours() {
        return this.hours;
    }

    public void setHour(int hour) {
        this.hour = new HourModel(hour);
        if (this.hours != null) {
            this.hours.setValue((ModelData)this.hour);
        }
    }

    public MinuteModel getMinute() {
        return this.minute;
    }

    public int getSelectedMinute() {
        MinuteModel minuteModel = this.minute;
        if (!this.minutes.getSelection().isEmpty()) {
            minuteModel = (MinuteModel)((Object)this.minutes.getSelection().get(0));
        }
        return Integer.parseInt(minuteModel.getValue());
    }

    public ComboBox getMinutes() {
        return this.minutes;
    }

    public void setMinute(int minute) {
        this.minute = new MinuteModel(minute);
        if (this.minutes != null) {
            this.minutes.setValue((ModelData)this.minute);
        }
    }

    public void setValue(Date date, boolean supressEvent) {
        super.setValue(date, supressEvent);
        if (date != null) {
            this.setMinute(date.getMinutes());
            this.setHour(date.getHours());
        }
    }

    protected void initHours() {
        Date date = this.getValue();
        DateWrapper dateWrapper = null;
        dateWrapper = date == null ? new DateWrapper() : new DateWrapper(date);
        this.hoursPanel = new HorizontalPanel();
        this.hoursPanel.setTableWidth("100%");
        this.hoursPanel.setHorizontalAlign(Style.HorizontalAlignment.CENTER);
        this.hoursPanel.setStyleName("x-date-hours-panel");
        this.hoursPanel.sinkEvents(1024);
        if (GXT.isIE) {
            this.hoursPanel.setWidth(175);
        }
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.setLayout((Layout)new FitLayout());
        hPanel.setHorizontalAlign(Style.HorizontalAlignment.LEFT);
        hPanel.setStyleName("x-date-bottom");
        this.hours = new ComboBox(){

            protected void onRender(Element parent, int index) {
                super.onRender(parent, index);
                this.getListView().addStyleName("x-datetime-selector");
            }
        };
        this.hours.setDisplayField("display");
        this.hours.setMinListWidth(40);
        this.hours.setWidth(40);
        this.hours.setStore(this.getHours(0, 23));
        this.hours.setValue((ModelData)(this.hour != null ? this.hour : new HourModel(dateWrapper.getHours())));
        this.hours.setForceSelection(true);
        this.hours.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.hours.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<HourModel>(){

            public void selectionChanged(SelectionChangedEvent se) {
                HourModel hourModel = (HourModel)((Object)se.getSelection().get(0));
                if (hourModel != null) {
                    CalendarPicker.this.hour = new HourModel(Integer.parseInt(hourModel.getValue()));
                }
            }
        });
        this.hours.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

            public void handleEvent(FieldEvent be) {
                HourModel hourModel = (HourModel)((Object)be.getValue());
                if (hourModel != null) {
                    CalendarPicker.this.hour = new HourModel(Integer.parseInt(hourModel.getValue()));
                }
            }
        });
        hPanel.add((Widget)this.hours);
        HTML sep = new HTML(":");
        sep.setStyleName("x-date-hours-separator");
        hPanel.add((Widget)sep, (LayoutData)new TableData(Style.HorizontalAlignment.CENTER, Style.VerticalAlignment.MIDDLE));
        this.minutes = new ComboBox(){

            protected void onRender(Element parent, int index) {
                super.onRender(parent, index);
                this.getListView().addStyleName("x-datetime-selector");
            }
        };
        this.minutes.setDisplayField("display");
        this.minutes.setMinListWidth(40);
        this.minutes.setWidth(40);
        this.minutes.setStore(this.getMinutes(0, 59));
        this.minutes.setValue((ModelData)(this.minute != null ? this.minute : new MinuteModel(dateWrapper.getMinutes())));
        this.minutes.setForceSelection(true);
        this.minutes.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.minutes.getListView().addStyleName("x-datetime-selector");
        this.minutes.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<MinuteModel>(){

            public void selectionChanged(SelectionChangedEvent se) {
                MinuteModel minuteModel = (MinuteModel)((Object)se.getSelection().get(0));
                if (minuteModel != null) {
                    CalendarPicker.this.minute = new MinuteModel(Integer.parseInt(minuteModel.getValue()));
                }
            }
        });
        this.minutes.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

            public void handleEvent(FieldEvent be) {
                MinuteModel minuteModel = (MinuteModel)((Object)be.getValue());
                if (minuteModel != null) {
                    CalendarPicker.this.minute = new MinuteModel(Integer.parseInt(minuteModel.getValue()));
                }
            }
        });
        hPanel.add((Widget)this.minutes);
        this.hoursPanel.add((Widget)hPanel, (LayoutData)new TableData(Style.HorizontalAlignment.CENTER, Style.VerticalAlignment.MIDDLE));
    }

    protected void onRender(Element target, int index) {
        super.onRender(target, index);
        this.initHours();
        Element lastChild = DOM.getChild((Element)this.getElement(), (int)3);
        this.getElement().insertBefore((Node)this.hoursPanel.getElement(), (Node)lastChild);
        this.el().addEventsSunk(125);
    }

    protected void doAttachChildren() {
        super.doAttachChildren();
        ComponentHelper.doAttach((Widget)this.hoursPanel);
    }

    protected void doDetachChildren() {
        super.doDetachChildren();
        ComponentHelper.doDetach((Widget)this.hoursPanel);
    }

    private ListStore<HourModel> getHours(int startHour, int endHour) {
        ListStore hours = new ListStore();
        for (int i = startHour; i <= endHour; ++i) {
            hours.add((ModelData)new HourModel(i));
        }
        return hours;
    }

    private ListStore<MinuteModel> getMinutes(int startMinute, int endMinute) {
        ListStore minutes = new ListStore();
        for (int i = startMinute; i <= endMinute; ++i) {
            minutes.add((ModelData)new MinuteModel(i));
        }
        return minutes;
    }

    protected void onClick(ComponentEvent be) {
        super.onClick(be);
    }

    protected void onHide() {
        super.onHide();
    }

    private class MinuteModel
    extends BaseModel {
        public MinuteModel() {
        }

        public MinuteModel(int value) {
            this.set("value", String.valueOf(value));
            if (value < 10) {
                this.set("display", "0" + value);
            } else {
                this.set("display", value);
            }
        }

        public String getValue() {
            return (String)this.get("value");
        }

        public String toString() {
            return this.getValue();
        }
    }

    private class HourModel
    extends BaseModel {
        public HourModel() {
        }

        public HourModel(int value) {
            this.set("value", String.valueOf(value));
            if (value < 10) {
                this.set("display", "0" + value);
            } else {
                this.set("display", value);
            }
        }

        public String getValue() {
            return (String)this.get("value");
        }

        public String toString() {
            return this.getValue();
        }
    }
}

