/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseListLoader;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ListLoadConfig;
import com.extjs.gxt.ui.client.data.ListLoadResult;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.data.TreeModel;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.widget.selection.AbstractStoreSelectionModel;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.Collator;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.tripanel.TopRightComponent;

public abstract class AbstractView
extends TopRightComponent {
    protected GWTJahiaNode root;
    protected ListLoader<ListLoadResult<GWTJahiaNode>> loader;
    protected GWTManagerConfiguration configuration;
    protected List<GWTJahiaNode> hiddenSelection;
    protected List<GWTJahiaNode> visibleSelection;
    protected ListStore<GWTJahiaNode> store;
    protected AbstractStoreSelectionModel<GWTJahiaNode> selectionModel;
    protected ListStore<ModelData> typeStore = new ListStore();
    protected ContentSource contentSource = null;

    public AbstractView(GWTManagerConfiguration config) {
        TypeModelData data = new TypeModelData();
        data.set("primaryTypeLabel", Messages.get("label.all", "All"));
        this.typeStore.add((ModelData)data);
        this.configuration = config;
        RpcProxy<PagingLoadResult<GWTJahiaNode>> privateProxy = new RpcProxy<PagingLoadResult<GWTJahiaNode>>(){

            protected void load(Object config, AsyncCallback<PagingLoadResult<GWTJahiaNode>> listAsyncCallback) {
                int indexOf;
                Log.debug((String)("retrieving children with type " + AbstractView.this.configuration.getNodeTypes() + " of " + AbstractView.this.root.getPath()));
                if (config instanceof ListLoadConfig) {
                    ListLoadConfig listLoadConfig = (ListLoadConfig)config;
                    listLoadConfig.setSortField(AbstractView.this.store.getSortField());
                    listLoadConfig.setSortDir(AbstractView.this.store.getSortDir());
                }
                ArrayList<String> keys = new ArrayList<String>(AbstractView.this.configuration.getTableColumnKeys());
                if (AbstractView.this.configuration.isEditableGrid()) {
                    keys.add("fields-content");
                }
                if ((indexOf = keys.indexOf("publicationInfo")) == -1 && !AbstractView.this.configuration.isSuppressPublicationInfo()) {
                    keys.add("publicationInfo");
                } else if (indexOf != -1 && AbstractView.this.configuration.isSuppressPublicationInfo()) {
                    keys.remove(indexOf);
                }
                keys.add("permissions");
                keys.add("locksInfo");
                keys.add("icon");
                keys.add("jcr:createdBy");
                if (AbstractView.this.configuration.isUseLargeThumbnails()) {
                    keys.add("previewLarge");
                }
                JahiaContentManagementService.App.getInstance().lsLoad(AbstractView.this.root.getPath(), AbstractView.this.configuration.getNodeTypes(), AbstractView.this.configuration.getMimeTypes(), AbstractView.this.configuration.getFilters(), keys, false, -1, -1, AbstractView.this.getLinker().isDisplayHiddenTypes(), AbstractView.this.configuration.getHiddenTypes(), AbstractView.this.configuration.getHiddenRegex(), AbstractView.this.configuration.isShowOnlyNodesWithTemplates(), false, listAsyncCallback);
            }
        };
        this.loader = new BaseListLoader<ListLoadResult<GWTJahiaNode>>((DataProxy)privateProxy){

            protected void onLoadSuccess(Object gwtJahiaNode, ListLoadResult<GWTJahiaNode> gwtJahiaNodeListLoadResult) {
                super.onLoadSuccess(gwtJahiaNode, gwtJahiaNodeListLoadResult);
                if (AbstractView.this.getLinker() != null) {
                    AbstractView.this.getLinker().loaded();
                }
                if (AbstractView.this.hiddenSelection != null) {
                    AbstractView.this.visibleSelection = new ArrayList<GWTJahiaNode>(AbstractView.this.store.getModels());
                    AbstractView.this.visibleSelection.retainAll(AbstractView.this.hiddenSelection);
                    if (AbstractView.this.visibleSelection.isEmpty()) {
                        AbstractView.this.getLinker().onTableItemSelected();
                    } else {
                        AbstractView.this.selectionModel.setSelection(AbstractView.this.visibleSelection);
                    }
                    for (GWTJahiaNode node : AbstractView.this.store.getModels()) {
                        node.setParent((TreeModel)AbstractView.this.root);
                    }
                }
                AbstractView.this.updateTypeStore(gwtJahiaNodeListLoadResult.getData());
                AbstractView.this.getLinker().getTopRightObject().getToolBar().clear();
                AbstractView.this.getLinker().getTopRightObject().getToolBar().disable();
            }
        };
        this.store = new ListStore<GWTJahiaNode>(this.loader){

            protected void onBeforeLoad(LoadEvent e) {
                if (AbstractView.this.getLinker() != null) {
                    AbstractView.this.getLinker().loading(Messages.get("statusbar.loadingContent.label"));
                }
                super.onBeforeLoad(e);
            }

            protected void onLoadException(LoadEvent loadEvent) {
                super.onLoadException(loadEvent);
                Log.error((String)"Error listing directory content ", (Throwable)loadEvent.exception);
            }
        };
        this.store.setStoreSorter(new StoreSorter((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return Collator.getInstance().localeCompare(s1, s2);
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return 0;
            }
        }));
    }

    private void updateTypeStore(List<GWTJahiaNode> nodes) {
        if (this.typeStore != null) {
            for (GWTJahiaNode o : nodes) {
                TypeModelData data = new TypeModelData();
                data.set("primaryTypeLabel", o.get("primaryTypeLabel"));
                if (this.typeStore.contains((ModelData)data)) continue;
                this.typeStore.add((ModelData)data);
            }
            this.typeStore.sort("primaryTypeLabel", Style.SortDir.ASC);
        }
    }

    @Override
    public List<GWTJahiaNode> getSelection() {
        List<GWTJahiaNode> elts = this.visibleSelection;
        if (elts != null && elts.size() > 0) {
            return elts;
        }
        return null;
    }

    @Override
    public List<GWTJahiaNode> getHiddenSelection() {
        return this.hiddenSelection;
    }

    void setHiddenSelection(List<GWTJahiaNode> hiddenSelection) {
        this.hiddenSelection = hiddenSelection;
    }

    List<GWTJahiaNode> getVisibleSelection() {
        return this.visibleSelection;
    }

    void setVisibleSelection(List<GWTJahiaNode> visibleSelection) {
        this.visibleSelection = visibleSelection;
    }

    public AbstractStoreSelectionModel<GWTJahiaNode> getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void setContent(Object root) {
        this.clearTable();
        this.root = (GWTJahiaNode)root;
        if (root != null) {
            this.loader.load();
        }
    }

    @Override
    public void setProcessedContent(Object content, ContentSource source) {
        this.clearTable();
        if (content != null) {
            List gwtJahiaNodes = (List)content;
            this.store.add(gwtJahiaNodes);
            this.updateTypeStore(gwtJahiaNodes);
            this.getLinker().onTableItemSelected();
        }
        this.contentSource = source;
    }

    @Override
    public void selectNodes(List<GWTJahiaNode> nodes) {
        this.hiddenSelection = nodes;
    }

    @Override
    public void clearTable() {
        this.store.removeAll();
    }

    @Override
    public void refresh() {
        if (this.contentSource != null) {
            this.contentSource.refreshTable();
        } else {
            this.setContent(this.getLinker().getTreeSelection());
        }
    }

    @Override
    public void initWithLinker(final ManagerLinker linker) {
        super.initWithLinker(linker);
        this.selectionModel.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> event) {
                if (event.getSelection() != null) {
                    if (!event.getSelection().isEmpty()) {
                        AbstractView.this.hiddenSelection = event.getSelection();
                    }
                    AbstractView.this.visibleSelection = event.getSelection();
                }
                linker.onTableItemSelected();
            }
        });
    }

    @Override
    public void clearSelection() {
        super.clearSelection();
        if (this.hiddenSelection != null) {
            this.hiddenSelection.clear();
        }
        if (this.visibleSelection != null) {
            this.visibleSelection.clear();
        }
    }

    public ListStore<GWTJahiaNode> getStore() {
        return this.store;
    }

    public ListStore<ModelData> getTypeStore() {
        return this.typeStore;
    }

    protected boolean isNodeTypeAllowed(GWTJahiaNode selectedNode) {
        if (selectedNode == null) {
            return true;
        }
        return !(this.configuration.getForbiddenNodeTypesForDragAndDrop() != null && selectedNode.isNodeType(this.configuration.getForbiddenNodeTypesForDragAndDrop()) || this.configuration.getAllowedNodeTypesForDragAndDrop() != null && !selectedNode.isNodeType(this.configuration.getAllowedNodeTypesForDragAndDrop()));
    }

    private static class TypeModelData
    extends BaseModelData {
        private TypeModelData() {
        }

        public boolean equals(Object obj) {
            Object o2;
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Object o1 = this.get("primaryTypeLabel");
            if (o1 == (o2 = ((ModelData)obj).get("primaryTypeLabel"))) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }

        public int hashCode() {
            return this.get("primaryTypeLabel") != null ? this.get("primaryTypeLabel").hashCode() : 0;
        }
    }

    public static interface ContentSource {
        public void refreshTable();
    }
}

