/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content.portlet;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACE;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.acleditor.AclEditor;
import org.jahia.ajax.gwt.client.widget.content.portlet.PortletWizardCard;

public class PortletRoleCard
extends PortletWizardCard {
    private AclEditor aclEditor;

    public PortletRoleCard() {
        super(Messages.get("org.jahia.engines.PortletsManager.wizard.rolesperm.label", "Roles permissions"), Messages.get("org.jahia.engines.PortletsManager.wizard.rolesperm.description.label", "Set roles permissions"));
    }

    @Override
    public void next() {
        if (this.aclEditor != null) {
            this.getGwtJahiaNewPortletInstance().setRoles(this.aclEditor.getAcl());
        }
    }

    @Override
    public void createUI() {
        super.createUI();
        final GWTJahiaNodeACL acl = this.getPortletWizardWindow().getGwtJahiaNewPortletInstance().getGwtJahiaPortletDefinition().getBaseAcl().cloneObject();
        acl.setBreakAllInheritance(true);
        List<String> permissions = acl.getAvailableRoles().get("roles");
        if (permissions != null && permissions.size() > 0) {
            JahiaContentManagementService.App.getInstance().createDefaultUsersGroupACE(permissions, true, (AsyncCallback<GWTJahiaNodeACE>)new BaseAsyncCallback<GWTJahiaNodeACE>(){

                public void onSuccess(GWTJahiaNodeACE gwtJahiaNodeACE) {
                    Log.debug((String)"Add group ACE");
                    PortletRoleCard.this.removeAll();
                    ArrayList<GWTJahiaNodeACE> aces = new ArrayList<GWTJahiaNodeACE>();
                    aces.add(gwtJahiaNodeACE);
                    acl.setAce(aces);
                    PortletRoleCard.this.initAclEditor(acl);
                    PortletRoleCard.this.aclEditor.addNewAclPanel(PortletRoleCard.this);
                    PortletRoleCard.this.getPortletWizardWindow().updateWizard();
                }

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    Log.error((String)"Unable to Add group ACE");
                    PortletRoleCard.this.removeAll();
                    PortletRoleCard.this.initAclEditor(acl);
                    PortletRoleCard.this.aclEditor.addNewAclPanel(PortletRoleCard.this);
                }
            });
        } else {
            this.add((Widget)new Label(Messages.get("org.jahia.engines.PortletsManager.wizard.roles.any", "The selected portlets defines any roles.")));
        }
    }

    private void initAclEditor(GWTJahiaNodeACL acl) {
        this.aclEditor = new AclEditor(acl, this.getPortletWizardWindow().getParentNode().getSiteKey(), null, Collections.singleton("roles"), null);
        this.aclEditor.setAddUsersLabel(Messages.get("org.jahia.engines.PortletsManager.wizard.roles.adduser.label", "Add rode-user permission"));
        this.aclEditor.setAddGroupsLabel(Messages.get("org.jahia.engines.PortletsManager.wizard.roles.addgroup.label", "Add rode-group permission"));
    }

    @Override
    public void refreshLayout() {
        this.layout();
    }
}

