/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.binding.FieldBinding;
import com.extjs.gxt.ui.client.binding.FormBinding;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.ListView;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.CenterLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.GWTResourceBundle;
import org.jahia.ajax.gwt.client.data.GWTResourceBundleEntry;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.AbstractContentEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;

public class ResourceBundleEditor
extends LayoutContainer {
    public static final List<String> FIELDS = Arrays.asList("resourceBundle");
    private static final String LANGUAGE_TAB_ID = "jahia-rb-language-tab-";
    private static final String NEW_LANGUAGE_TAB_ID = "jahia-rb-new-language-tab";
    protected Button addButton;
    protected List<GWTJahiaValueDisplayBean> availableLanguages;
    protected AutoScrollableListView<GWTResourceBundleEntry> bundleView;
    protected NodeHolder engine;
    protected boolean writable = true;
    protected FormPanel form;
    protected FormBinding formBinding;
    protected Set<String> languages = new TreeSet<String>();
    private String name;
    private AsyncTabItem newLanguageTab;
    protected TextField<String> searchField;
    private TabPanel tabPanel;
    protected Map<String, TextArea> valuesPerLanguage = new HashMap<String, TextArea>();

    public ResourceBundleEditor(NodeHolder engine) {
        this.engine = engine;
        this.writable = !engine.isExistingNode() || PermissionsUtils.isPermitted("jcr:modifyProperties", engine.getNode()) && engine.getNode().isLocked() == false;
    }

    private Button createAddButton() {
        Button btn = new Button(Messages.get("label.add", "Add"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                GWTResourceBundleEntry newEntry;
                block3: {
                    block2: {
                        String newKey = (String)ResourceBundleEditor.this.searchField.getValue();
                        newEntry = null;
                        if (newKey.length() == 0) break block2;
                        newEntry = new GWTResourceBundleEntry(newKey);
                        if (!ResourceBundleEditor.this.bundleView.getStore().contains((ModelData)newEntry)) break block3;
                    }
                    return;
                }
                ResourceBundleEditor.this.bundleView.getStore().add((ModelData)newEntry);
                ResourceBundleEditor.this.bundleView.getSelectionModel().setSelection(Arrays.asList(newEntry));
                event.getButton().disable();
            }
        });
        btn.addStyleName("button-add");
        btn.setIcon(ToolbarIconProvider.getInstance().getIcon("newAction"));
        btn.disable();
        return btn;
    }

    private Menu createContextMenu() {
        Menu contextMenu = new Menu();
        MenuItem newItem = new MenuItem();
        newItem.setHtml(Messages.get("label.new", "New"));
        newItem.addSelectionListener((SelectionListener)new SelectionListener<MenuEvent>(){

            public void componentSelected(MenuEvent ce) {
                MessageBox box = new MessageBox();
                box.setTitleHtml(Messages.get("label.new", "New"));
                box.setMessage(Messages.get("label.resourceBundle.new", "Please provide a key for the new resource bundle entry"));
                box.setType(MessageBox.MessageBoxType.PROMPT);
                box.setButtons("okcancel");
                box.setType(MessageBox.MessageBoxType.PROMPT);
                box.addCallback((Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent be) {
                        if ("ok".equalsIgnoreCase(be.getButtonClicked().getHtml())) {
                            if (be.getValue() == null || be.getValue().trim().length() == 0) {
                                return;
                            }
                            GWTResourceBundleEntry newEntry = new GWTResourceBundleEntry(be.getValue());
                            GWTResourceBundleEntry entry = null;
                            entry = (GWTResourceBundleEntry)ResourceBundleEditor.this.bundleView.getStore().findModel((ModelData)newEntry);
                            if (entry == null) {
                                ResourceBundleEditor.this.bundleView.getStore().add((ModelData)newEntry);
                                entry = newEntry;
                            }
                            ResourceBundleEditor.this.bundleView.getSelectionModel().setSelection(Arrays.asList(entry));
                        }
                    }
                });
                box.addListener(Events.Show, (Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent be) {
                        GWTResourceBundleEntry selectedItem = (GWTResourceBundleEntry)ResourceBundleEditor.this.bundleView.getSelectionModel().getSelectedItem();
                        if (selectedItem != null) {
                            be.getMessageBox().getTextBox().setValue((Object)selectedItem.getKey());
                            be.getMessageBox().getTextBox().selectAll();
                        }
                    }
                });
                box.show();
            }
        });
        contextMenu.add((Component)newItem);
        MenuItem renameItem = new MenuItem();
        renameItem.setHtml(Messages.get("label.rename", "Rename"));
        renameItem.addSelectionListener((SelectionListener)new SelectionListener<MenuEvent>(){

            public void componentSelected(MenuEvent ce) {
                final GWTResourceBundleEntry selectedItem = (GWTResourceBundleEntry)ResourceBundleEditor.this.bundleView.getSelectionModel().getSelectedItem();
                MessageBox box = new MessageBox();
                box.setTitleHtml(Messages.get("label.rename", "Rename"));
                box.setMessage(Messages.getWithArgs("label.resourceBundle.rename", "Rename \"{0}\" to", new String[]{selectedItem.getKey()}));
                box.setType(MessageBox.MessageBoxType.PROMPT);
                box.setButtons("okcancel");
                box.setType(MessageBox.MessageBoxType.PROMPT);
                box.addCallback((Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent be) {
                        if ("ok".equalsIgnoreCase(be.getButtonClicked().getHtml())) {
                            if (be.getValue() == null || be.getValue().trim().length() == 0 || be.getValue().equals(selectedItem.getKey())) {
                                return;
                            }
                            ResourceBundleEditor.this.bundleView.getStore().remove((ModelData)selectedItem);
                            selectedItem.setKey(be.getValue());
                            ResourceBundleEditor.this.bundleView.getStore().add((ModelData)selectedItem);
                            ResourceBundleEditor.this.bundleView.getSelectionModel().setSelection(Arrays.asList(selectedItem));
                        }
                    }
                });
                box.addListener(Events.Show, (Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent be) {
                        GWTResourceBundleEntry selectedItem = (GWTResourceBundleEntry)ResourceBundleEditor.this.bundleView.getSelectionModel().getSelectedItem();
                        if (selectedItem != null) {
                            be.getMessageBox().getTextBox().setValue((Object)selectedItem.getKey());
                            be.getMessageBox().getTextBox().selectAll();
                        }
                    }
                });
                box.show();
            }
        });
        contextMenu.add((Component)renameItem);
        MenuItem deleteItem = new MenuItem();
        deleteItem.setHtml(Messages.get("label.delete", "Delete"));
        deleteItem.addSelectionListener((SelectionListener)new SelectionListener<MenuEvent>(){

            public void componentSelected(MenuEvent ce) {
                final GWTResourceBundleEntry selectedItem = (GWTResourceBundleEntry)ResourceBundleEditor.this.bundleView.getSelectionModel().getSelectedItem();
                MessageBox.confirm((String)Messages.get("label.remove", "Remove"), (String)Messages.getWithArgs("message.remove.single.confirm", "Do you really want to remove the selected resource {0}?", new Object[]{selectedItem.getKey()}), (Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent be) {
                        if ("yes".equalsIgnoreCase(be.getButtonClicked().getItemId())) {
                            ResourceBundleEditor.this.bundleView.getStore().remove((ModelData)selectedItem);
                        }
                    }
                });
            }
        });
        contextMenu.add((Component)deleteItem);
        MenuItem duplicateItem = new MenuItem();
        duplicateItem.setHtml(Messages.get("label.duplicate", "Duplicate"));
        duplicateItem.addSelectionListener((SelectionListener)new SelectionListener<MenuEvent>(){

            public void componentSelected(MenuEvent ce) {
                final GWTResourceBundleEntry selectedItem = (GWTResourceBundleEntry)ResourceBundleEditor.this.bundleView.getSelectionModel().getSelectedItem();
                MessageBox box = new MessageBox();
                box.setTitleHtml(Messages.get("label.duplicate", "Duplicate"));
                box.setMessage(Messages.getWithArgs("label.resourceBundle.duplicate", "Duplicate \"{0}\" to", new String[]{selectedItem.getKey()}));
                box.setType(MessageBox.MessageBoxType.PROMPT);
                box.setButtons("okcancel");
                box.setType(MessageBox.MessageBoxType.PROMPT);
                box.addCallback((Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent be) {
                        if ("ok".equalsIgnoreCase(be.getButtonClicked().getHtml())) {
                            if (be.getValue() == null || be.getValue().trim().length() == 0 || be.getValue().equals(selectedItem.getKey())) {
                                return;
                            }
                            GWTResourceBundleEntry entry = new GWTResourceBundleEntry(be.getValue());
                            entry.setValues(new BaseModelData(selectedItem.getValues().getProperties()));
                            ResourceBundleEditor.this.bundleView.getStore().add((ModelData)entry);
                            ResourceBundleEditor.this.bundleView.getSelectionModel().setSelection(Arrays.asList(entry));
                        }
                    }
                });
                box.addListener(Events.Show, (Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent be) {
                        GWTResourceBundleEntry selectedItem = (GWTResourceBundleEntry)ResourceBundleEditor.this.bundleView.getSelectionModel().getSelectedItem();
                        if (selectedItem != null) {
                            be.getMessageBox().getTextBox().setValue((Object)selectedItem.getKey());
                            be.getMessageBox().getTextBox().selectAll();
                        }
                    }
                });
                box.show();
            }
        });
        contextMenu.add((Component)duplicateItem);
        return contextMenu;
    }

    private FormPanel createForm() {
        FormPanel panel = new FormPanel();
        panel.setHeaderVisible(false);
        panel.setLabelAlign(FormPanel.LabelAlign.TOP);
        panel.setButtonAlign(Style.HorizontalAlignment.CENTER);
        panel.setFrame(false);
        panel.setBorders(false);
        return panel;
    }

    private AsyncTabItem createLanguageTab(String lang) {
        AsyncTabItem langTab = new AsyncTabItem(this.getLanguageDisplayName(lang));
        langTab.setLayout((Layout)new CenterLayout());
        langTab.setItemId(LANGUAGE_TAB_ID + lang);
        return langTab;
    }

    private void createLanguageTabs() {
        int i = 1;
        for (String l : this.languages) {
            if (i == this.tabPanel.getItemCount() - 1 || !((TabItem)this.tabPanel.getItem(i)).getItemId().substring(LANGUAGE_TAB_ID.length()).equals(l)) {
                this.tabPanel.insert((TabItem)this.createLanguageTab(l), i);
            }
            ++i;
        }
    }

    private AsyncTabItem createNewLanguageTab() {
        AsyncTabItem newLangTab = new AsyncTabItem(Messages.get("label.new", "New") + "...");
        newLangTab.setLayout((Layout)new CenterLayout());
        newLangTab.setIcon(ToolbarIconProvider.getInstance().getIcon("newAction"));
        newLangTab.setItemId(NEW_LANGUAGE_TAB_ID);
        return newLangTab;
    }

    private TabItem createPropertiesTab() {
        TabItem tab = new TabItem(Messages.get("label.properties", "Properties"));
        tab.setLayout((Layout)new BorderLayout());
        tab.setItemId("jahia-rb-properties-tab");
        ContentPanel cpLeft = new ContentPanel();
        cpLeft.setScrollMode(Style.Scroll.AUTO);
        cpLeft.setHeaderVisible(false);
        cpLeft.setBorders(true);
        RowLayout rowLayout = new RowLayout(Style.Orientation.VERTICAL);
        rowLayout.setAdjustForScroll(true);
        cpLeft.setLayout((Layout)rowLayout);
        this.bundleView = this.createView();
        this.addButton = this.createAddButton();
        this.searchField = this.createSearchField();
        this.loadData();
        this.bundleView.setHeight("auto");
        cpLeft.add(this.bundleView, (LayoutData)new RowData(1.0, 0.9, new Margins(0, 0, 4, 0)));
        cpLeft.add(this.searchField, (LayoutData)new RowData(1.0, 0.05));
        cpLeft.add((Widget)this.addButton, (LayoutData)new RowData(1.0, 0.05, new Margins(1, 0, 0, 0)));
        BorderLayoutData ldLeft = new BorderLayoutData(Style.LayoutRegion.WEST, 200.0f, 100, 350);
        ldLeft.setMargins(new Margins(5));
        ldLeft.setSplit(true);
        tab.add((Widget)cpLeft, (LayoutData)ldLeft);
        ContentPanel cpCenter = new ContentPanel();
        cpCenter.setHeaderVisible(false);
        cpCenter.setLayout((Layout)new FlowLayout());
        cpCenter.setScrollMode(Style.Scroll.AUTOY);
        this.form = this.createForm();
        this.form.setBorders(true);
        this.form.setWidth("100%");
        cpCenter.add((Widget)this.form);
        BorderLayoutData ldCenter = new BorderLayoutData(Style.LayoutRegion.CENTER);
        ldCenter.setMargins(new Margins(5));
        tab.add((Widget)cpCenter, (LayoutData)ldCenter);
        return tab;
    }

    private TextField<String> createSearchField() {
        TextField searchField = new TextField();
        searchField.setName("bundleKeySearch");
        searchField.addListener(Events.KeyUp, (Listener)new KeyListener(){

            public void componentKeyUp(ComponentEvent event) {
                String search = (String)((TextField)event.getComponent()).getValue();
                if (search != null && search.length() > 0) {
                    GWTResourceBundleEntry match = (GWTResourceBundleEntry)ResourceBundleEditor.this.bundleView.getStore().findModel("key", (Object)search);
                    ResourceBundleEditor.this.addButton.setEnabled(match == null && ResourceBundleEditor.this.writable);
                    if (match == null) {
                        for (GWTResourceBundleEntry e : ResourceBundleEditor.this.bundleView.getStore().getModels()) {
                            if (!e.getKey().startsWith(search)) continue;
                            match = e;
                            break;
                        }
                    }
                    if (match != null) {
                        ResourceBundleEditor.this.bundleView.getSelectionModel().setSelection(Arrays.asList(match));
                    }
                } else {
                    ResourceBundleEditor.this.addButton.disable();
                }
            }
        });
        return searchField;
    }

    private AutoScrollableListView<GWTResourceBundleEntry> createView() {
        AutoScrollableListView<GWTResourceBundleEntry> view = new AutoScrollableListView<GWTResourceBundleEntry>();
        view.setBorders(false);
        ListStore store = new ListStore();
        store.setDefaultSort("key", Style.SortDir.ASC);
        store.sort("key", Style.SortDir.ASC);
        view.setStore(store);
        view.setSimpleTemplate("{key}");
        view.setDisplayProperty("key");
        view.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        view.getSelectionModel().addListener(Events.SelectionChange, (Listener)new Listener<SelectionChangedEvent<GWTResourceBundleEntry>>(){

            public void handleEvent(SelectionChangedEvent<GWTResourceBundleEntry> be) {
                if (be.getSelection().size() > 0) {
                    if (ResourceBundleEditor.this.writable && !ResourceBundleEditor.this.valuesPerLanguage.values().iterator().next().isEnabled()) {
                        for (TextArea textArea : ResourceBundleEditor.this.valuesPerLanguage.values()) {
                            textArea.enable();
                        }
                    }
                    ResourceBundleEditor.this.formBinding.bind(be.getSelectedItem());
                } else {
                    ResourceBundleEditor.this.formBinding.unbind();
                    for (TextArea textArea : ResourceBundleEditor.this.valuesPerLanguage.values()) {
                        textArea.disable();
                    }
                }
            }
        });
        if (this.writable) {
            view.setContextMenu(this.createContextMenu());
        }
        return view;
    }

    protected void fillCurrentTab() {
        TabItem selectedTab = this.tabPanel.getSelectedItem();
        if (!(selectedTab instanceof AsyncTabItem)) {
            return;
        }
        AsyncTabItem currentTab = (AsyncTabItem)selectedTab;
        if (currentTab.getItemId().startsWith(LANGUAGE_TAB_ID)) {
            this.populateLanguageTab(currentTab);
        } else if (NEW_LANGUAGE_TAB_ID.equals(currentTab.getItemId())) {
            this.populateNewLanguageTab();
        }
    }

    protected String getLanguageDisplayName(String langCode) {
        if ("<default>".equals(langCode)) {
            return "[" + Messages.get("label.default", "Default") + "]";
        }
        String label = langCode;
        for (GWTJahiaValueDisplayBean langBean : this.availableLanguages) {
            if (!langBean.getValue().equals(langCode)) continue;
            label = langBean.getDisplay();
            break;
        }
        return label;
    }

    public GWTResourceBundle getResourceBundle() {
        TabItem selectedItem = this.tabPanel.getSelectedItem();
        if (selectedItem != null && selectedItem.getItemId().startsWith(LANGUAGE_TAB_ID)) {
            this.propagateChanges(selectedItem);
        }
        GWTResourceBundle rb = new GWTResourceBundle(this.name);
        for (GWTResourceBundleEntry entry : this.bundleView.getStore().getModels()) {
            rb.getEntryMap().put(entry.getKey(), entry);
        }
        return rb;
    }

    private void loadData() {
        if (this.engine instanceof AbstractContentEngine) {
            ((AbstractContentEngine)this.engine).loading();
        }
        JahiaContentManagementService.App.getInstance().getNodes(Arrays.asList(this.engine.getNode().getPath()), FIELDS, (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

            @Override
            public void onFailure(Throwable caught) {
                if (ResourceBundleEditor.this.engine instanceof AbstractContentEngine) {
                    ((AbstractContentEngine)ResourceBundleEditor.this.engine).loaded();
                }
                super.onFailure(caught);
            }

            public void onSuccess(List<GWTJahiaNode> result) {
                try {
                    if (result.size() > 0) {
                        ResourceBundleEditor.this.onLoad((GWTResourceBundle)((Object)result.get(0).get("resourceBundle")));
                    }
                }
                finally {
                    if (ResourceBundleEditor.this.engine instanceof AbstractContentEngine) {
                        ((AbstractContentEngine)ResourceBundleEditor.this.engine).loaded();
                    }
                }
            }
        });
    }

    protected void onLoad(GWTResourceBundle rb) {
        this.name = rb.getName();
        this.languages.clear();
        this.languages.addAll(rb.getLanguages());
        this.bundleView.getStore().removeAll();
        this.bundleView.getStore().add(new ArrayList<GWTResourceBundleEntry>(rb.getEntries()));
        this.availableLanguages = rb.getAvailableLanguages();
        this.populateForm();
    }

    protected void onRender(Element parent, int index) {
        super.onRender(parent, index);
        this.setLayout((Layout)new FitLayout());
        this.tabPanel = new TabPanel();
        this.tabPanel.setWidth("100%");
        this.tabPanel.setTabPosition(TabPanel.TabPosition.BOTTOM);
        this.tabPanel.setMinTabWidth(100);
        this.tabPanel.setLayoutData((Object)new FitLayout());
        this.tabPanel.add(this.createPropertiesTab());
        this.newLanguageTab = this.createNewLanguageTab();
        this.tabPanel.add((TabItem)this.newLanguageTab);
        this.newLanguageTab.setEnabled(this.writable);
        this.tabPanel.addListener(Events.Select, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent event) {
                ResourceBundleEditor.this.fillCurrentTab();
            }
        });
        this.tabPanel.addListener(Events.BeforeSelect, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent event) {
                TabItem selectedItem = ResourceBundleEditor.this.tabPanel.getSelectedItem();
                if (selectedItem != null && selectedItem.getItemId().startsWith(ResourceBundleEditor.LANGUAGE_TAB_ID)) {
                    ResourceBundleEditor.this.propagateChanges(selectedItem);
                }
            }
        });
        this.add((Component)this.tabPanel);
    }

    private void populateForm() {
        this.valuesPerLanguage.clear();
        if (this.formBinding != null) {
            this.formBinding.unbind();
        }
        this.form.removeAll();
        this.formBinding = new FormBinding(this.form);
        this.formBinding.setStore((Store)this.bundleView.getStore());
        FormData formData = new FormData("100%");
        TextArea lang = null;
        for (String languageCode : this.languages) {
            lang = new TextArea();
            lang.setName(languageCode);
            lang.setFieldLabel(this.getLanguageDisplayName(languageCode));
            lang.disable();
            this.formBinding.addFieldBinding(new FieldBinding((Field)lang, "values." + languageCode));
            this.valuesPerLanguage.put(languageCode, lang);
            this.form.add((Widget)lang, (LayoutData)formData);
        }
        this.form.layout();
        GWTResourceBundleEntry selectedItem = (GWTResourceBundleEntry)this.bundleView.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            this.formBinding.bind((ModelData)selectedItem);
            if (this.writable) {
                for (TextArea textArea : this.valuesPerLanguage.values()) {
                    textArea.enable();
                }
            }
        }
        this.createLanguageTabs();
    }

    private void populateLanguageTab(AsyncTabItem currentTab) {
        TextArea sourceView = null;
        if (!currentTab.isProcessed()) {
            sourceView = new TextArea();
            sourceView.setWidth("100%");
            sourceView.setHeight("100%");
            currentTab.add((Widget)sourceView);
            currentTab.layout();
            currentTab.setProcessed(true);
            sourceView.setEnabled(this.writable);
        } else {
            sourceView = (TextArea)currentTab.getItem(0);
        }
        String lang = currentTab.getItemId().substring(LANGUAGE_TAB_ID.length());
        StringBuilder b = new StringBuilder();
        for (GWTResourceBundleEntry e : this.bundleView.getStore().getModels()) {
            String value = e.getValue(lang);
            if (value == null || value.length() <= 0) continue;
            b.append(e.getKey()).append("=").append(value).append("\n");
        }
        sourceView.setValue((Object)b.toString());
    }

    private void populateNewLanguageTab() {
        if (this.newLanguageTab.isProcessed()) {
            return;
        }
        FormPanel formPanel = new FormPanel();
        formPanel.setHeight(150);
        formPanel.setWidth(500);
        formPanel.setLabelWidth(150);
        formPanel.setFrame(true);
        formPanel.setBorders(true);
        formPanel.setButtonAlign(Style.HorizontalAlignment.CENTER);
        formPanel.setHeadingHtml(Messages.get("label.resourceBundle.addLanguage", "Add new language to the resource bundle") + ":");
        ComboBox languageSelector = new ComboBox();
        languageSelector.setFieldLabel(Messages.get("label.resourceBundle.addLanguage.choose", "Choose"));
        languageSelector.setStore(new ListStore());
        languageSelector.getStore().add((ModelData)new GWTJahiaValueDisplayBean("<default>", "[" + Messages.get("label.default", "Default") + "]"));
        languageSelector.getStore().add(this.availableLanguages);
        languageSelector.setDisplayField("display");
        languageSelector.setTypeAhead(true);
        languageSelector.setTriggerAction(ComboBox.TriggerAction.ALL);
        languageSelector.setForceSelection(true);
        formPanel.add((Widget)languageSelector);
        final TextField langField = new TextField();
        langField.setName("newLanguage");
        langField.setFieldLabel(Messages.get("label.resourceBundle.addLanguage.type", "or type the locale"));
        formPanel.add((Widget)langField);
        languageSelector.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaValueDisplayBean>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaValueDisplayBean> se) {
                if (se == null) {
                    return;
                }
                langField.setValue((Object)(!"<default>".equals(((GWTJahiaValueDisplayBean)se.getSelectedItem()).getValue()) ? ((GWTJahiaValueDisplayBean)se.getSelectedItem()).getValue() : ""));
            }
        });
        Button btn = new Button(Messages.get("label.add", "Add"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                String newLang = (String)langField.getValue();
                if (ResourceBundleEditor.this.languages.contains(newLang)) {
                    return;
                }
                if (!newLang.matches("[a-z]{2}(_[A-Z]{2})?")) {
                    MessageBox.alert((String)Messages.get("label.error"), (String)Messages.get("label.resourceBundle.addLanguage.invalidLang"), null).getDialog().addStyleName("engine-save-error");
                    return;
                }
                ResourceBundleEditor.this.languages.add(newLang);
                for (GWTResourceBundleEntry e : ResourceBundleEditor.this.bundleView.getStore().getModels()) {
                    e.setValue(newLang, null);
                }
                ResourceBundleEditor.this.populateForm();
                ResourceBundleEditor.this.tabPanel.setSelection((TabItem)ResourceBundleEditor.this.tabPanel.getItem(0));
            }
        });
        btn.addStyleName("button-add");
        btn.setEnabled(this.writable);
        formPanel.addButton(btn);
        this.newLanguageTab.add((Widget)formPanel);
        this.newLanguageTab.setProcessed(true);
        this.newLanguageTab.layout();
    }

    protected void propagateChanges(TabItem tab) {
        String lang = tab.getItemId().substring(LANGUAGE_TAB_ID.length());
        String text = (String)((TextArea)tab.getItem(0)).getValue();
        String[] lines = text != null && text.length() > 0 ? text.split("\n") : new String[]{};
        HashMap<String, String> rb = new HashMap<String, String>();
        for (String line : lines) {
            int pos = line.indexOf("=");
            if (pos <= 0 && pos <= line.length() - 2) continue;
            rb.put(line.substring(0, pos), line.substring(pos + 1));
        }
        for (GWTResourceBundleEntry gWTResourceBundleEntry : this.bundleView.getStore().getModels()) {
            gWTResourceBundleEntry.setValue(lang, (String)rb.remove(gWTResourceBundleEntry.getKey()));
        }
        for (Map.Entry entry : rb.entrySet()) {
            GWTResourceBundleEntry model = new GWTResourceBundleEntry((String)entry.getKey());
            for (String l : this.languages) {
                model.setValue(l, null);
            }
            model.setValue(lang, (String)entry.getValue());
            this.bundleView.getStore().add((ModelData)model);
        }
        GWTResourceBundleEntry selectedItem = (GWTResourceBundleEntry)this.bundleView.getSelectionModel().getSelectedItem();
        if (selectedItem != null && this.formBinding != null) {
            this.formBinding.unbind();
            this.formBinding.bind((ModelData)selectedItem);
        }
    }

    protected static class AutoScrollableListView<M extends ModelData>
    extends ListView<M> {
        protected AutoScrollableListView() {
        }

        protected void autoScrollToSelected() {
            Element elem;
            ModelData selectedItem = this.getSelectionModel().getSelectedItem();
            if (selectedItem != null && (elem = this.getElement(this.getStore().indexOf(selectedItem))) != null) {
                this.fly(elem).scrollIntoView(this.getElement(), false);
            }
        }

        protected void onRender(Element target, int index) {
            super.onRender(target, index);
            this.getSelectionModel().addListener(Events.SelectionChange, (Listener)new Listener<SelectionChangedEvent<GWTResourceBundleEntry>>(){

                public void handleEvent(SelectionChangedEvent<GWTResourceBundleEntry> be) {
                    if (be.getSelection().size() > 0) {
                        this.autoScrollToSelected();
                    }
                }
            });
        }
    }
}

