/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACE;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.acleditor.AclEditor;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineValidation;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;

public class RolesTabItem
extends EditEngineTabItem {
    private static List<AclEditor> rolesEditors = new ArrayList<AclEditor>();
    private transient AclEditor rolesEditor;
    private Set<String> roles;
    private Set<String> roleGroups;
    private boolean canBreakInheritance = false;
    private String autoAddRole;

    @Override
    public AsyncTabItem create(GWTEngineTab engineTab, NodeHolder engine) {
        rolesEditors.clear();
        return super.create(engineTab, engine);
    }

    @Override
    public void init(NodeHolder engine, AsyncTabItem tab, String locale) {
        if (engine.getAcl() != null) {
            tab.setProcessed(true);
            GWTJahiaNode node = engine.getNode() != null ? engine.getNode() : engine.getTargetNode();
            this.rolesEditor = new AclEditor(engine.getAcl(), node.getSiteKey(), this.roles, this.roleGroups, rolesEditors);
            this.rolesEditor.setReadOnly(!PermissionsUtils.isPermitted("jcr:modifyAccessControl", node) || node.isLocked() != false);
            this.rolesEditor.setCanBreakInheritance(this.canBreakInheritance);
            this.rolesEditor.setAutoAddRole(this.autoAddRole);
            tab.setLayout((Layout)new FitLayout());
            this.rolesEditor.addNewAclPanel((LayoutContainer)tab);
        }
    }

    @Override
    public void setProcessed(boolean processed) {
        if (!processed) {
            rolesEditors.remove(this.rolesEditor);
            this.rolesEditor = null;
        }
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Set<String> getRoleGroups() {
        return this.roleGroups;
    }

    public void setRoleGroups(Set<String> roleGroups) {
        this.roleGroups = roleGroups;
    }

    public boolean isCanBreakInheritance() {
        return this.canBreakInheritance;
    }

    public void setCanBreakInheritance(boolean canBreakInheritance) {
        this.canBreakInheritance = canBreakInheritance;
    }

    public String getAutoAddRole() {
        return this.autoAddRole;
    }

    public void setAutoAddRole(String autoAddRole) {
        this.autoAddRole = autoAddRole;
    }

    @Override
    public void doValidate(List<EngineValidation.ValidateResult> validateResult, NodeHolder engine, TabItem tab, String selectedLanguage, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, TabPanel tabs) {
        if (this.canBreakInheritance && this.rolesEditor != null && this.rolesEditor.getBreakAllInheritance().booleanValue()) {
            for (GWTJahiaNodeACE ace : this.rolesEditor.getAcl().getAce()) {
                if (ace.getRoles().isEmpty()) continue;
                for (Boolean granted : ace.getRoles().values()) {
                    if (!granted.booleanValue()) continue;
                    return;
                }
            }
            EngineValidation.ValidateResult result = new EngineValidation.ValidateResult();
            result.errorTab = tab;
            result.message = Messages.get("label.breakInheritanceWarning", "You are going to break acl inheritance, and you did not assign any role to users. You may loose access to this content.");
            validateResult.add(result);
        }
    }

    @Override
    public void doSave(GWTJahiaNode node, List<GWTJahiaNodeProperty> changedProperties, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, Set<String> addedTypes, Set<String> removedTypes, List<GWTJahiaNode> chidren, GWTJahiaNodeACL acl) {
        if (this.rolesEditor == null) {
            return;
        }
        HashMap<String, GWTJahiaNodeACE> aceMap = new HashMap<String, GWTJahiaNodeACE>();
        for (GWTJahiaNodeACE ace : acl.getAce()) {
            aceMap.put(ace.getPrincipalType() + ace.getPrincipalKey(), ace);
        }
        if (acl.getAvailableRoles() == null) {
            acl.setAvailableRoles(new HashMap<String, List<String>>());
        }
        GWTJahiaNodeACL modifiedAcl = this.rolesEditor.getAcl();
        acl.setBreakAllInheritance(modifiedAcl.isBreakAllInheritance());
        for (GWTJahiaNodeACE modifiedAce : modifiedAcl.getAce()) {
            if (!aceMap.containsKey(modifiedAce.getPrincipalType() + modifiedAce.getPrincipalKey())) {
                aceMap.put(modifiedAce.getPrincipalType() + modifiedAce.getPrincipalKey(), modifiedAce);
                acl.getAce().add(modifiedAce);
                continue;
            }
            GWTJahiaNodeACE mergedAce = (GWTJahiaNodeACE)aceMap.get(modifiedAce.getPrincipalType() + modifiedAce.getPrincipalKey());
            mergedAce.getRoles().keySet().removeAll(this.rolesEditor.getDisplayedRoles());
            mergedAce.getRoles().putAll(modifiedAce.getRoles());
            mergedAce.getInheritedRoles().keySet().removeAll(this.rolesEditor.getDisplayedRoles());
            mergedAce.getInheritedRoles().putAll(modifiedAce.getInheritedRoles());
        }
    }
}

