/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.job;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BasePagingLoadConfig;
import com.extjs.gxt.ui.client.data.BasePagingLoadResult;
import com.extjs.gxt.ui.client.data.BasePagingLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.GroupingLoadConfig;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.PagingLoader;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.event.WindowEvent;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.WidgetComponent;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.grid.GroupColumnData;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.menu.CheckMenuItem;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.toolbar.PagingToolBar;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.job.GWTJahiaJobDetail;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.Formatter;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;

public class JobListPanel
extends LayoutContainer {
    private FormPanel detailsPanel;
    private List<GWTJahiaJobDetail> selectedItems = null;
    private transient Timer timer;
    private Button deleteButton;
    private PagingToolBar pagingToolBar;
    private static final String STATUS_EXECUTING = "executing";
    public static final String STATUS_ADDED = "added";
    public static final String STATUS_SCHEDULED = "scheduled";
    private int autoRefreshInterval = 10;
    private boolean autoRefreshActivated = false;
    private List<String> activeGroupNames = null;
    private boolean adminMode;
    private Grid<GWTJahiaJobDetail> grid;

    public JobListPanel(boolean adminMode) {
        super((Layout)new BorderLayout());
        this.adminMode = adminMode;
        this.init();
    }

    private void init() {
        this.setBorders(false);
        this.activeGroupNames = new ArrayList<String>();
        this.activeGroupNames.add("ActionJob");
        this.activeGroupNames.add("PublicationJob");
        this.activeGroupNames.add("ImportJob");
        this.activeGroupNames.add("SitemapJob");
        this.activeGroupNames.add("RuleJob");
        final JahiaContentManagementServiceAsync service = JahiaContentManagementService.App.getInstance();
        RpcProxy<PagingLoadResult<GWTJahiaJobDetail>> proxy = new RpcProxy<PagingLoadResult<GWTJahiaJobDetail>>(){

            protected void load(Object loadConfig, AsyncCallback<PagingLoadResult<GWTJahiaJobDetail>> callback) {
                if (loadConfig == null) {
                    service.getJobs(0, Integer.MAX_VALUE, null, null, null, JobListPanel.this.activeGroupNames, callback);
                } else if (loadConfig instanceof BasePagingLoadConfig) {
                    BasePagingLoadConfig pagingLoadConfig = (BasePagingLoadConfig)loadConfig;
                    int limit = pagingLoadConfig.getLimit();
                    int offset = pagingLoadConfig.getOffset();
                    Style.SortDir sortDir = pagingLoadConfig.getSortDir();
                    String sortField = pagingLoadConfig.getSortField();
                    service.getJobs(offset, limit, sortField, sortDir.name(), ((GroupingLoadConfig)loadConfig).getGroupBy(), JobListPanel.this.activeGroupNames, callback);
                } else {
                    callback.onSuccess((Object)new BasePagingLoadResult(new ArrayList()));
                }
            }
        };
        BasePagingLoader loader = new BasePagingLoader((DataProxy)proxy);
        loader.setRemoteSort(true);
        loader.setReuseLoadConfig(true);
        GroupingStore<GWTJahiaJobDetail> store = new GroupingStore<GWTJahiaJobDetail>((ListLoader)loader){

            public void groupBy(String field) {
                super.groupBy(field);
                JobListPanel.this.grid.getState().put("groupBy", field);
                JobListPanel.this.grid.saveState();
            }
        };
        this.pagingToolBar = new PagingToolBar(50);
        this.pagingToolBar.bind((PagingLoader)loader);
        this.pagingToolBar.addStyleName("jobs-paging-toolbar");
        ArrayList<ColumnConfig> config = new ArrayList<ColumnConfig>();
        ColumnConfig column = new ColumnConfig("creationTime", Messages.get("label.creationTime", "Start date"), 100);
        column.setDateTimeFormat(Formatter.DEFAULT_DATETIME_FORMAT);
        column.setSortable(true);
        config.add(column);
        column = new ColumnConfig("group", Messages.get("label.type", "Type"), 100);
        column.setSortable(false);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaJobDetail>(){

            public Object render(GWTJahiaJobDetail jobDetail, String property, ColumnData config, int rowIndex, int colIndex, ListStore<GWTJahiaJobDetail> gwtJahiaJobDetailListStore, Grid<GWTJahiaJobDetail> gwtJahiaJobDetailGrid) {
                return new Label(Messages.get("label." + jobDetail.getGroup() + ".task", jobDetail.getGroup()));
            }
        });
        config.add(column);
        column = new ColumnConfig("description", Messages.get("label.description", "Description"), 100);
        column.setSortable(false);
        column.setGroupable(false);
        config.add(column);
        column = new ColumnConfig("status", Messages.get("label.status", "Status"), 100);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaJobDetail>(){

            public Object render(GWTJahiaJobDetail jobDetail, String property, ColumnData config, int rowIndex, int colIndex, ListStore store, Grid grid) {
                return Messages.get("label.job.status." + jobDetail.getStatus());
            }
        });
        column.setSortable(false);
        config.add(column);
        column = new ColumnConfig("duration", Messages.get("label.duration", "Duration"), 140);
        column.setSortable(true);
        column.setGroupable(false);
        column.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaJobDetail>(){

            public Object render(GWTJahiaJobDetail jobDetail, String property, ColumnData config, int rowIndex, int colIndex, ListStore<GWTJahiaJobDetail> store, Grid<GWTJahiaJobDetail> grid) {
                Long duration = jobDetail.getDuration();
                String display = "-";
                if (duration != null) {
                    display = duration < 1000L ? duration + " " + Messages.get("label.milliseconds.short", "ms") : (duration < 60000L ? (int)(duration / 1000L) + " " + Messages.get("label.seconds.short", "sec") : (duration < 3600000L ? (int)(duration / 60000L) + " " + Messages.get("label.minutes.short", "min") + " " + (int)(duration / 1000L) % 60 + " " + Messages.get("label.seconds.short", "sec") : (int)(duration / 3600000L) + " " + Messages.get("label.hours.short", "h") + " " + (int)(duration / 60L * 1000L) % 60 + " " + Messages.get("label.minutes.short", "min")));
                }
                if (JobListPanel.STATUS_EXECUTING.equals(jobDetail.getStatus())) {
                    return new Label(Messages.get("label.executingSince", "Executing since ") + display + "...");
                }
                return new Label(display);
            }
        });
        config.add(column);
        column = new ColumnConfig("user", Messages.get("label.user", "User"), 100);
        column.setSortable(false);
        column.setGroupable(true);
        column.setHidden(true);
        config.add(column);
        column = new ColumnConfig("message", Messages.get("label.message", "Message"), 100);
        column.setSortable(false);
        column.setGroupable(false);
        column.setHidden(true);
        config.add(column);
        column = new ColumnConfig("name", Messages.get("label.name", "Name"), 100);
        column.setSortable(false);
        column.setGroupable(false);
        column.setHidden(true);
        config.add(column);
        final ColumnModel cm = new ColumnModel(config);
        GroupingView view = new GroupingView();
        view.setShowGroupedColumn(false);
        view.setForceFit(true);
        view.setGroupRenderer(new GridGroupRenderer(){

            public String render(GroupColumnData data) {
                String l;
                String f = cm.getColumnById(data.field).getHeaderHtml();
                String string = l = data.models.size() == 1 ? Messages.get("label.item", "Item") : Messages.get("label.items", "Items");
                if (data.field.equals("status")) {
                    return f + ": " + Messages.get("label.job.status." + data.group) + " (" + data.models.size() + " " + l + ")";
                }
                return f + ": " + data.group + " (" + data.models.size() + " " + l + ")";
            }
        });
        this.grid = new Grid((ListStore)store, cm);
        this.grid.setBorders(true);
        this.grid.setView((GridView)view);
        this.grid.setAutoExpandColumn("description");
        this.grid.setTrackMouseOver(false);
        this.grid.setStateId("jobPagingGrid");
        this.grid.setStateful(true);
        this.grid.addListener(Events.Attach, (Listener)new Listener<GridEvent<GWTJahiaJobDetail>>((GroupingStore)store, loader){
            final /* synthetic */ GroupingStore val$store;
            final /* synthetic */ BasePagingLoader val$loader;
            {
                this.val$store = groupingStore;
                this.val$loader = basePagingLoader;
            }

            public void handleEvent(GridEvent<GWTJahiaJobDetail> be) {
                LoadConfig config = new LoadConfig();
                config.setOffset(0);
                config.setLimit(50);
                Map state = JobListPanel.this.grid.getState();
                String groupBy = state.get("groupBy") != null ? state.get("groupBy") : "status";
                config.setGroupBy(groupBy);
                this.val$store.groupBy(groupBy);
                this.val$store.setRemoteGroup(true);
                if (state.containsKey("offset")) {
                    int offset = (Integer)state.get("offset");
                    int limit = (Integer)state.get("limit");
                    config.setOffset(offset);
                    config.setLimit(limit);
                }
                if (state.containsKey("sortField")) {
                    config.setSortField((String)state.get("sortField"));
                    config.setSortDir(Style.SortDir.valueOf((String)((String)state.get("sortDir"))));
                }
                this.val$loader.load((Object)config);
            }
        });
        this.grid.setLoadMask(true);
        this.grid.setBorders(true);
        this.grid.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaJobDetail>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaJobDetail> gwtJahiaJobDetailSelectionChangedEvent) {
                JobListPanel.this.selectedItems = gwtJahiaJobDetailSelectionChangedEvent.getSelection();
                if (JobListPanel.this.adminMode) {
                    for (GWTJahiaJobDetail jobDetail : JobListPanel.this.selectedItems) {
                        if (JobListPanel.STATUS_EXECUTING.equals(jobDetail.getStatus()) || JobListPanel.STATUS_SCHEDULED.equals(jobDetail.getStatus())) {
                            JobListPanel.this.deleteButton.disable();
                            break;
                        }
                        JobListPanel.this.deleteButton.enable();
                    }
                }
                JobListPanel.this.updateDetails();
            }
        });
        ToolBar topToolBar = new ToolBar();
        topToolBar.addStyleName("jobs-top-toolbar");
        Button filterButton = new Button(Messages.get("label.typeFilter", "Type filter"));
        final Menu filterMenu = new Menu();
        filterMenu.addStyleName("filter-menu");
        service.getAllJobGroupNames((AsyncCallback<List<String>>)new BaseAsyncCallback<List<String>>(){

            public void onSuccess(List<String> groupNames) {
                for (String groupName : groupNames) {
                    final CheckMenuItem groupActivated = new CheckMenuItem(Messages.get("label." + groupName + ".task", groupName));
                    groupActivated.setStateId(groupName);
                    if (JobListPanel.this.activeGroupNames.contains(groupName)) {
                        groupActivated.setChecked(true);
                    } else {
                        groupActivated.setChecked(false);
                    }
                    groupActivated.addListener(Events.CheckChange, (Listener)new Listener<MenuEvent>(){

                        public void handleEvent(MenuEvent be) {
                            String groupName = groupActivated.getStateId();
                            if (groupActivated.isChecked()) {
                                if (!JobListPanel.this.activeGroupNames.contains(groupName)) {
                                    JobListPanel.this.activeGroupNames.add(groupName);
                                }
                            } else {
                                JobListPanel.this.activeGroupNames.remove(groupName);
                            }
                            JobListPanel.this.pagingToolBar.refresh();
                        }
                    });
                    filterMenu.add((Component)groupActivated);
                }
            }
        });
        filterButton.setMenu(filterMenu);
        filterButton.addStyleName("jobs-filter-combo");
        topToolBar.add((Component)filterButton);
        topToolBar.add((Component)new SeparatorToolItem());
        final CheckBox autoRefreshCheckBox = new CheckBox();
        autoRefreshCheckBox.addStyleName("jobs-auto-refresh");
        autoRefreshCheckBox.setValue(Boolean.valueOf(this.autoRefreshActivated));
        autoRefreshCheckBox.setBoxLabel(Messages.get("label.autoRefresh", "Auto-refresh every"));
        autoRefreshCheckBox.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

            public void handleEvent(FieldEvent be) {
                Boolean autoRefreshEnabled = autoRefreshCheckBox.getValue();
                if (autoRefreshEnabled.booleanValue()) {
                    JobListPanel.this.autoRefreshActivated = true;
                    JobListPanel.this.stopAutoRefresh();
                    JobListPanel.this.startAutoRefresh();
                } else {
                    JobListPanel.this.autoRefreshActivated = false;
                    JobListPanel.this.stopAutoRefresh();
                }
            }
        });
        topToolBar.add((Component)autoRefreshCheckBox);
        final TextBox refreshIntervalTextBox = new TextBox();
        refreshIntervalTextBox.setWidth("3em");
        refreshIntervalTextBox.setText(Integer.toString(this.autoRefreshInterval));
        refreshIntervalTextBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String refreshTextValue = refreshIntervalTextBox.getText();
                int newRefreshInterval = -1;
                try {
                    newRefreshInterval = Integer.parseInt(refreshTextValue);
                }
                catch (NumberFormatException nfe) {
                    newRefreshInterval = -1;
                }
                if (newRefreshInterval >= 5 && newRefreshInterval <= 120) {
                    JobListPanel.this.autoRefreshInterval = newRefreshInterval;
                    if (JobListPanel.this.autoRefreshActivated) {
                        JobListPanel.this.stopAutoRefresh();
                        JobListPanel.this.startAutoRefresh();
                    }
                } else {
                    refreshIntervalTextBox.setText(Integer.toString(JobListPanel.this.autoRefreshInterval));
                }
            }
        });
        topToolBar.add((Component)new WidgetComponent((Widget)refreshIntervalTextBox));
        Label secondsLabel = new Label(" " + Messages.get("label.seconds", "seconds"));
        topToolBar.add((Component)secondsLabel);
        if (this.adminMode) {
            topToolBar.add((Component)new SeparatorToolItem());
            this.deleteButton = new Button(Messages.get("label.delete", "Delete"), StandardIconsProvider.STANDARD_ICONS.delete(), (SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    JobListPanel.this.showDeleteConfirmation(false);
                }
            });
            this.deleteButton.disable();
            topToolBar.add((Component)this.deleteButton);
            topToolBar.add((Component)new Button(Messages.get("label.deleteCompletedJobs", "Delete all completed"), StandardIconsProvider.STANDARD_ICONS.delete(), (SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    JobListPanel.this.showDeleteConfirmation(true);
                }
            }));
        }
        ContentPanel listPanel = new ContentPanel();
        listPanel.setFrame(true);
        listPanel.setCollapsible(false);
        listPanel.setAnimCollapse(false);
        listPanel.setHeaderVisible(false);
        listPanel.setLayout((Layout)new FitLayout());
        listPanel.add(this.grid);
        listPanel.setSize(600, 350);
        listPanel.setBottomComponent((Component)this.pagingToolBar);
        listPanel.setTopComponent((Component)topToolBar);
        this.grid.getAriaSupport().setLabelledBy(listPanel.getId());
        this.add((Component)listPanel);
        BorderLayoutData centerData = new BorderLayoutData(Style.LayoutRegion.CENTER);
        this.add((Widget)listPanel, (LayoutData)centerData);
        FormPanel detailPanel = new FormPanel();
        detailPanel.setBorders(true);
        detailPanel.setBodyBorder(true);
        detailPanel.setHeaderVisible(true);
        detailPanel.setHeadingHtml(Messages.get("label.detailed", "Details"));
        detailPanel.setScrollMode(Style.Scroll.AUTOY);
        detailPanel.setLabelWidth(100);
        this.detailsPanel = detailPanel;
        BorderLayoutData southData = new BorderLayoutData(Style.LayoutRegion.SOUTH, 200.0f);
        southData.setSplit(true);
        southData.setCollapsible(true);
        this.add((Widget)detailPanel, (LayoutData)southData);
        this.addListener(Events.Detach, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent be) {
                JobListPanel.this.stopAutoRefresh();
            }
        });
    }

    public void startAutoRefresh() {
        this.timer = new Timer(){

            public void run() {
                JobListPanel.this.pagingToolBar.refresh();
                this.schedule(JobListPanel.this.autoRefreshInterval * 1000);
            }
        };
        this.timer.run();
    }

    public void stopAutoRefresh() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected void showDeleteConfirmation(final boolean deleteAllCompleted) {
        final JahiaContentManagementServiceAsync service = JahiaContentManagementService.App.getInstance();
        Dialog dialog = new Dialog();
        dialog.addStyleName(deleteAllCompleted ? "modal-deletealljob-confirm" : "modal-deletejob-confirm");
        dialog.setModal(true);
        dialog.setHeadingHtml(Messages.get("label.delete", "Delete"));
        dialog.setButtons("yesno");
        dialog.addText(deleteAllCompleted ? Messages.get("label.deleteCompletedJobs.confirm", "Do you really want to delete all completed jobs?") : Messages.get("label.delete.confirm", "Do you really want to delete the current selection?"));
        dialog.setHideOnButtonClick(true);
        dialog.addListener(Events.Hide, (Listener)new Listener<WindowEvent>(){

            public void handleEvent(WindowEvent be) {
                if (be.getButtonClicked().getItemId().equalsIgnoreCase("yes")) {
                    if (deleteAllCompleted) {
                        service.deleteAllCompletedJobs((AsyncCallback<Integer>)new BaseAsyncCallback<Integer>(){

                            @Override
                            public void onApplicationFailure(Throwable caught) {
                                Window.alert((String)(Messages.get("fm_fail") + "\n" + caught.getLocalizedMessage()));
                                Log.error((String)Messages.get("fm_fail"), (Throwable)caught);
                            }

                            public void onSuccess(Integer result) {
                                MessageBox.info((String)Messages.get("label.delete", "Delete"), (String)Messages.getWithArgs("label.deleteCompletedJobs.success", "Deleted {0} completed jobs", new Object[]{result}), null);
                                if (result != null && result > 0) {
                                    JobListPanel.this.pagingToolBar.refresh();
                                }
                            }
                        });
                    } else {
                        for (GWTJahiaJobDetail jobDetail : JobListPanel.this.selectedItems) {
                            service.deleteJob(jobDetail.getName(), jobDetail.getGroup(), (AsyncCallback<Boolean>)new BaseAsyncCallback<Boolean>(){

                                @Override
                                public void onApplicationFailure(Throwable caught) {
                                    Window.alert((String)(Messages.get("fm_fail") + "\n" + caught.getLocalizedMessage()));
                                    Log.error((String)Messages.get("fm_fail"), (Throwable)caught);
                                }

                                public void onSuccess(Boolean result) {
                                    JobListPanel.this.pagingToolBar.refresh();
                                }
                            });
                        }
                    }
                }
            }
        });
        dialog.show();
    }

    public void addDetail(String labelKey, String labelDefaultValue, Object value) {
        if (value != null) {
            TextField textField = new TextField();
            textField.setFieldLabel(Messages.get(labelKey, labelDefaultValue));
            textField.setReadOnly(true);
            if (value instanceof String) {
                textField.setValue(value);
            } else if (value instanceof Date) {
                textField.setValue((Object)Formatter.getFormattedDate((Date)value));
            } else {
                textField.setValue((Object)value.toString());
            }
            this.detailsPanel.add((Widget)textField, (LayoutData)new FormData("98%"));
        }
    }

    public void addTimeDetail(String labelKey, String labelDefaultValue, Object value) {
        if (value instanceof Long) {
            Date date = new Date((Long)value);
            this.addDetail(labelKey, labelDefaultValue, date);
        } else {
            this.addDetail(labelKey, labelDefaultValue, value);
        }
    }

    public void updateDetails() {
        if (this.detailsPanel == null) {
            return;
        }
        if (this.selectedItems == null || this.selectedItems.size() == 0) {
            return;
        }
        this.detailsPanel.removeAll();
        if (this.selectedItems.size() == 1) {
            GWTJahiaJobDetail jobDetail = this.selectedItems.get(0);
            this.addDetail("label.description", "Description", jobDetail.getDescription());
            this.addDetail("label.status", "Status", jobDetail.getStatus());
            StringBuffer paths = new StringBuffer();
            for (String path : jobDetail.getTargetPaths()) {
                paths.append(path);
                paths.append(" ");
            }
            this.addDetail("label.targetPaths", "Target paths", paths.toString());
            this.addDetail("label.fileName", "File name", jobDetail.getFileName());
            this.addDetail("label.name", "Name", jobDetail.getName());
            this.addDetail("label.creationTime", "Creation time", jobDetail.getCreationTime());
            this.addDetail("label.user", "User key", jobDetail.getUser());
            this.addDetail("label.group", "Group", jobDetail.getGroup());
            this.addDetail("label.message", "Message", jobDetail.getMessage());
            this.addTimeDetail("label.beginTime", "Start time", jobDetail.getBeginTime());
            this.addTimeDetail("label.endTime", "End time", jobDetail.getEndTime());
            this.addDetail("label.duration", "Duration", jobDetail.getDuration());
            this.addDetail("label.locale", "Locale code", jobDetail.getLocale());
            this.addDetail("label.targetNodeIdentifier", "Target node identifier", jobDetail.getTargetNodeIdentifier());
            this.addDetail("label.targetAction", "Target action", jobDetail.getTargetAction());
            this.addDetail("label.targetWorkspace", "Target workspace", jobDetail.getTargetWorkspace());
        } else {
            this.detailsPanel.add((Widget)new HTML("<b>" + Messages.get("label.selectedJobCount", "Number of selected jobs") + " :</b> " + this.selectedItems.size()));
        }
        this.detailsPanel.layout();
    }

    static class LoadConfig
    extends BasePagingLoadConfig
    implements GroupingLoadConfig {
        LoadConfig() {
        }

        public String getGroupBy() {
            return (String)this.get("groupBy");
        }

        public void setGroupBy(String groupBy) {
            this.set("groupBy", groupBy);
        }
    }
}

