/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.content.CopyPasteEngine;
import org.jahia.ajax.gwt.client.util.content.JCRClientUtils;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleHelper;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ClipboardActionItem;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class CutActionItem
extends NodeTypeAwareBaseActionItem {
    @Override
    public void onComponentSelection() {
        List<GWTJahiaNode> selectedItems = this.linker.getSelectionContext().getMultipleSelection();
        if (selectedItems != null && selectedItems.size() > 0) {
            final ArrayList<GWTJahiaNode> actualSelection = new ArrayList<GWTJahiaNode>();
            ArrayList<GWTJahiaNode> lockedFiles = new ArrayList<GWTJahiaNode>();
            for (GWTJahiaNode node : selectedItems) {
                if (node.isLocked().booleanValue()) {
                    lockedFiles.add(node);
                    continue;
                }
                actualSelection.add(node);
            }
            if (!lockedFiles.isEmpty()) {
                StringBuilder s = new StringBuilder(Messages.get("warning.lock.label"));
                for (GWTJahiaNode node : lockedFiles) {
                    s.append("\n").append(node.getName());
                }
                Window.alert((String)s.toString());
            }
            if (!actualSelection.isEmpty()) {
                JahiaContentManagementService.App.getInstance().checkWriteable(JCRClientUtils.getPathesList(actualSelection), new BaseAsyncCallback(){

                    @Override
                    public void onApplicationFailure(Throwable throwable) {
                        Window.alert((String)(Messages.get("failure.cut.label") + "\n" + throwable.getLocalizedMessage()));
                    }

                    public void onSuccess(Object o) {
                        CopyPasteEngine.getInstance().setCutPaths(actualSelection);
                        CutActionItem.this.linker.select(null);
                        ClipboardActionItem.setCopied(actualSelection);
                    }
                });
            }
        }
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        this.setEnabled(lh.getMultipleSelection() != null && lh.getMultipleSelection().size() > 0 && this.hasPermission(lh.getSelectionPermissions()) && PermissionsUtils.isPermitted("jcr:removeNode", lh.getSelectionPermissions()) && !lh.isRootNode() && !lh.isLocked() && !lh.getMultipleSelection().get(0).getPath().equals("/sites/" + lh.getMultipleSelection().get(0).getSiteKey() + "/" + lh.getMultipleSelection().get(0).getName()) && !lh.getMultipleSelection().get(0).getPath().equals("/" + lh.getMultipleSelection().get(0).getName()) && this.isNodeTypeAllowed(lh.getMultipleSelection()));
    }

    @Override
    protected boolean isNodeTypeAllowed(GWTJahiaNode selectedNode) {
        Boolean canUseComponentForCreate;
        GWTJahiaNodeType nodeType = ModuleHelper.getNodeType(selectedNode.getNodeTypes().get(0));
        if (nodeType != null && (canUseComponentForCreate = (Boolean)nodeType.get("canUseComponentForCreate")) != null && !canUseComponentForCreate.booleanValue()) {
            return false;
        }
        return super.isNodeTypeAllowed(selectedNode);
    }
}

