/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.poller.Poller;
import org.jahia.ajax.gwt.client.widget.poller.ToolbarWarningEvent;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class DisplayToolbarWarningsActionItem
extends BaseActionItem
implements Poller.PollListener<ToolbarWarningEvent> {
    private static final long serialVersionUID = 3328698500846922180L;

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        this.refreshMessages();
        Poller.getInstance().registerListener(this, ToolbarWarningEvent.class);
    }

    @Override
    public Component createNewToolItem() {
        Button b = (Button)super.createNewToolItem();
        b.setText(Messages.get("label.notifications", "Notifications"));
        b.setEnabled(false);
        return b;
    }

    private void refreshMessages() {
        JahiaContentManagementService.App.getInstance().getToolbarWarnings((AsyncCallback<String>)new BaseAsyncCallback<String>(){

            public void onSuccess(String toolbarWarnings) {
                Button b = (Button)DisplayToolbarWarningsActionItem.this.getTextToolItem();
                if (toolbarWarnings != null && toolbarWarnings.length() > 0) {
                    String[] messagesTab = toolbarWarnings.split("\\|\\|");
                    Menu menu = new Menu();
                    menu.addStyleName("toolbar-warning-messages");
                    b.setMenu(menu);
                    for (String s : messagesTab) {
                        MenuItem m = new MenuItem();
                        m.setText(s);
                        menu.add((Component)m);
                    }
                    b.setEnabled(true);
                    b.show();
                } else {
                    b.setEnabled(false);
                    b.hide();
                }
            }
        });
    }

    @Override
    public void handlePollingResult(ToolbarWarningEvent result) {
        this.refreshMessages();
    }
}

