/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.widget.Info;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class NewPackageActionItem
extends NodeTypeAwareBaseActionItem {
    private static final long serialVersionUID = -2760798544350502175L;

    @Override
    public void onComponentSelection() {
        GWTJahiaNode parent = this.linker.getSelectionContext().getSingleSelection();
        if (parent != null) {
            final String nodeName = Window.prompt((String)Messages.get("label.newJavaPackage"), (String)"untitled");
            if (nodeName == null || nodeName.length() == 0 || !nodeName.matches("^([a-z0-9-_]+\\.)*[a-z0-9-_]+$")) {
                Info.display((String)Messages.get("label.error", "Error"), (String)Messages.getWithArgs("label.newJavaPackage.wrong", "Wrong package name {0}", new Object[]{nodeName}));
                return;
            }
            this.linker.loading("");
            StringBuilder parentPath = new StringBuilder(parent.getPath());
            HashMap<String, String> parentNodesType = new HashMap<String, String>();
            ArrayList<String> packages = new ArrayList<String>(Arrays.asList(nodeName.split("\\.")));
            String newNodeName = (String)packages.remove(packages.size() - 1);
            String nodeType = "jnt:folder";
            for (String packageName : packages) {
                if (parentPath.length() == 0 || parentPath.charAt(parentPath.length() - 1) != '/') {
                    parentPath.append("/");
                }
                parentPath.append(packageName);
                parentNodesType.put(parentPath.toString(), nodeType);
            }
            JahiaContentManagementService.App.getInstance().createNode(parentPath.toString(), newNodeName, nodeType, null, null, null, null, null, parentNodesType, false, (AsyncCallback<GWTJahiaNode>)new BaseAsyncCallback<GWTJahiaNode>(){

                public void onSuccess(GWTJahiaNode node) {
                    NewPackageActionItem.this.linker.setSelectPathAfterDataUpdate(Arrays.asList(node.getPath()));
                    NewPackageActionItem.this.linker.loaded();
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("node", node);
                    NewPackageActionItem.this.linker.refresh(data);
                }

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    NewPackageActionItem.this.linker.loaded();
                    Info.display((String)Messages.get("label.error", "Error"), (String)Messages.getWithArgs("label.newJavaPackage.failed", "Failed to create package {0}", new Object[]{nodeName}));
                }
            });
        }
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        this.setEnabled(lh.getSingleSelection() != null && !lh.isLocked() && this.hasPermission(lh.getSelectionPermissions()) && PermissionsUtils.isPermitted("jcr:addChildNodes", lh.getSelectionPermissions()) && this.isNodeTypeAllowed(lh.getSingleSelection()));
    }
}

