/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleHelper;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class UndeleteActionItem
extends NodeTypeAwareBaseActionItem {
    @Override
    public void onComponentSelection() {
        final LinkerSelectionContext lh = this.linker.getSelectionContext();
        if (!lh.getMultipleSelection().isEmpty()) {
            String message = null;
            message = lh.getMultipleSelection().size() > 1 ? Messages.getWithArgs("message.undelete.multiple.confirm", "Do you really want to undelete the {0} selected resources?", new String[]{String.valueOf(lh.getMultipleSelection().size())}) : Messages.getWithArgs("message.undelete.confirm", "Do you really want to undelete the selected resource {0}?", new String[]{lh.getSingleSelection().getDisplayName()});
            MessageBox.confirm((String)Messages.get("label.information", "Information"), (String)message, (Listener)new Listener<MessageBoxEvent>(){

                public void handleEvent(MessageBoxEvent be) {
                    if (be.getButtonClicked().getItemId().equalsIgnoreCase("yes")) {
                        final ArrayList<String> l = new ArrayList<String>();
                        for (GWTJahiaNode node : lh.getMultipleSelection()) {
                            l.add(node.getPath());
                        }
                        JahiaContentManagementService.App.getInstance().undeletePaths(l, new BaseAsyncCallback(){

                            @Override
                            public void onApplicationFailure(Throwable throwable) {
                                Log.error((String)throwable.getMessage(), (Throwable)throwable);
                                MessageBox.alert((String)Messages.get("label.error", "Error"), (String)throwable.getMessage(), null);
                            }

                            public void onSuccess(Object result) {
                                EditLinker el = null;
                                if (UndeleteActionItem.this.linker instanceof SidePanelTabItem.SidePanelLinker) {
                                    el = ((SidePanelTabItem.SidePanelLinker)UndeleteActionItem.this.linker).getEditLinker();
                                } else if (UndeleteActionItem.this.linker instanceof EditLinker) {
                                    el = (EditLinker)UndeleteActionItem.this.linker;
                                }
                                HashMap<String, Object> data = new HashMap<String, Object>();
                                if (el != null && l.contains(el.getSelectionContext().getMainNode().getPath())) {
                                    data.put("node", el.getSelectionContext().getMainNode());
                                } else {
                                    data.put("refreshAll", true);
                                }
                                UndeleteActionItem.this.linker.refresh(data);
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        List<GWTJahiaNode> selection = lh.getMultipleSelection();
        boolean canUndelete = false;
        if (selection != null && selection.size() > 0 && this.hasPermission(lh.getSelectionPermissions()) && PermissionsUtils.isPermitted("jcr:removeNode", lh.getSelectionPermissions()) && this.isNodeTypeAllowed(selection)) {
            GWTJahiaNode gwtJahiaNode;
            canUndelete = true;
            Iterator<GWTJahiaNode> iterator = selection.iterator();
            while (iterator.hasNext() && (canUndelete = (canUndelete &= (gwtJahiaNode = iterator.next()).isMarkedForDeletionRoot()) && (gwtJahiaNode.isLocked() == false || UndeleteActionItem.isLockedForDeletion(gwtJahiaNode)))) {
            }
        }
        this.setEnabled(canUndelete);
    }

    static boolean isLockedForDeletion(GWTJahiaNode node) {
        Map<String, List<String>> lockInfos = node.getLockInfos();
        return lockInfos != null && lockInfos.containsKey(null) && !lockInfos.get(null).isEmpty() && lockInfos.get(null).size() == 1 && lockInfos.get(null).get(0).equals("label.locked.by.deletion");
    }

    @Override
    protected boolean isNodeTypeAllowed(GWTJahiaNode selectedNode) {
        Boolean canUseComponentForCreate;
        GWTJahiaNodeType nodeType = ModuleHelper.getNodeType(selectedNode.getNodeTypes().get(0));
        if (nodeType != null && (canUseComponentForCreate = (Boolean)nodeType.get("canUseComponentForCreate")) != null && !canUseComponentForCreate.booleanValue()) {
            return false;
        }
        return super.isNodeTypeAllowed(selectedNode);
    }
}

