/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.event.WindowEvent;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;
import org.jahia.ajax.gwt.client.widget.toolbar.action.SiteSwitcherActionItem;
import org.jahia.ajax.gwt.client.widget.toolbar.action.SourceControlDialog;

public class UpdateModuleActionItem
extends BaseActionItem {
    @Override
    public void onComponentSelection() {
        GWTJahiaNode siteNode = JahiaGWTParameters.getSiteNode();
        String s = (String)siteNode.get("j:versionInfo");
        if (siteNode.get("j:sourcesFolder") != null) {
            if (s.endsWith("-SNAPSHOT") && siteNode.get("j:scmURI") != null) {
                this.linker.loading(Messages.get("label.sourceControl.update.module", "Updating module..."));
                JahiaContentManagementService.App.getInstance().updateModule(JahiaGWTParameters.getSiteKey(), (AsyncCallback<String>)new BaseAsyncCallback<String>(){

                    public void onSuccess(String result) {
                        UpdateModuleActionItem.this.linker.loaded();
                        UpdateModuleActionItem.this.showUpdateResult(result, false);
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("event", "update");
                        data.put("refreshAll", "true");
                        UpdateModuleActionItem.this.linker.refresh(data);
                    }

                    @Override
                    public void onApplicationFailure(Throwable caught) {
                        UpdateModuleActionItem.this.linker.loaded();
                        UpdateModuleActionItem.this.showUpdateResult(caught.getMessage(), true);
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("event", "update");
                        UpdateModuleActionItem.this.linker.refresh(data);
                    }
                });
            } else {
                final SourceControlDialog dialog = new SourceControlDialog(Messages.get("label.sendToSourceControl", "Send to source control"), false, false);
                dialog.addCallback(new Listener<WindowEvent>(){

                    public void handleEvent(WindowEvent be) {
                        UpdateModuleActionItem.this.linker.loading(Messages.get("label.sourceControl.sending.sources", "Sending sources..."));
                        JahiaContentManagementService.App.getInstance().sendToSourceControl(JahiaGWTParameters.getSiteKey(), dialog.getUri(), dialog.getScmType(), (AsyncCallback<GWTJahiaNode>)new BaseAsyncCallback<GWTJahiaNode>(){

                            public void onSuccess(GWTJahiaNode result) {
                                JahiaGWTParameters.getSitesMap().put(result.getUUID(), result);
                                JahiaGWTParameters.setSiteNode(result);
                                ((EditLinker)UpdateModuleActionItem.this.linker).handleNewMainSelection();
                                UpdateModuleActionItem.this.linker.loaded();
                            }

                            @Override
                            public void onApplicationFailure(Throwable caught) {
                                UpdateModuleActionItem.this.linker.loaded();
                                MessageBox.alert((String)Messages.get("label.error", "Error"), (String)caught.getMessage(), null);
                            }
                        });
                    }
                });
                dialog.show();
            }
        } else {
            final SourceControlDialog dialog = new SourceControlDialog(Messages.get("label.sourceControlDialog.header", "Get sources from source control"), false, true);
            if (siteNode.get("j:scmURI") != null) {
                String value = (String)siteNode.get("j:scmURI");
                if (value.startsWith("scm:")) {
                    value = value.substring(4);
                    String type = value.substring(0, value.indexOf(":"));
                    dialog.setScmType(type);
                    value = value.substring(value.indexOf(":") + 1);
                }
                dialog.setUri(value);
            }
            dialog.addCallback(new Listener<WindowEvent>(){

                public void handleEvent(WindowEvent be) {
                    UpdateModuleActionItem.this.linker.loading(Messages.get("label.sourceControl.getting.sources", "Getting sources..."));
                    JahiaContentManagementService.App.getInstance().checkoutModule(JahiaGWTParameters.getSiteKey(), dialog.getUri(), dialog.getScmType(), dialog.getBranchOrTag(), null, (AsyncCallback<GWTJahiaNode>)new BaseAsyncCallback<GWTJahiaNode>(){

                        public void onSuccess(GWTJahiaNode result) {
                            UpdateModuleActionItem.this.linker.loaded();
                            JahiaGWTParameters.getSitesMap().put(result.getUUID(), result);
                            JahiaGWTParameters.setSiteNode(result);
                            if (((EditLinker)UpdateModuleActionItem.this.linker).getSidePanel() != null) {
                                HashMap<String, Object> data = new HashMap<String, Object>();
                                data.put("refreshAll", true);
                                ((EditLinker)UpdateModuleActionItem.this.linker).getSidePanel().refresh(data);
                            }
                            SiteSwitcherActionItem.refreshAllSitesList(UpdateModuleActionItem.this.linker);
                            ((EditLinker)UpdateModuleActionItem.this.linker).handleNewMainSelection();
                            Info.display((String)Messages.get("label.information", "Information"), (String)Messages.get("label.sourceControl.source.downloaded", "Sources downloaded"));
                        }

                        @Override
                        public void onApplicationFailure(Throwable caught) {
                            UpdateModuleActionItem.this.linker.loaded();
                            MessageBox.alert((String)Messages.get("label.error", "Error"), (String)caught.getMessage(), null);
                        }
                    });
                }
            });
            dialog.show();
        }
    }

    @Override
    public void handleNewLinkerSelection() {
        GWTJahiaNode siteNode = JahiaGWTParameters.getSiteNode();
        String s = (String)siteNode.get("j:versionInfo");
        this.setEnabled(true);
        if (siteNode.get("j:sourcesFolder") != null) {
            if (siteNode.get("j:scmURI") != null) {
                this.updateTitle(Messages.get("label.updateModule", "Update module"));
                if (!s.endsWith("-SNAPSHOT")) {
                    this.setEnabled(false);
                }
            } else {
                this.updateTitle(Messages.get("label.sendToSourceControl", "Send to source control"));
            }
        } else {
            this.setEnabled(false);
        }
    }

    private void showUpdateResult(String output, boolean isError) {
        final Window wnd = new Window();
        wnd.addStyleName("update-results-modal");
        wnd.setWidth(450);
        wnd.setHeight(250);
        wnd.setModal(true);
        wnd.setBlinkModal(true);
        wnd.setHeadingHtml(Messages.get("label.updateModule", "Update module"));
        wnd.setLayout((Layout)new FitLayout());
        FormPanel form = new FormPanel();
        form.setHeaderVisible(false);
        form.setFrame(false);
        form.setLabelAlign(FormPanel.LabelAlign.TOP);
        form.setFieldWidth(415);
        TextArea message = new TextArea();
        message.setName("status");
        message.setFieldLabel(Messages.get("label.status", "Status") + " - " + (isError ? Messages.get("label.error", "Error") : Messages.get("label.sourceControl.module.updated", "Module updated")));
        message.setHeight(120);
        message.setValue((Object)output);
        message.setReadOnly(true);
        form.add((Widget)message);
        Button btnClose = new Button(Messages.get("label.close", "Close"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                wnd.hide();
            }
        });
        btnClose.addStyleName("button-close");
        form.addButton(btnClose);
        form.setButtonAlign(Style.HorizontalAlignment.CENTER);
        wnd.add((Widget)form);
        wnd.layout();
        wnd.setFocusWidget((Widget)message);
        wnd.show();
    }
}

