/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.Formatter;
import org.jahia.ajax.gwt.client.util.URL;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;

public class InfoTabItem
extends EditEngineTabItem {
    private transient FlowPanel infoPanel;

    @Override
    public void init(NodeHolder engine, AsyncTabItem tab, String locale) {
        if (!tab.isProcessed()) {
            this.infoPanel = new FlowPanel();
            this.infoPanel.addStyleName("infoPane");
            tab.add((Widget)this.infoPanel);
            Grid g = new Grid(1, 2);
            g.setCellSpacing(10);
            FlowPanel flowPanel = new FlowPanel();
            if (!engine.isMultipleSelection()) {
                Date date;
                Long s;
                String id;
                String path;
                String name;
                GWTJahiaNode selectedNode = engine.getNode();
                String preview = selectedNode.getPreview();
                if (preview != null) {
                    g.setWidget(0, 0, (Widget)new Image(URL.appendTimestamp(preview)));
                }
                if ((name = selectedNode.getName()) != null) {
                    flowPanel.add((Widget)new HTML("<b>" + Messages.get("label.name") + ":</b> " + SafeHtmlUtils.htmlEscape((String)name)));
                }
                if ((path = selectedNode.getPath()) != null) {
                    flowPanel.add((Widget)new HTML("<b>" + Messages.get("label.path") + ":</b> " + SafeHtmlUtils.htmlEscape((String)path)));
                }
                if ((id = selectedNode.getUUID()) != null) {
                    flowPanel.add((Widget)new HTML("<b>" + Messages.get("label.id", "ID") + ":</b> " + id));
                }
                if (selectedNode.isFile() != null && selectedNode.isFile().booleanValue() && (s = selectedNode.getSize()) != null) {
                    flowPanel.add((Widget)new HTML("<b>" + Messages.get("label.size") + ":</b> " + Formatter.getFormattedSize(s) + " (" + s.toString() + " bytes)"));
                }
                if ((date = (Date)selectedNode.get("jcr:lastModified")) != null) {
                    flowPanel.add((Widget)new HTML("<b>" + Messages.get("label.lastModif") + ":</b> " + Formatter.getFormattedDate(date, "d/MM/y")));
                }
                if (selectedNode.isLocked() != null && selectedNode.isLocked().booleanValue() && selectedNode.getLockInfos() != null) {
                    StringBuilder infos = new StringBuilder();
                    if (selectedNode.getLockInfos().containsKey(null) && selectedNode.getLockInfos().size() == 1) {
                        for (String s2 : selectedNode.getLockInfos().get(null)) {
                            infos.append(Formatter.getLockLabel(s2));
                        }
                    } else {
                        for (Map.Entry<String, List<String>> entry : selectedNode.getLockInfos().entrySet()) {
                            if (entry.getKey() == null) continue;
                            if (infos.length() > 0) {
                                infos.append("; ");
                            }
                            infos.append(entry.getKey()).append(" : ");
                            int i = 0;
                            for (String s3 : entry.getValue()) {
                                if (i > 0) {
                                    infos.append(", ");
                                }
                                infos.append(Formatter.getLockLabel(s3));
                                ++i;
                            }
                        }
                    }
                    flowPanel.add((Widget)new HTML("<b>" + Messages.get("info.lock.label") + ":</b> " + infos.toString()));
                }
                flowPanel.add((Widget)new HTML("<b>" + Messages.get("nodes.label", "Types") + ":</b> " + selectedNode.getNodeTypes()));
                flowPanel.add((Widget)new HTML("<b>" + Messages.get("org.jahia.jcr.edit.tags.tab", "Tags") + ":</b> " + (selectedNode.getTags() != null ? selectedNode.getTags() : "")));
            } else {
                int numberFiles = 0;
                int numberFolders = 0;
                long size = 0L;
                for (GWTJahiaNode selectedNode : engine.getNodes()) {
                    if (selectedNode.isFile().booleanValue()) {
                        ++numberFiles;
                        size += selectedNode.getSize().longValue();
                        continue;
                    }
                    ++numberFolders;
                }
                flowPanel.add((Widget)new HTML("<b>" + Messages.get("info.nbFiles.label") + " :</b> " + numberFiles));
                flowPanel.add((Widget)new HTML("<b>" + Messages.get("info.nbFolders.label") + " :</b> " + numberFolders));
                flowPanel.add((Widget)new HTML("<b>" + Messages.get("info.totalSize.label") + " :</b> " + Formatter.getFormattedSize(size)));
            }
            g.setWidget(0, 1, (Widget)flowPanel);
            this.infoPanel.add((Widget)g);
            tab.setProcessed(true);
        }
    }

    @Override
    public boolean isHandleMultipleSelection() {
        return true;
    }

    @Override
    public boolean isHandleCreate() {
        return false;
    }
}

