/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content.compare;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ToggleButton;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.dom.client.BodyElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.IFrameElement;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Frame;
import java.util.Date;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.content.compare.CompareEngine;
import org.jahia.ajax.gwt.client.widget.form.CalendarField;
import org.jahia.ajax.gwt.client.widget.toolbar.action.PublishActionItem;

public class VersionViewer
extends ContentPanel {
    private Linker linker = null;
    private String locale;
    private static JahiaContentManagementServiceAsync contentService = JahiaContentManagementService.App.getInstance();
    private final String uuid;
    private String workspace = "default";
    private Frame currentFrame;
    private CalendarField versionComboBox;
    private boolean addButtons;
    private Button restoreButton;
    private boolean displayHighLigthButton;
    private final CompareEngine compareEngine;
    private String versionLabel = null;
    private Date[] previousValue;
    private Date versionDate = null;

    public VersionViewer(GWTJahiaNode node, String locale, Linker linker, String workspace, boolean addButtons, boolean displayVersionSelector, CompareEngine compareEngine) {
        this.linker = linker;
        this.workspace = workspace;
        this.locale = locale;
        this.addButtons = addButtons;
        this.displayHighLigthButton = addButtons;
        this.compareEngine = compareEngine;
        this.uuid = node.getUUID();
        this.init(displayVersionSelector);
    }

    public VersionViewer(String uuid, String locale, String workspace, boolean displayHighLigthButton, boolean displayVersionSelector, Date versionDate, CompareEngine compareEngine, String versionLabel) {
        this.uuid = uuid;
        this.workspace = workspace;
        this.locale = locale;
        this.displayHighLigthButton = displayHighLigthButton;
        this.versionDate = versionDate;
        this.compareEngine = compareEngine;
        this.versionLabel = versionLabel;
        this.init(displayVersionSelector);
    }

    private void init(boolean displayVersionSelector) {
        Label[] label = new Label[]{null};
        label[0] = new Label(("live".equals(this.workspace) ? Messages.get("label.live.version", "Live version") : Messages.get("label.staging.version", "Staging version")) + " ");
        if (displayVersionSelector) {
            Date startDate = new Date();
            this.previousValue = new Date[]{startDate};
            this.versionComboBox = new CalendarField(startDate);
            this.versionComboBox.setWidth(150);
            this.versionComboBox.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

                public void handleEvent(FieldEvent be) {
                    if (!be.getField().getValue().equals(VersionViewer.this.previousValue[0])) {
                        ((VersionViewer)VersionViewer.this).previousValue[0] = (Date)be.getField().getValue();
                        VersionViewer.this.refresh();
                    }
                }
            });
        } else {
            this.previousValue = new Date[]{this.versionDate};
        }
        if (this.versionDate != null) {
            this.restoreButton = new Button(Messages.get("label.restore", "Restore"));
            this.restoreButton.addStyleName("button-restore");
            this.restoreButton.setEnabled(false);
            this.restoreButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    VersionViewer.this.mask(Messages.get("label.restoring", "Restoring") + "...", "x-mask-loading");
                    contentService.restoreNodeByIdentifierAndDate(VersionViewer.this.uuid, VersionViewer.this.versionDate, VersionViewer.this.versionLabel != null && !VersionViewer.this.versionLabel.contains("live") ? VersionViewer.this.versionLabel : null, false, (AsyncCallback<Void>)new BaseAsyncCallback<Void>(){

                        public void onSuccess(Void result) {
                            VersionViewer.this.unmask();
                            VersionViewer.this.compareEngine.setRefreshOpener(true);
                            if (VersionViewer.this.compareEngine.getRightPanel() != null) {
                                VersionViewer.this.compareEngine.getRightPanel().refresh();
                            }
                        }
                    });
                }
            });
        }
        Button refresh = new Button();
        refresh.setIcon(StandardIconsProvider.STANDARD_ICONS.refresh());
        refresh.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent componentEvent) {
                VersionViewer.this.refresh();
            }
        });
        final ToggleButton hButton = new ToggleButton(Messages.get("label.highlight", "Highligthing"));
        hButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent componentEvent) {
                if (hButton.isPressed()) {
                    VersionViewer.this.displayHighLigth();
                } else {
                    VersionViewer.this.refresh();
                }
            }
        });
        if (this.addButtons && !this.workspace.equals("live")) {
            ToolBar headerToolBar = new ToolBar();
            headerToolBar.add((Component)label[0]);
            if (displayVersionSelector) {
                headerToolBar.add((Component)this.versionComboBox);
            }
            headerToolBar.add((Component)refresh);
            headerToolBar.add((Component)hButton);
            if (displayVersionSelector) {
                headerToolBar.add((Component)this.restoreButton);
            }
            GWTJahiaToolbarItem gwtJahiaToolbarItem = new GWTJahiaToolbarItem();
            PublishActionItem actionItem = new PublishActionItem();
            gwtJahiaToolbarItem.setId("VersionViewer.Toolbar.Item.Publish");
            gwtJahiaToolbarItem.setActionItem(actionItem);
            gwtJahiaToolbarItem.setTitle(Messages.get("label.publish"));
            gwtJahiaToolbarItem.setLayout(2);
            gwtJahiaToolbarItem.setDisplayTitle(true);
            gwtJahiaToolbarItem.setIcon("publish");
            actionItem.init(gwtJahiaToolbarItem, this.linker);
            headerToolBar.add(actionItem.getTextToolItem());
            actionItem.handleNewLinkerSelection();
            gwtJahiaToolbarItem = new GWTJahiaToolbarItem();
            actionItem = new PublishActionItem();
            actionItem.setAllSubTree(true);
            gwtJahiaToolbarItem.setId("VersionViewer.Toolbar.Item.PublishAll");
            gwtJahiaToolbarItem.setActionItem(actionItem);
            gwtJahiaToolbarItem.setTitle(Messages.get("label.publishall"));
            gwtJahiaToolbarItem.setLayout(2);
            gwtJahiaToolbarItem.setDisplayTitle(true);
            gwtJahiaToolbarItem.setIcon("publishAll");
            actionItem.init(gwtJahiaToolbarItem, this.linker);
            headerToolBar.add(actionItem.getTextToolItem());
            actionItem.handleNewLinkerSelection();
            this.setTopComponent((Component)headerToolBar);
        } else {
            ToolBar headerToolBar = new ToolBar();
            headerToolBar.add((Component)label[0]);
            if (displayVersionSelector) {
                headerToolBar.add((Component)this.versionComboBox);
            }
            headerToolBar.add((Component)refresh);
            if (this.displayHighLigthButton) {
                headerToolBar.add((Component)hButton);
            }
            if (this.versionDate != null) {
                headerToolBar.add((Component)this.restoreButton);
            }
            this.setTopComponent((Component)headerToolBar);
        }
        this.load();
    }

    protected void refresh() {
        this.load();
    }

    private void load() {
        if (this.uuid != null) {
            this.mask(Messages.get("label.loading", "Loading"), "x-mask-loading");
            contentService.getNodeURLByIdentifier(null, this.uuid, this.previousValue[0], null, this.workspace, this.locale, (AsyncCallback<String>)new BaseAsyncCallback<String>(){

                public void onSuccess(String url) {
                    VersionViewer.this.currentFrame = VersionViewer.this.setUrl(url);
                    VersionViewer.this.setHeadingHtml(url);
                    VersionViewer.this.unmask();
                    if (VersionViewer.this.restoreButton != null) {
                        VersionViewer.this.restoreButton.setEnabled(true);
                    }
                }

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    Log.error((String)"", (Throwable)throwable);
                    VersionViewer.this.unmask();
                }
            });
        }
    }

    public String getInnerHTML() {
        IFrameElement frameElement = IFrameElement.as((Element)this.currentFrame.getElement());
        Document document = frameElement.getContentDocument();
        BodyElement ele = document.getBody();
        if (ele != null) {
            return ele.getInnerHTML();
        }
        return null;
    }

    public void displayHighLigth() {
        contentService.getHighlighted(this.getInnerHTML(), this.getCompareWith(), (AsyncCallback<String>)new BaseAsyncCallback<String>(){

            public void onSuccess(String s) {
                IFrameElement frameElement = IFrameElement.as((Element)VersionViewer.this.currentFrame.getElement());
                Document document = frameElement.getContentDocument();
                BodyElement ele = document.getBody();
                if (ele != null) {
                    ele.setInnerHTML(s);
                }
            }

            @Override
            public void onApplicationFailure(Throwable throwable) {
                Log.error((String)"Error when triing to display higthligthing", (Throwable)throwable);
            }
        });
    }

    public String getCompareWith() {
        return this.getInnerHTML();
    }
}

