/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.ContentTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.ManualListOrderingEditor;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;

public class ListOrderingContentTabItem
extends ContentTabItem {
    private transient CheckBox useManualRanking;
    private transient ManualListOrderingEditor manualListOrderingEditor = null;
    private static final String JMIX_ORDERED_LIST = "jmix:orderedList";

    public ListOrderingContentTabItem() {
        this.setHandleCreate(false);
    }

    @Override
    public void attachPropertiesEditor(NodeHolder engine, AsyncTabItem tab) {
        tab.setLayout((Layout)new RowLayout());
        tab.add((Widget)this.propertiesEditor);
        if (!engine.isMultipleSelection()) {
            this.attachManualListOrderingEditor(engine, tab, this.propertiesEditor);
        }
    }

    private void attachManualListOrderingEditor(NodeHolder engine, AsyncTabItem tab, final PropertiesEditor propertiesEditor) {
        this.manualListOrderingEditor = new ManualListOrderingEditor(engine.getNode());
        this.useManualRanking = new CheckBox();
        FieldSet fieldSet = new FieldSet();
        fieldSet.setCollapsible(true);
        fieldSet.setHeadingHtml(Messages.get("label.manualRanking", "Manual ranking"));
        this.useManualRanking.setBoxLabel(Messages.get("label.useManualRanking", "Use manual ranking"));
        this.useManualRanking.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent componentEvent) {
                if (ListOrderingContentTabItem.this.useManualRanking.getValue().booleanValue()) {
                    propertiesEditor.getRemovedTypes().add(ListOrderingContentTabItem.JMIX_ORDERED_LIST);
                    propertiesEditor.getAddedTypes().remove(ListOrderingContentTabItem.JMIX_ORDERED_LIST);
                } else {
                    propertiesEditor.getRemovedTypes().remove(ListOrderingContentTabItem.JMIX_ORDERED_LIST);
                    propertiesEditor.getAddedTypes().add(ListOrderingContentTabItem.JMIX_ORDERED_LIST);
                }
                for (FieldSet component : propertiesEditor.getOrderingListFieldSet()) {
                    if (ListOrderingContentTabItem.this.useManualRanking.getValue().booleanValue()) {
                        component.setData("addedField", null);
                        component.setEnabled(false);
                        component.collapse();
                        continue;
                    }
                    component.setData("addedField", (Object)"true");
                    component.setEnabled(true);
                    component.expand();
                }
                ListOrderingContentTabItem.this.manualListOrderingEditor.setEnabled(ListOrderingContentTabItem.this.useManualRanking.getValue());
                if (ListOrderingContentTabItem.this.useManualRanking.getValue().booleanValue()) {
                    ListOrderingContentTabItem.this.manualListOrderingEditor.expand();
                } else {
                    ListOrderingContentTabItem.this.manualListOrderingEditor.collapse();
                }
            }
        });
        boolean isManual = !propertiesEditor.getNodeTypes().contains(new GWTJahiaNodeType(JMIX_ORDERED_LIST));
        for (FieldSet component : propertiesEditor.getOrderingListFieldSet()) {
            component.setEnabled(!isManual);
            if (!isManual) continue;
            component.collapse();
        }
        this.useManualRanking.setValue(Boolean.valueOf(isManual));
        this.manualListOrderingEditor.setEnabled(isManual);
        if (!isManual) {
            this.manualListOrderingEditor.collapse();
        }
        fieldSet.add((Widget)this.useManualRanking);
        fieldSet.add((Widget)this.manualListOrderingEditor);
        tab.add((Widget)fieldSet);
    }

    @Override
    public void setProcessed(boolean processed) {
        if (!processed && this.langPropertiesEditorMap != null) {
            this.manualListOrderingEditor = null;
        }
        super.setProcessed(processed);
    }

    @Override
    public void doSave(GWTJahiaNode node, List<GWTJahiaNodeProperty> changedProperties, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, Set<String> addedTypes, Set<String> removedTypes, List<GWTJahiaNode> chidren, GWTJahiaNodeACL acl) {
        if (this.propertiesEditor != null) {
            if (this.manualListOrderingEditor != null && this.useManualRanking.getValue().booleanValue()) {
                for (GWTJahiaNode child : this.manualListOrderingEditor.getOrderedNodes()) {
                    node.add((ModelData)child);
                }
                for (GWTJahiaNode child : this.manualListOrderingEditor.getRemovedNodes()) {
                    node.add((ModelData)child);
                    node.remove((ModelData)child);
                }
                node.set("includeChildren", Boolean.TRUE);
            }
            addedTypes.addAll(this.propertiesEditor.getAddedTypes());
            addedTypes.addAll(this.propertiesEditor.getExternalMixin());
            changedProperties.addAll(this.propertiesEditor.getProperties(false, true, node != null));
            removedTypes.addAll(this.propertiesEditor.getRemovedTypes());
        }
    }

    @Override
    public boolean isOrderableTab() {
        return true;
    }
}

