/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.definition.FormFieldCreator;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.content.ContentPickerField;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineValidation;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;

public class PropertiesTabItem
extends EditEngineTabItem {
    protected List<String> dataType;
    protected List<String> excludedTypes;
    protected transient String language;
    protected transient PropertiesEditor propertiesEditor;
    protected transient Map<String, PropertiesEditor> langPropertiesEditorMap;
    protected transient Map<String, Map<String, GWTJahiaNodeProperty>> changedProperties;
    protected boolean multiLang = true;
    protected boolean viewCopyToAllLangs = true;

    @Override
    public AsyncTabItem create(GWTEngineTab engineTab, NodeHolder engine) {
        AsyncTabItem tab = super.create(engineTab, engine);
        this.langPropertiesEditorMap = new HashMap<String, PropertiesEditor>();
        this.changedProperties = new HashMap<String, Map<String, GWTJahiaNodeProperty>>();
        tab.setLayout((Layout)new FitLayout());
        tab.setScrollMode(Style.Scroll.AUTO);
        return tab;
    }

    public PropertiesEditor getPropertiesEditor() {
        return this.propertiesEditor;
    }

    public Map<String, PropertiesEditor> getLangPropertiesEditorMap() {
        return this.langPropertiesEditorMap;
    }

    public PropertiesEditor getPropertiesEditorByLang(String language) {
        if (language == null) {
            Log.error((String)"Locale is null");
            return null;
        }
        return this.langPropertiesEditorMap.get(language);
    }

    private void setPropertiesEditorByLang(String language) {
        if (this.langPropertiesEditorMap == null || language == null) {
            return;
        }
        this.langPropertiesEditorMap.put(language, this.propertiesEditor);
    }

    @Override
    public void init(final NodeHolder engine, AsyncTabItem tab, String language) {
        if (!this.isMultiLang() && tab.isProcessed()) {
            return;
        }
        tab.mask(Messages.get("label.loading", "Loading..."), "x-mask-loading");
        if (engine.getMixin() != null) {
            tab.unmask();
            boolean addSharedLangLabel = true;
            List<GWTJahiaNodeProperty> previousNon18nProperties = null;
            this.language = language;
            Set<String> previousAddedTypes = null;
            Set<String> previousRemovedTypes = null;
            if (this.propertiesEditor != null) {
                if (this.propertiesEditor == this.getPropertiesEditorByLang(language)) {
                    return;
                }
                addSharedLangLabel = false;
                this.propertiesEditor.setVisible(false);
                previousNon18nProperties = this.propertiesEditor.getProperties(false, true, false);
                previousAddedTypes = this.propertiesEditor.getAddedTypes();
                previousRemovedTypes = this.propertiesEditor.getRemovedTypes();
            }
            if (!this.isMultiLang()) {
                this.setProcessed(true);
            }
            this.propertiesEditor = this.getPropertiesEditorByLang(language);
            if (this.propertiesEditor == null) {
                if (engine.isExistingNode() && engine.getNode().isShared() && addSharedLangLabel) {
                    Label label = new Label(Messages.get("warning.sharedNode", "Important : This is a shared node, editing it will modify its value for all its usages"));
                    label.setStyleAttribute("color", "rgb(200,80,80)");
                    label.setStyleAttribute("font-size", "14px");
                    tab.add((Widget)label);
                }
                Map<String, GWTJahiaNodeProperty> properties = engine.getProperties();
                if (this.changedProperties.containsKey(language)) {
                    properties.putAll(this.changedProperties.get(language));
                }
                if (engine.getPresetProperties() != null && !engine.getPresetProperties().isEmpty()) {
                    properties.putAll(engine.getPresetProperties());
                }
                this.propertiesEditor = new PropertiesEditor(engine.getNodeTypes(), properties, this.dataType, engine){

                    @Override
                    public void copyToAllLanguages(GWTJahiaNodeProperty prop, Field<?> remoteField) {
                        for (GWTJahiaLanguage jahiaLanguage : JahiaGWTParameters.getSiteLanguages()) {
                            String l = jahiaLanguage.getLanguage();
                            if (l.equals(PropertiesTabItem.this.language)) continue;
                            PropertiesEditor langPropEditor = PropertiesTabItem.this.langPropertiesEditorMap.get(l);
                            if (PropertiesTabItem.this.langPropertiesEditorMap.containsKey(l)) {
                                if (langPropEditor.getFieldsMap().get(prop.getName()) == null) {
                                    PropertiesEditor.PropertyAdapterField remote = (PropertiesEditor.PropertyAdapterField)remoteField;
                                    PropertiesEditor.PropertyAdapterField field = langPropEditor.getFieldsMap().get(remote.getDefinition().getName());
                                    field.getField().setValue(remote.getField().getValue());
                                    langPropEditor.setExternalMixin(field);
                                }
                                Field<?> f = langPropEditor.getFieldsMap().get(prop.getName()).getField();
                                FormFieldCreator.copyValue(prop, f);
                                continue;
                            }
                            if (!PropertiesTabItem.this.changedProperties.containsKey(l)) {
                                PropertiesTabItem.this.changedProperties.put(l, new HashMap());
                            }
                            PropertiesTabItem.this.changedProperties.get(l).put(prop.getName(), prop.cloneObject());
                        }
                    }
                };
                this.propertiesEditor.setLocale(language);
                this.propertiesEditor.setMixin(engine.getMixin());
                this.propertiesEditor.setChoiceListInitializersValues(engine.getChoiceListInitializersValues());
                this.propertiesEditor.setDefaultValues(engine.getDefaultValues().get(language));
                this.propertiesEditor.setWriteable(!engine.isExistingNode() || PermissionsUtils.isPermitted("jcr:modifyProperties", engine.getNode()) && engine.getNode().isLocked() == false);
                this.propertiesEditor.setFieldSetGrouping(true);
                this.propertiesEditor.setExcludedTypes(this.excludedTypes);
                this.propertiesEditor.setViewCopyToAllLangs(this.viewCopyToAllLangs);
                this.propertiesEditor.setMultipleEdit(engine.isMultipleSelection());
                this.propertiesEditor.setDisplayHiddenProperties(engine.getLinker().isDisplayHiddenProperties());
                this.propertiesEditor.addStyleName("JahiaGxtEditEnginePanel-" + this.gwtEngineTab.getId() + "-" + language);
                if (engine.getNode() != null) {
                    this.propertiesEditor.setPermissions(engine.getNode().getPermissions());
                } else if (engine.getTargetNode() != null) {
                    this.propertiesEditor.setPermissions(engine.getTargetNode().getPermissions());
                }
                this.propertiesEditor.renderNewFormPanel();
                for (final Field field : this.propertiesEditor.getFields()) {
                    if (!(field instanceof ContentPickerField)) continue;
                    final String labelSep = field.getLabelSeparator();
                    if (engine.getReferencesWarnings() != null && engine.getReferencesWarnings().containsKey(field.getName())) {
                        field.setLabelSeparator(labelSep + " <img width='11px' height='11px' src='" + JahiaGWTParameters.getContextPath() + "/gwt/resources/images/default/shared/warning.gif'/> Warning : these users/groups might not view the reference " + engine.getReferencesWarnings().get(field.getName()));
                        field.setFieldLabel(field.getFieldLabel());
                    }
                    field.setFireChangeEventOnSetValue(true);
                    field.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

                        public void handleEvent(FieldEvent be) {
                            List selectedNodes = (List)be.getValue();
                            if (selectedNodes != null && !selectedNodes.isEmpty()) {
                                JahiaContentManagementService.App.getInstance().compareAcl(engine.getAcl(), selectedNodes, (AsyncCallback<Set<String>>)new BaseAsyncCallback<Set<String>>(){

                                    public void onSuccess(Set<String> result) {
                                        if (!result.isEmpty()) {
                                            field.setLabelSeparator(labelSep != null ? labelSep : " <img width='11px' height='11px' src='" + JahiaGWTParameters.getContextPath() + "/gwt/resources/images/default/shared/warning.gif'/> Warning : these users/groups might not view the reference " + result);
                                            field.setFieldLabel(field.getFieldLabel());
                                        } else {
                                            if (labelSep != null) {
                                                field.setLabelSeparator(labelSep);
                                            }
                                            field.setFieldLabel(field.getFieldLabel());
                                        }
                                    }
                                });
                            } else {
                                if (labelSep != null) {
                                    field.setLabelSeparator(labelSep);
                                }
                                field.setFieldLabel(field.getFieldLabel());
                            }
                        }
                    });
                }
                this.setPropertiesEditorByLang(language);
                if (engine.getPresetProperties() != null && !engine.getPresetProperties().isEmpty()) {
                    for (String k : engine.getPresetProperties().keySet()) {
                        if (!this.propertiesEditor.getFieldsMap().containsKey(k)) continue;
                        this.propertiesEditor.getFieldsMap().get(k).setDirty(true);
                    }
                }
                this.attachPropertiesEditor(engine, tab);
                if (this.propertiesEditor.getFieldsMap().containsKey("jcr:title")) {
                    Iterator<Object> title = (Field)this.propertiesEditor.getFieldsMap().get("jcr:title");
                    title.focus();
                }
            }
            if (previousNon18nProperties != null && !previousNon18nProperties.isEmpty()) {
                Map<String, PropertiesEditor.PropertyAdapterField> fieldsMap = this.propertiesEditor.getFieldsMap();
                for (GWTJahiaNodeProperty property : previousNon18nProperties) {
                    if (!fieldsMap.containsKey(property.getName())) continue;
                    FormFieldCreator.fillValue(fieldsMap.get(property.getName()).getField(), this.propertiesEditor.getGWTJahiaItemDefinition(property), property, null, null);
                }
            }
            if (previousAddedTypes != null) {
                Map<String, FieldSet> f = this.propertiesEditor.getFieldSetsMap();
                this.propertiesEditor.getAddedTypes().addAll(previousAddedTypes);
                this.propertiesEditor.getRemovedTypes().addAll(previousRemovedTypes);
                for (String addedType : previousAddedTypes) {
                    f.get(addedType).expand();
                }
                for (String removedType : previousRemovedTypes) {
                    if (!f.containsKey(removedType)) continue;
                    f.get(removedType).collapse();
                }
            }
            if (this.changedProperties.containsKey(language)) {
                for (Map.Entry<String, GWTJahiaNodeProperty> entry : this.changedProperties.get(language).entrySet()) {
                    if (!this.propertiesEditor.getFieldsMap().containsKey(entry.getKey())) continue;
                    this.propertiesEditor.getFieldsMap().get(entry.getKey()).setDirty(true);
                }
                this.changedProperties.get(language).clear();
            }
            this.propertiesEditor.setVisible(true);
            tab.layout();
        }
    }

    public void focusFirstField() {
        if (this.propertiesEditor != null && this.propertiesEditor.getFields() != null) {
            for (Field f : this.propertiesEditor.getFields()) {
                TextField textField;
                if (!(f instanceof PropertiesEditor.PropertyAdapterField) || !f.isEnabled() || !f.isVisible()) continue;
                Field<?> field = ((PropertiesEditor.PropertyAdapterField)f).getField();
                field.focus();
                if (!(field instanceof TextField)) break;
                textField.setCursorPos((textField = (TextField)field).getValue() != null ? textField.getValue().toString().length() : 0);
                break;
            }
        }
    }

    public void attachPropertiesEditor(NodeHolder engine, AsyncTabItem tab) {
        tab.add((Widget)this.propertiesEditor);
        tab.layout();
    }

    public boolean isMultiLang() {
        return this.multiLang;
    }

    public void setMultiLang(boolean multiLang) {
        this.multiLang = multiLang;
    }

    public void setViewCopyToAllLangs(boolean viewCopyToAllLangs) {
        this.viewCopyToAllLangs = viewCopyToAllLangs;
    }

    public List<GWTJahiaNodeProperty> getLanguageProperties(boolean modifiedOnly, String language) {
        if (this.langPropertiesEditorMap.containsKey(language)) {
            return this.langPropertiesEditorMap.get(language).getProperties(true, false, modifiedOnly);
        }
        if (this.changedProperties.containsKey(language)) {
            return new ArrayList<GWTJahiaNodeProperty>(this.changedProperties.get(language).values());
        }
        return new ArrayList<GWTJahiaNodeProperty>();
    }

    @Override
    public void setProcessed(boolean processed) {
        if (!processed) {
            if (this.langPropertiesEditorMap != null) {
                this.langPropertiesEditorMap.clear();
            }
            if (this.changedProperties != null) {
                this.changedProperties.clear();
            }
            this.propertiesEditor = null;
        }
        super.setProcessed(processed);
    }

    @Override
    public boolean isHandleMultipleSelection() {
        return true;
    }

    public void setDataType(List<String> dataType) {
        this.dataType = dataType;
    }

    public void setExcludedTypes(List<String> excludedTypes) {
        this.excludedTypes = excludedTypes;
    }

    @Override
    public void doValidate(List<EngineValidation.ValidateResult> validateResult, NodeHolder engine, TabItem tab, String selectedLanguage, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, TabPanel tabs) {
        PropertiesEditor pe = this.getPropertiesEditor();
        if (pe != null) {
            for (PropertiesEditor.PropertyAdapterField adapterField : pe.getFieldsMap().values()) {
                Field<?> field = adapterField.getField();
                if (!field.isEnabled() || field.isReadOnly() || field.validate() || adapterField.getParent() == null || !((FieldSet)adapterField.getParent()).isExpanded()) continue;
                EngineValidation.ValidateResult result = new EngineValidation.ValidateResult();
                result.errorTab = tab;
                result.errorField = field;
                result.canIgnore = field.getData("optionalValidation") != null && (Boolean)field.getData("optionalValidation") != false;
                validateResult.add(result);
                break;
            }
        }
        if (this.isMultiLang() && selectedLanguage != null) {
            String lang = selectedLanguage;
            for (String language : changedI18NProperties.keySet()) {
                PropertiesEditor lpe;
                if (lang.equals(language) || (lpe = this.getPropertiesEditorByLang(language)) == null) continue;
                for (PropertiesEditor.PropertyAdapterField adapterField : lpe.getFieldsMap().values()) {
                    Field<?> field = adapterField.getField();
                    if (!field.isEnabled() || field.isReadOnly() || field.validate() || !((FieldSet)adapterField.getParent()).isExpanded() || !adapterField.getDefinition().isInternationalized()) continue;
                    EngineValidation.ValidateResult result = new EngineValidation.ValidateResult();
                    result.errorTab = tab;
                    result.errorField = field;
                    result.canIgnore = false;
                    result.errorLang = language;
                    validateResult.add(result);
                }
            }
        }
    }

    @Override
    public void doSave(GWTJahiaNode node, List<GWTJahiaNodeProperty> changedProperties, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, Set<String> addedTypes, Set<String> removedTypes, List<GWTJahiaNode> chidren, GWTJahiaNodeACL acl) {
        PropertiesTabItem propertiesTabItem = this;
        PropertiesEditor pe = propertiesTabItem.getPropertiesEditor();
        if (pe != null) {
            addedTypes.addAll(pe.getAddedTypes());
            addedTypes.addAll(pe.getExternalMixin());
        }
        if (this.isMultiLang()) {
            HashSet<String> set = new HashSet<String>(this.langPropertiesEditorMap.keySet());
            set.addAll(this.changedProperties.keySet());
            for (String lang : set) {
                if (!changedI18NProperties.containsKey(lang)) {
                    changedI18NProperties.put(lang, new ArrayList());
                }
                changedI18NProperties.get(lang).addAll(this.getLanguageProperties(node != null, lang));
            }
            if (this.propertiesEditor != null) {
                changedProperties.addAll(this.propertiesEditor.getProperties(false, true, node != null));
            }
        } else if (this.propertiesEditor != null) {
            changedProperties.addAll(this.propertiesEditor.getProperties(true, true, node != null));
        }
        if (pe != null) {
            removedTypes.addAll(pe.getRemovedTypes());
        }
    }
}

