/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.form.StoreFilterField;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.extjs.gxt.ui.client.widget.treegrid.WidgetTreeGridCellRenderer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.toolbar.GWTColumn;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.Collator;
import org.jahia.ajax.gwt.client.util.icons.ContentModelIconProvider;

public class ContentTypeTree
extends LayoutContainer {
    private static final StoreSorter<GWTJahiaNodeType> SORTER = new StoreSorter<GWTJahiaNodeType>((Comparator)new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return Collator.getInstance().localeCompare(s1, s2);
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return 0;
        }
    }){

        public int compare(Store<GWTJahiaNodeType> store, GWTJahiaNodeType n1, GWTJahiaNodeType n2, String property) {
            return super.compare(store, (ModelData)n1, (ModelData)n2, "label");
        }
    };
    private TreeGrid<GWTJahiaNodeType> treeGrid;
    private StoreFilterField<GWTJahiaNodeType> nameFilterField;
    private TreeStore<GWTJahiaNodeType> store;
    private boolean moduleFiltering;

    public ContentTypeTree() {
        this(Arrays.asList(new GWTColumn("label", Messages.get("label.name", "Name"), -1)));
    }

    public ContentTypeTree(List<GWTColumn> columns) {
        this.setBorders(false);
        String autoExpand = null;
        ArrayList<ColumnConfig> columnList = new ArrayList<ColumnConfig>();
        ArrayList pluginList = new ArrayList();
        this.moduleFiltering = false;
        for (GWTColumn column : columns) {
            int i = column.getSize();
            if (i == -1) {
                autoExpand = column.getKey();
                i = 400;
            }
            if (!column.getKey().equals("label")) continue;
            ColumnConfig name = new ColumnConfig(column.getKey(), column.getTitle(), i);
            name.setRenderer((GridCellRenderer)new WidgetTreeGridCellRenderer<GWTJahiaNodeType>(){

                public Widget getWidget(GWTJahiaNodeType modelData, String s, ColumnData columnData, int i, int i1, ListStore<GWTJahiaNodeType> listStore, Grid<GWTJahiaNodeType> grid) {
                    TableData tableData;
                    HorizontalPanel panel = new HorizontalPanel();
                    panel.setTableWidth("100%");
                    Label label = new Label(modelData.getLabel());
                    label.setStyleName("gwt-content-label");
                    String descr = modelData.getDescription();
                    if (modelData != null) {
                        tableData = new TableData(Style.HorizontalAlignment.RIGHT, Style.VerticalAlignment.MIDDLE);
                        tableData.setWidth("5%");
                        panel.add((Widget)ContentModelIconProvider.getInstance().getIcon(modelData).createImage());
                        tableData = new TableData(Style.HorizontalAlignment.LEFT, Style.VerticalAlignment.MIDDLE);
                        tableData.setWidth("95%");
                        if (!(descr != null && descr.length() != 0 || "".equals(modelData.getDescription()))) {
                            descr = modelData.getDescription();
                        }
                    } else {
                        tableData = new TableData(Style.HorizontalAlignment.LEFT, Style.VerticalAlignment.MIDDLE);
                        tableData.setWidth("100%");
                    }
                    if (descr != null && descr.length() > 0) {
                        panel.setToolTip(descr);
                    }
                    panel.add((Widget)label, (LayoutData)tableData);
                    panel.layout();
                    return panel;
                }
            });
            columnList.add(name);
        }
        this.store = new TreeStore();
        this.store.setStoreSorter(SORTER);
        this.treeGrid = new TreeGrid<GWTJahiaNodeType>(this.store, new ColumnModel(columnList)){

            public void setExpanded(GWTJahiaNodeType model, boolean expand, boolean deep) {
                if (expand && model != null && model.get("cannotexpand") != null) {
                    return;
                }
                super.setExpanded((ModelData)model, expand, deep);
            }
        };
        this.treeGrid.setBorders(true);
        if (autoExpand != null) {
            this.treeGrid.setAutoExpandColumn(autoExpand);
        }
        this.treeGrid.getTreeView().setRowHeight(25);
        this.treeGrid.getTreeView().setForceFit(true);
        this.treeGrid.getTreeView().setBufferEnabled(true);
        this.treeGrid.getTreeView().setCacheSize(128);
        this.treeGrid.getTreeView().setScrollDelay(5);
        this.treeGrid.getStyle().setNodeCloseIcon(null);
        this.treeGrid.getStyle().setNodeOpenIcon(null);
        for (ComponentPlugin plugin : pluginList) {
            this.treeGrid.addPlugin(plugin);
        }
        BorderLayout layout = new BorderLayout();
        this.setLayout((Layout)layout);
        this.setBorders(false);
        this.nameFilterField = new StoreFilterField<GWTJahiaNodeType>(){

            protected boolean doSelect(Store<GWTJahiaNodeType> store, GWTJahiaNodeType parent, GWTJahiaNodeType record, String property, String filter) {
                String s = filter.toLowerCase();
                return record.getName().toLowerCase().contains(s) || record.getLabel().toLowerCase().contains(s);
            }
        };
        this.nameFilterField.bind(this.store);
        this.nameFilterField.setHeight(18);
        this.add((Widget)this.nameFilterField, (LayoutData)new BorderLayoutData(Style.LayoutRegion.NORTH, 22.0f));
        this.add((Widget)this.treeGrid, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
        this.setScrollMode(Style.Scroll.AUTOY);
    }

    public void fillStore(List<GWTJahiaNodeType> nodes) {
        for (GWTJahiaNodeType node : nodes) {
            this.store.add((ModelData)node, true);
        }
    }

    public void fillStore(List<String> types, List<String> excludedTypes, boolean includeSubTypes) {
        this.store.removeAll();
        JahiaContentManagementService.App.getInstance().getContentTypesAsTree(types, excludedTypes, includeSubTypes, (AsyncCallback<List<GWTJahiaNodeType>>)new BaseAsyncCallback<List<GWTJahiaNodeType>>(){

            public void onSuccess(List<GWTJahiaNodeType> result) {
                ContentTypeTree.this.fillStore(result);
            }
        });
    }

    public TreeGrid<GWTJahiaNodeType> getTreeGrid() {
        return this.treeGrid;
    }

    public StoreFilterField<GWTJahiaNodeType> getNameFilterField() {
        return this.nameFilterField;
    }
}

