/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.mainarea;

import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jahia.ajax.gwt.client.util.WindowUtil;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.AreaModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ListModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;

public class Selection
extends LayoutContainer {
    private MainModule mainModule;
    Module module;
    BoxComponent top;
    BoxComponent bottom;
    BoxComponent left;
    BoxComponent right;
    LayoutContainer currentContainer;
    private boolean hidden = true;

    public Selection(Module m) {
        this.setBorders(true);
        this.top = new LayoutContainer();
        this.bottom = new LayoutContainer();
        this.left = new LayoutContainer();
        this.right = new LayoutContainer();
        this.module = m;
        this.mainModule = m != null ? m.getMainModule() : null;
    }

    public void configure() {
        this.currentContainer = this.module.getContainer();
        if (this.module instanceof ListModule) {
            this.top.setStyleName("selection-top-list");
            this.bottom.setStyleName("selection-bottom-list");
            this.left.setStyleName("selection-left-list");
            this.right.setStyleName("selection-right-list");
        } else if (this.module instanceof AreaModule) {
            this.top.setStyleName("selection-top-area");
            this.bottom.setStyleName("selection-bottom-area");
            this.left.setStyleName("selection-left-area");
            this.right.setStyleName("selection-right-area");
        } else {
            this.top.setStyleName("selection-top-simple");
            this.bottom.setStyleName("selection-bottom-simple");
            this.left.setStyleName("selection-left-simple");
            this.right.setStyleName("selection-right-simple");
        }
        this.top.setStyleAttribute("z-index", "995");
        this.bottom.setStyleAttribute("z-index", "995");
        this.left.setStyleAttribute("z-index", "995");
        this.right.setStyleAttribute("z-index", "995");
    }

    public void select() {
        this.configure();
        this.show();
    }

    public void setPosition(int x, int y, int w, int h) {
        this.top.setPosition(x, y);
        this.top.setSize(w, 0);
        this.bottom.setPosition(x, y + h);
        this.bottom.setSize(w, 0);
        this.left.setPosition(x, y);
        this.left.setSize(0, h);
        this.right.setPosition(x + w, y);
        this.right.setSize(0, h);
    }

    public void show() {
        if (!this.hidden) {
            return;
        }
        this.hidden = false;
        RootPanel.get().add((Widget)this.top);
        this.mainModule.getInnerElement().appendChild((Node)this.top.getElement());
        this.top.el().makePositionable(true);
        RootPanel.get().add((Widget)this.left);
        this.mainModule.getInnerElement().appendChild((Node)this.left.getElement());
        this.left.el().makePositionable(true);
        RootPanel.get().add((Widget)this.right);
        this.mainModule.getInnerElement().appendChild((Node)this.right.getElement());
        this.right.el().makePositionable(true);
        RootPanel.get().add((Widget)this.bottom);
        this.mainModule.getInnerElement().appendChild((Node)this.bottom.getElement());
        this.bottom.el().makePositionable(true);
        this.onShow();
        if (this.currentContainer != null) {
            Element element = this.currentContainer.getElement();
            this.setPosition(WindowUtil.getAbsoluteLeft(element), WindowUtil.getAbsoluteTop(element), this.currentContainer.getWidth(), this.currentContainer.getHeight());
        }
    }

    public void hide() {
        if (this.hidden) {
            return;
        }
        this.hidden = true;
        this.onHide();
        RootPanel.get().remove((Widget)this.top);
        RootPanel.get().remove((Widget)this.bottom);
        RootPanel.get().remove((Widget)this.left);
        RootPanel.get().remove((Widget)this.right);
    }
}

