/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.ModelIconProvider;
import com.extjs.gxt.ui.client.dnd.DND;
import com.extjs.gxt.ui.client.dnd.TreeGridDropTarget;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.DNDEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.selection.AbstractStoreSelectionModel;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTColumn;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.util.icons.ContentModelIconProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.NodeColumnConfigList;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.EditModeTreeGridDragSource;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Selection;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SelectMainNodeTreeLoadListener;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.TreeGridClickSelectionModel;
import org.jahia.ajax.gwt.client.widget.node.GWTJahiaNodeTreeFactory;

public class PagesTabItem
extends SidePanelTabItem {
    protected List<String> folderTypes = new ArrayList<String>();
    private List<String> paths = new ArrayList<String>();
    protected transient TreeGrid<GWTJahiaNode> pageTree;
    protected transient GWTJahiaNodeTreeFactory pageFactory;
    protected transient String path;
    protected transient SelectMainNodeTreeLoadListener selectMainNodeTreeLoadListener;

    @Override
    public TabItem create(GWTSidePanelTab config) {
        super.create(config);
        this.tab.setLayout((Layout)new FitLayout());
        this.tab.setId("JahiaGxtPagesTab");
        return this.tab;
    }

    private void initPageTree() {
        GWTJahiaNodeTreeFactory factory = new GWTJahiaNodeTreeFactory(this.paths);
        factory.setNodeTypes(this.folderTypes);
        for (GWTColumn c : this.config.getTreeColumns()) {
            c.setSortable(false);
        }
        ArrayList<String> fields = new ArrayList<String>(this.config.getTreeColumnKeys());
        if (!fields.contains("quickPublicationInfo") && !fields.contains("publicationInfo")) {
            fields.add("quickPublicationInfo");
        }
        factory.setFields(fields);
        this.pageFactory = factory;
        this.pageFactory.setSelectedPath(this.path);
        NodeColumnConfigList columns = new NodeColumnConfigList(this.config.getTreeColumns());
        columns.init();
        ((ColumnConfig)columns.get(0)).setRenderer(NodeColumnConfigList.NAME_TREEGRID_RENDERER);
        this.pageTree = factory.getTreeGrid(new ColumnModel((List)columns));
        this.pageTree.setAutoExpandColumn(columns.getAutoExpand());
        this.pageTree.getTreeView().setRowHeight(25);
        this.pageTree.getTreeView().setForceFit(true);
        this.pageTree.setHeight("100%");
        this.pageTree.setIconProvider((ModelIconProvider)ContentModelIconProvider.getInstance());
        this.pageTree.getTreeStore().setStoreSorter((StoreSorter)new StoreSorter<GWTJahiaNode>(){

            public int compare(Store<GWTJahiaNode> gwtJahiaNodeStore, GWTJahiaNode m1, GWTJahiaNode m2, String property) {
                if (!m1.getInheritedNodeTypes().contains("jmix:navMenuItem") && m2.getInheritedNodeTypes().contains("jmix:navMenuItem")) {
                    return 1;
                }
                if (!m2.getInheritedNodeTypes().contains("jmix:navMenuItem") && m1.getInheritedNodeTypes().contains("jmix:navMenuItem")) {
                    return -1;
                }
                return gwtJahiaNodeStore.getModels().indexOf(m2) - gwtJahiaNodeStore.getModels().indexOf(m1);
            }
        });
        final TreeGridClickSelectionModel selectionModel = new TreeGridClickSelectionModel();
        this.pageTree.setSelectionModel((GridSelectionModel)selectionModel);
        this.pageTree.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> se) {
                GWTJahiaNode node = (GWTJahiaNode)se.getSelectedItem();
                if (!(node == null || node.getPath().equals(PagesTabItem.this.editLinker.getMainModule().getPath()) || node.getNodeTypes().contains("jnt:virtualsite") || node.getNodeTypes().contains("jnt:navMenuText") || node.getInheritedNodeTypes().contains("jmix:link"))) {
                    MainModule.staticGoTo(node.getPath(), null);
                }
            }
        });
        this.pageTree.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        Menu contextMenu = this.createContextMenu(this.config.getTreeContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)selectionModel);
        contextMenu.addListener(Events.Show, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                Element row = PagesTabItem.this.pageTree.getView().getRow(selectionModel.getRightClickSelectionModel().getSelectedItem());
                if (row != null) {
                    row.addClassName("context-menu-open");
                }
            }
        });
        contextMenu.addListener(Events.Hide, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                Element row = PagesTabItem.this.pageTree.getView().getRow(selectionModel.getRightClickSelectionModel().getSelectedItem());
                if (row != null) {
                    row.removeClassName("context-menu-open");
                }
            }
        });
        this.pageTree.setContextMenu(contextMenu);
        this.selectMainNodeTreeLoadListener = new SelectMainNodeTreeLoadListener(this.pageTree);
        this.tab.add(this.pageTree);
    }

    @Override
    public void handleNewMainSelection(String path) {
        this.selectMainNodeTreeLoadListener.handleNewMainSelection(path);
        this.editLinker.getSelectionContext().setSelectedNodes(Arrays.asList(MainModule.getInstance().getNode()));
        this.editLinker.getSelectionContext().refresh(1);
        super.handleNewMainSelection(path);
    }

    private void initDND() {
        PageTreeGridDragSource source = new PageTreeGridDragSource();
        PageTreeGridDropTarget target = new PageTreeGridDropTarget();
        target.setAllowDropOnLeaf(true);
        target.setAllowSelfAsSource(true);
        target.setAutoExpand(true);
        target.setFeedback(DND.Feedback.BOTH);
        source.addDNDListener(this.editLinker.getDndListener());
        target.addDNDListener(this.editLinker.getDndListener());
    }

    @Override
    public void initWithLinker(EditLinker linker) {
        super.initWithLinker(linker);
        this.path = linker.getMainModule().getPath();
        this.initPageTree();
        if (linker.getConfig().isDragAndDropEnabled()) {
            this.initDND();
        }
    }

    @Override
    public boolean needRefresh(Map<String, Object> data) {
        if (data.containsKey("node")) {
            GWTJahiaNode node = (GWTJahiaNode)data.get("node");
            for (String type : this.folderTypes) {
                if (!node.getNodeTypes().contains(type) && !node.getInheritedNodeTypes().contains(type)) continue;
                return true;
            }
        }
        return data.containsKey("event") && ("languageChanged".equals(data.get("event")) || "workflowStarted".equals(data.get("event")) || "workflowExecuted".equals(data.get("event")) || "publicationSuccess".equals(data.get("event")) || "unpublicationSuccess".equals(data.get("event")));
    }

    @Override
    public void doRefresh() {
        List<String> selectedPath = this.pageFactory.getSelectedPath();
        this.pageFactory.getStore().removeAll();
        this.pageFactory.setSelectedPath(selectedPath);
        this.pageFactory.getLoader().load();
    }

    public void addOpenPath(String path) {
        this.pageFactory.setOpenPath(path);
    }

    public List<String> getFolderTypes() {
        return this.folderTypes;
    }

    public void setFolderTypes(List<String> folderTypes) {
        this.folderTypes = folderTypes;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    private class PageTreeGridDragSource
    extends EditModeTreeGridDragSource {
        public PageTreeGridDragSource() {
            super(PagesTabItem.this.pageTree);
        }

        protected void onDragStart(DNDEvent e) {
            super.onDragStart(e);
            for (Selection s : PagesTabItem.this.editLinker.getMainModule().getSelections().values()) {
                s.hide();
            }
            PagesTabItem.this.editLinker.getMainModule().getSelections().clear();
            ArrayList<GWTJahiaNode> l = new ArrayList<GWTJahiaNode>();
            GWTJahiaNode node = (GWTJahiaNode)PagesTabItem.this.pageTree.getSelectionModel().getSelectedItem();
            if (node.getInheritedNodeTypes().contains("jmix:navMenuItem") && PermissionsUtils.isPermitted("jcr:removeNode", node) && !node.isLocked().booleanValue()) {
                l.add(node);
                e.getStatus().setData("sourceType", (Object)"pageTree");
                e.getStatus().setData("sourceNodes", l);
            } else {
                e.getStatus().setData("sourceType", null);
                e.getStatus().setStatus(false);
                e.setCancelled(true);
            }
        }

        protected void onDragDrop(DNDEvent event) {
        }
    }

    public class PageTreeGridDropTarget
    extends TreeGridDropTarget {
        public PageTreeGridDropTarget() {
            super(PagesTabItem.this.pageTree);
        }

        protected void showFeedback(DNDEvent e) {
            super.showFeedback(e);
            List nodes = (List)e.getStatus().getData("sourceNodes");
            e.getStatus().setData("type", (Object)this.status);
            boolean isAllowed = false;
            for (String f : PagesTabItem.this.folderTypes) {
                isAllowed |= ((GWTJahiaNode)nodes.get(0)).getInheritedNodeTypes().contains(f);
            }
            if (this.activeItem != null && isAllowed) {
                GWTJahiaNode activeNode = (GWTJahiaNode)this.activeItem.getModel();
                boolean bl = isAllowed = PermissionsUtils.isPermitted("editModeAccess", JahiaGWTParameters.getSiteNode()) && PermissionsUtils.isPermitted("jcr:write_default", activeNode) && activeNode.isLocked() == false;
                if (isAllowed) {
                    GWTJahiaNode parent = (GWTJahiaNode)PagesTabItem.this.pageTree.getTreeStore().getParent((ModelData)activeNode);
                    e.getStatus().setData("targetNode", (Object)activeNode);
                    e.getStatus().setData("targetParent", (Object)parent);
                    e.getStatus().setData("targetPath", activeNode.get("path"));
                    if (this.status == 1 && this.activeItem.isExpanded() && this.activeItem.getItemCount() > 0) {
                        List children = PagesTabItem.this.pageTree.getTreeStore().getChildren((ModelData)activeNode);
                        GWTJahiaNode n = (GWTJahiaNode)children.get(0);
                        e.getStatus().setData("targetNextNode", (Object)n);
                        e.getStatus().setData("targetParent", (Object)activeNode);
                    } else if (this.status == 1) {
                        List children = PagesTabItem.this.pageTree.getTreeStore().getChildren((ModelData)parent);
                        int next = children.indexOf(activeNode) + 1;
                        if (next < children.size()) {
                            GWTJahiaNode n = (GWTJahiaNode)children.get(next);
                            e.getStatus().setData("targetNextNode", (Object)n);
                        } else {
                            e.getStatus().setData("targetNextNode", null);
                        }
                    }
                    if (activeNode.getInheritedNodeTypes().contains("jmix:navMenuItem")) {
                        e.getStatus().setData("targetType", (Object)"pageTree");
                    } else if (activeNode.getNodeTypes().contains("jnt:templatesFolder") && "pageTree".equals(e.getStatus().getData("sourceType"))) {
                        e.getStatus().setData("targetType", (Object)"templateTree");
                    } else {
                        e.getStatus().setStatus(false);
                        e.setCancelled(true);
                    }
                    return;
                }
            }
            e.getStatus().setData("targetNode", null);
            e.getStatus().setData("targetParent", null);
            e.getStatus().setData("targetPath", null);
            e.getStatus().setStatus(false);
            e.setCancelled(true);
        }

        protected void onDragDrop(DNDEvent event) {
        }

        public AsyncCallback<Map<String, Object>> getCallback() {
            BaseAsyncCallback<Map<String, Object>> callback = new BaseAsyncCallback<Map<String, Object>>(){

                public void onSuccess(Map<String, Object> data) {
                    PagesTabItem.this.editLinker.refresh(data);
                }

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    Window.alert((String)("Failed : " + throwable));
                }
            };
            return callback;
        }
    }
}

