/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseTreeLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.data.TreeLoader;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayoutData;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGridCellRenderer;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGridSelectionModel;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTColumn;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.Collator;
import org.jahia.ajax.gwt.client.util.icons.ContentModelIconProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.NodeColumnConfigList;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;
import org.jahia.ajax.gwt.client.widget.node.GWTJahiaNodeTreeFactory;

public class SettingsTabItem
extends SidePanelTabItem {
    private transient ContentPanel settingsPanel;
    private String settingPath;
    private String settingsTemplateRoot;
    private String label;
    private transient TreeLoader<GWTJahiaNode> settingsLoader;
    private transient TreeStore<GWTJahiaNode> settingsStore;
    private transient List<String> paths;
    private transient Map<String, Set<GWTJahiaNode>> nodesBySettingsPath;
    private transient GWTJahiaNodeTreeFactory factory;
    private transient GWTJahiaNode mainNode;

    @Override
    public TabItem create(GWTSidePanelTab config) {
        super.create(config);
        this.tab.setLayout((Layout)new FitLayout());
        this.tab.setId("JahiaGxtSettingsTab");
        this.settingsPanel = new ContentPanel();
        this.settingsPanel.setAnimCollapse(false);
        this.settingsPanel.setHeadingHtml(Messages.get(this.label));
        this.settingsPanel.setLayout((Layout)new FitLayout());
        this.tab.add((Widget)this.settingsPanel);
        LayoutContainer treeContainer = new LayoutContainer();
        treeContainer.setBorders(false);
        treeContainer.setScrollMode(Style.Scroll.AUTO);
        treeContainer.setLayout((Layout)new FitLayout());
        this.resetPaths();
        this.nodesBySettingsPath = new HashMap<String, Set<GWTJahiaNode>>();
        NodeColumnConfigList columns = new NodeColumnConfigList(Arrays.asList(new GWTColumn("displayName", "", -1)));
        columns.init();
        ((ColumnConfig)columns.get(0)).setRenderer((GridCellRenderer)new TreeGridCellRenderer<GWTJahiaNode>(){

            protected String getText(TreeGrid<GWTJahiaNode> gwtJahiaNodeTreeGrid, GWTJahiaNode node, String property, int rowIndex, int colIndex) {
                String v = super.getText(gwtJahiaNodeTreeGrid, (ModelData)node, property, rowIndex, colIndex);
                if (v != null) {
                    v = SafeHtmlUtils.htmlEscape((String)v);
                }
                return v;
            }
        });
        final ArrayList<String> fields = new ArrayList<String>();
        fields.add("locksInfo");
        fields.add("permissions");
        fields.add("childrenInfo");
        fields.add("icon");
        fields.add("locksInfo");
        fields.add("j:requiredPermissionNames");
        fields.add("j:requiredLicenseFeature");
        fields.add("j:templateLink");
        fields.add("j:hashLocation");
        RpcProxy<List<GWTJahiaNode>> proxy = new RpcProxy<List<GWTJahiaNode>>(){

            protected void load(Object loadConfig, final AsyncCallback<List<GWTJahiaNode>> callback) {
                if (SettingsTabItem.this.mainNode == null) {
                    return;
                }
                AsyncCallback<List<GWTJahiaNode>> asyncCallback = new AsyncCallback<List<GWTJahiaNode>>(){

                    public void onFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    public void onSuccess(List<GWTJahiaNode> nodes) {
                        ArrayList result = new ArrayList();
                        for (GWTJahiaNode node : nodes) {
                            this.merge(result, node);
                        }
                        callback.onSuccess(result);
                    }

                    private void merge(List result, GWTJahiaNode node) {
                        String settingsPath = SettingsTabItem.this.getSettingsPath(node);
                        HashSet<GWTJahiaNode> nodeSet = (HashSet<GWTJahiaNode>)SettingsTabItem.this.nodesBySettingsPath.get(settingsPath);
                        if (nodeSet == null) {
                            nodeSet = new HashSet<GWTJahiaNode>();
                            SettingsTabItem.this.nodesBySettingsPath.put(settingsPath, nodeSet);
                        }
                        nodeSet.add(node);
                        String nodeName = node.getName();
                        boolean add = true;
                        for (Object data : result) {
                            GWTJahiaNode previousNode = (GWTJahiaNode)data;
                            if (!previousNode.getName().equals(nodeName)) continue;
                            add = false;
                            if (previousNode.get("alternativePath") == null) {
                                previousNode.set("alternativePath", new ArrayList());
                            }
                            ((List)previousNode.get("alternativePath")).add(node.getPath() + "/*");
                            for (ModelData child : node.getChildren()) {
                                this.merge(previousNode.getChildren(), (GWTJahiaNode)child);
                            }
                        }
                        if (node.getName().equals(MainModule.getInstance().getTemplate())) {
                            node.setSelectedOnLoad(true);
                        }
                        if (add) {
                            ArrayList all = new ArrayList(node.getChildren());
                            node.getChildren().clear();
                            for (ModelData child : all) {
                                this.merge(node.getChildren(), (GWTJahiaNode)child);
                            }
                            List requiredPermissions = (List)node.get("j:requiredPermissionNames");
                            boolean access = true;
                            if (requiredPermissions != null) {
                                for (String p : requiredPermissions) {
                                    if (PermissionsUtils.isPermitted(p, JahiaGWTParameters.getSiteNode())) continue;
                                    access = false;
                                    break;
                                }
                            }
                            node.set("hasAccessToSettings", access);
                            if (access) {
                                result.add(node);
                            }
                        }
                    }
                };
                if (loadConfig == null) {
                    JahiaContentManagementService.App.getInstance().getRoot(SettingsTabItem.this.paths, Arrays.asList("jnt:template", "jnt:templateLink"), null, null, fields, SettingsTabItem.this.factory.getSelectedPath(), SettingsTabItem.this.factory.getOpenPath(), true, false, null, null, true, asyncCallback);
                } else {
                    GWTJahiaNode gwtJahiaNode = (GWTJahiaNode)loadConfig;
                    if (gwtJahiaNode.isExpandOnLoad()) {
                        ArrayList<GWTJahiaNode> list = new ArrayList<GWTJahiaNode>();
                        for (ModelData modelData : gwtJahiaNode.getChildren()) {
                            list.add((GWTJahiaNode)modelData);
                        }
                        asyncCallback.onSuccess(list);
                    } else {
                        ArrayList<String> nodePaths = new ArrayList<String>();
                        nodePaths.add(gwtJahiaNode.getPath() + "/*");
                        List alt = (List)gwtJahiaNode.get("alternativePath");
                        if (alt != null) {
                            nodePaths.addAll(alt);
                        }
                        JahiaContentManagementService.App.getInstance().getRoot(nodePaths, Arrays.asList("jnt:template", "jnt:templateLink"), null, null, fields, SettingsTabItem.this.factory.getSelectedPath(), SettingsTabItem.this.factory.getOpenPath(), true, false, null, null, true, asyncCallback);
                    }
                }
            }
        };
        this.settingsLoader = new BaseTreeLoader<GWTJahiaNode>((DataProxy)proxy){

            public boolean hasChildren(GWTJahiaNode parent) {
                return !parent.isNodeType("jnt:contentTemplate") && !parent.isNodeType("jnt:templateLink");
            }
        };
        this.factory = new GWTJahiaNodeTreeFactory(this.settingsLoader, "settingsTab");
        this.settingsStore = this.factory.getStore();
        this.settingsStore.setStoreSorter(new StoreSorter((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return Collator.getInstance().localeCompare(s1, s2);
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return 0;
            }
        }));
        GWTJahiaNodeTreeFactory.GWTJahiaNodeTreeGrid settingsTree = this.factory.getTreeGrid(new ColumnModel((List)columns));
        settingsTree.setAutoExpandColumn("displayName");
        settingsTree.getTreeView().setRowHeight(25);
        settingsTree.getTreeView().setForceFit(true);
        settingsTree.setHeight("100%");
        settingsTree.setIconProvider(ContentModelIconProvider.getInstance());
        treeContainer.add((Widget)settingsTree);
        settingsTree.setHideHeaders(true);
        settingsTree.setAutoExpand(false);
        settingsTree.setSelectionModel((GridSelectionModel)new TreeGridSelectionModel<GWTJahiaNode>(){

            protected void handleMouseClick(GridEvent<GWTJahiaNode> e) {
                super.handleMouseClick(e);
                String path = SettingsTabItem.this.settingPath.replaceAll("\\$site", JahiaGWTParameters.getSiteNode().getPath()).replaceAll("\\$user", JahiaGWTParameters.getCurrentUserPath());
                if (((GWTJahiaNode)e.getModel()).isNodeType("jnt:contentTemplate") && !Boolean.FALSE.equals(((GWTJahiaNode)e.getModel()).get("hasAccessToSettings"))) {
                    MainModule.staticGoTo(path, ((GWTJahiaNode)this.getSelectedItem()).getName(), "generic", "");
                } else if (((GWTJahiaNode)e.getModel()).isNodeType("jnt:templateLink")) {
                    MainModule.getInstance().resetFramePosition();
                    String url = MainModule.getInstance().getUrl(path, (String)((GWTJahiaNode)e.getModel()).get("j:templateLink"), "generic", "", false) + "#" + ((GWTJahiaNode)e.getModel()).get("j:hashLocation");
                    MainModule.getInstance().goToSettingsUrl(url);
                }
            }
        });
        VBoxLayoutData treeVBoxData = new VBoxLayoutData();
        treeVBoxData.setFlex(1.0);
        this.settingsPanel.add((Widget)treeContainer, (LayoutData)treeVBoxData);
        return this.tab;
    }

    @Override
    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
        super.handleNewMainNodeLoaded(node);
        if (this.mainNode == null || !this.mainNode.getSiteKey().equals(node.getSiteKey())) {
            this.mainNode = node;
            this.doRefresh();
        }
        if (this.settingsTemplateRoot.equals("site-settings-base") && node.equals(JahiaGWTParameters.getSiteNode())) {
            this.tab.getTabPanel().setSelection(this.tab);
        }
    }

    private void resetPaths() {
        this.paths = new ArrayList<String>();
        if (JahiaGWTParameters.getSiteNode() != null && JahiaGWTParameters.getSiteNode().get("j:installedModules") != null) {
            for (String module : (List)JahiaGWTParameters.getSiteNode().get("j:installedModules")) {
                this.paths.add("/modules/" + module + "/$moduleversion/templates/" + this.settingsTemplateRoot + "/*");
            }
        }
        if (JahiaGWTParameters.getSiteNode() != null && JahiaGWTParameters.getSiteNode().get("j:resolvedDependencies") != null) {
            for (String module : (List)JahiaGWTParameters.getSiteNode().get("j:resolvedDependencies")) {
                this.paths.add("/modules/" + module + "/$moduleversion/templates/" + this.settingsTemplateRoot + "/*");
            }
        }
    }

    public void setSettingsTemplateRoot(String settingTemplateRoot) {
        this.settingsTemplateRoot = settingTemplateRoot;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSettingPath(String settingPath) {
        this.settingPath = settingPath;
    }

    @Override
    public void doRefresh() {
        this.resetPaths();
        this.settingsStore.removeAll();
        this.settingsLoader.load();
    }

    private String getSettingsPath(GWTJahiaNode node) {
        String nodePath = node.getPath();
        return nodePath.substring(nodePath.indexOf(this.settingsTemplateRoot) + this.settingsTemplateRoot.length());
    }
}

