/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.poller;

import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.InfoConfig;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.atmosphere.gwt20.client.Atmosphere;
import org.atmosphere.gwt20.client.AtmosphereCloseHandler;
import org.atmosphere.gwt20.client.AtmosphereErrorHandler;
import org.atmosphere.gwt20.client.AtmosphereMessageHandler;
import org.atmosphere.gwt20.client.AtmosphereOpenHandler;
import org.atmosphere.gwt20.client.AtmosphereReconnectHandler;
import org.atmosphere.gwt20.client.AtmosphereReopenHandler;
import org.atmosphere.gwt20.client.AtmosphereRequestConfig;
import org.atmosphere.gwt20.client.AtmosphereResponse;
import org.atmosphere.gwt20.client.ClientSerializer;
import org.atmosphere.gwt20.client.RequestConfig;
import org.atmosphere.gwt20.client.managed.RPCEvent;
import org.atmosphere.gwt20.client.managed.RPCSerializer;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;

public class Poller {
    private static final boolean SSE_SUPPORT;
    private static final int RECONNECT_INTERVAL_MS = 2000;
    private static final int CONNECTION_RESTORED_NOTIFICATION_DELAY_MS = 15000;
    private static Poller instance;
    private Map<Class, ArrayList<PollListener>> listeners = new HashMap<Class, ArrayList<PollListener>>();
    private boolean reconnectingAfterError;

    public static Poller getInstance() {
        if (instance == null) {
            instance = new Poller(JahiaGWTParameters.isWebSockets());
        }
        return instance;
    }

    public Poller(final boolean useWebsockets) {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                RPCSerializer serializer = (RPCSerializer)GWT.create(RPCSerializer.class);
                AtmosphereRequestConfig requestConfig = AtmosphereRequestConfig.create((ClientSerializer)serializer);
                requestConfig.setUrl(GWT.getModuleBaseURL().substring(0, GWT.getModuleBaseURL().indexOf("/gwt/")) + "/atmosphere/rpc?windowId=" + JahiaContentManagementService.App.getWindowId());
                AtmosphereRequestConfig.Transport transport = useWebsockets ? AtmosphereRequestConfig.Transport.WEBSOCKET : (SSE_SUPPORT ? AtmosphereRequestConfig.Transport.SSE : AtmosphereRequestConfig.Transport.STREAMING);
                requestConfig.setTransport(transport);
                requestConfig.setFallbackTransport(AtmosphereRequestConfig.Transport.LONG_POLLING);
                requestConfig.setMaxReconnectOnClose(Integer.MAX_VALUE);
                requestConfig.setReconnectInterval(2000);
                requestConfig.setErrorHandler(new AtmosphereErrorHandler(){

                    public void onError(AtmosphereResponse response) {
                        GWT.log((String)"RPC error");
                        Poller.this.reconnectingAfterError = true;
                    }
                });
                requestConfig.setReconnectHandler(new AtmosphereReconnectHandler(){

                    public void onReconnect(RequestConfig request, AtmosphereResponse response) {
                        GWT.log((String)"RPC reconnection");
                    }
                });
                requestConfig.setOpenHandler(new AtmosphereOpenHandler(){

                    public void onOpen(AtmosphereResponse response) {
                        GWT.log((String)"RPC Connection opened");
                        Poller.this.onConnectionOpen();
                    }
                });
                requestConfig.setReopenHandler(new AtmosphereReopenHandler(){

                    public void onReopen(AtmosphereResponse response) {
                        GWT.log((String)"RPC Connection reopened");
                        PermissionsUtils.triggerPermissionsReload();
                        Poller.this.onConnectionOpen();
                    }
                });
                requestConfig.setCloseHandler(new AtmosphereCloseHandler(){

                    public void onClose(AtmosphereResponse response) {
                        GWT.log((String)"RPC Connection closed");
                    }
                });
                requestConfig.setMessageHandler(new AtmosphereMessageHandler(){

                    public void onMessage(AtmosphereResponse response) {
                        List messages = response.getMessages();
                        for (RPCEvent event : messages) {
                            for (Map.Entry entry : Poller.this.listeners.entrySet()) {
                                if (entry.getKey() != event.getClass()) continue;
                                for (PollListener pollListener : (ArrayList)entry.getValue()) {
                                    pollListener.handlePollingResult(event);
                                }
                            }
                        }
                    }
                });
                requestConfig.setFlags(new AtmosphereRequestConfig.Flags[]{AtmosphereRequestConfig.Flags.enableProtocol});
                requestConfig.setFlags(new AtmosphereRequestConfig.Flags[]{AtmosphereRequestConfig.Flags.trackMessageLength});
                Atmosphere atmosphere = Atmosphere.create();
                atmosphere.subscribe((RequestConfig)requestConfig);
            }
        });
    }

    private void onConnectionOpen() {
        if (!this.reconnectingAfterError) {
            return;
        }
        this.reconnectingAfterError = false;
        InfoConfig infoConfig = new InfoConfig(Messages.get("label.information"), Messages.get("instantMessaging.connectionRecovered.notification"));
        infoConfig.display = 15000;
        Info.display((InfoConfig)infoConfig);
    }

    public void registerListener(PollListener listener, Class eventType) {
        if (!this.listeners.containsKey(eventType)) {
            this.listeners.put(eventType, new ArrayList());
        }
        this.listeners.get(eventType).add(listener);
    }

    public void unregisterListener(PollListener listener, Class eventType) {
        if (this.listeners.containsKey(eventType)) {
            this.listeners.get(eventType).remove(listener);
        }
    }

    static {
        String userAgent = GXT.getUserAgent();
        SSE_SUPPORT = !GXT.isIE && (userAgent == null || userAgent.indexOf("trident/7") == -1);
    }

    public static interface PollListener<T> {
        public void handlePollingResult(T var1);
    }
}

