/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ToggleButton;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaProperty;
import org.jahia.ajax.gwt.client.data.node.GWTBitSet;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.util.Formatter;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ActionItem;

public abstract class BaseActionItem
implements ActionItem {
    private GWTJahiaToolbarItem gwtToolbarItem;
    private transient Component textToolitem = null;
    private transient MenuItem menuItem = null;
    private transient MenuItem contextMenuItem = null;
    protected transient Linker linker;
    private transient boolean enabled;

    @Override
    public Component getCustomItem() {
        return null;
    }

    @Override
    public Component getTextToolItem() {
        if (this.textToolitem != null) {
            return this.textToolitem;
        }
        this.textToolitem = this.createNewToolItem();
        GWTJahiaToolbarItem gwtJahiaToolbarItem = this.getGwtToolbarItem();
        int layout = gwtJahiaToolbarItem.getLayout();
        if (this.textToolitem instanceof ToggleButton) {
            ((ToggleButton)this.textToolitem).toggle(gwtJahiaToolbarItem.isSelected());
        }
        if (this.textToolitem instanceof Button) {
            SelectionListener listener;
            if ((layout == 2 || layout == 1) && gwtJahiaToolbarItem.isDisplayTitle()) {
                ((Button)this.textToolitem).setText(gwtJahiaToolbarItem.getTitle());
            }
            if ((layout == 2 || layout == 0) && gwtJahiaToolbarItem.getIcon() != null) {
                ((Button)this.textToolitem).setIcon(ToolbarIconProvider.getInstance().getIcon(gwtJahiaToolbarItem.getIcon()));
            }
            if ((listener = this.getSelectListener()) != null) {
                ((Button)this.textToolitem).addSelectionListener(listener);
            }
        }
        String description = gwtJahiaToolbarItem.getDescription();
        if (gwtJahiaToolbarItem.getDescription() != null && description.length() > 0 && this.textToolitem.getToolTip() == null && !gwtJahiaToolbarItem.getTitle().equals(description)) {
            this.textToolitem.setToolTip(description);
        }
        return this.textToolitem;
    }

    public MenuItem getMenuItem() {
        if (this.menuItem != null) {
            return this.menuItem;
        }
        this.menuItem = this.createMenuItem();
        this.initMenuItem(this.menuItem);
        return this.menuItem;
    }

    public MenuItem getContextMenuItem() {
        if (this.contextMenuItem != null) {
            return this.contextMenuItem;
        }
        this.contextMenuItem = this.createMenuItem();
        this.initMenuItem(this.contextMenuItem);
        return this.contextMenuItem;
    }

    private void initMenuItem(MenuItem menuItem) {
        GWTJahiaToolbarItem toolbarItem = this.getGwtToolbarItem();
        if (toolbarItem.getIcon() != null) {
            menuItem.setIcon(ToolbarIconProvider.getInstance().getIcon(toolbarItem.getIcon()));
        }
        menuItem.setText(toolbarItem.getTitle());
        if (!toolbarItem.getTitle().equals(toolbarItem.getDescription())) {
            menuItem.setToolTip(toolbarItem.getDescription());
        }
        SelectionListener listener = this.getSelectListener();
        menuItem.addSelectionListener(listener);
    }

    public void setSubMenu(Menu menu) {
        MenuItem mi;
        if (this.isTextToolItem()) {
            Button button = (Button)this.getTextToolItem();
            button.setMenu(menu);
        }
        if (this.isMenuItem()) {
            mi = this.getMenuItem();
            mi.setHideOnClick(false);
            mi.setSubMenu(menu);
        }
        if (this.isContextMenuItem()) {
            mi = this.getContextMenuItem();
            mi.setHideOnClick(false);
            mi.setSubMenu(menu);
        }
    }

    public boolean isTextToolItem() {
        return this.textToolitem != null;
    }

    public boolean isMenuItem() {
        return this.menuItem != null;
    }

    public boolean isContextMenuItem() {
        return this.contextMenuItem != null;
    }

    @Override
    public void setTextToolitem(Component textToolitem) {
        this.textToolitem = textToolitem;
    }

    @Override
    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
    }

    @Override
    public void setContextMenuItem(MenuItem contextMenuItem) {
        this.contextMenuItem = contextMenuItem;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.isTextToolItem()) {
            if (this.gwtToolbarItem.isHideWhenDisabled()) {
                this.getTextToolItem().setVisible(enabled);
            } else {
                Formatter.setButtonEnabled(this.getTextToolItem(), enabled);
            }
        }
        if (this.isMenuItem()) {
            if (this.gwtToolbarItem.isHideWhenDisabled()) {
                this.getMenuItem().setVisible(enabled);
            } else {
                Formatter.setMenuItemEnabled(this.getMenuItem(), enabled);
            }
        }
        if (this.isContextMenuItem()) {
            this.getContextMenuItem().setVisible(enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isTextToolItem()) {
            this.getTextToolItem().setVisible(visible);
        }
        if (this.isMenuItem()) {
            this.getMenuItem().setVisible(visible);
        }
        if (this.isContextMenuItem()) {
            this.getContextMenuItem().setVisible(visible);
        }
    }

    private <T extends ComponentEvent> SelectionListener<T> getSelectListener() {
        return new SelectionListener<T>(){

            public void componentSelected(T event) {
                BaseActionItem.this.onComponentSelection();
            }
        };
    }

    public Component createNewToolItem() {
        Button button = new Button();
        this.gwtToolbarItem.addClasses((Component)button);
        button.addStyleName("action-bar-tool-item");
        return button;
    }

    public MenuItem createMenuItem() {
        MenuItem menuItem = new MenuItem();
        this.gwtToolbarItem.addClasses((Component)menuItem);
        menuItem.addStyleName("action-bar-menu-item");
        return menuItem;
    }

    @Override
    public GWTJahiaToolbarItem getGwtToolbarItem() {
        return this.gwtToolbarItem;
    }

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        this.linker = linker;
        this.gwtToolbarItem = gwtToolbarItem;
    }

    public String getPropertyValue(GWTJahiaToolbarItem gwtToolbarItem, String propertyName) {
        Map<String, GWTJahiaProperty> properties = gwtToolbarItem.getProperties();
        GWTJahiaProperty property = properties != null ? properties.get(propertyName) : null;
        return property != null ? property.getValue() : null;
    }

    @Override
    public void onComponentSelection() {
    }

    @Override
    public void handleNewLinkerSelection() {
        if (this.getGwtToolbarItem().getRequiredModule() != null) {
            List installedModules = (List)JahiaGWTParameters.getSiteNode().get("j:installedModules");
            this.setVisible(installedModules != null && installedModules.contains(this.getGwtToolbarItem().getRequiredModule()));
        }
    }

    @Override
    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
    }

    public boolean hasPermission(GWTJahiaNode node) {
        if (this.gwtToolbarItem.getRequiredPermission() != null) {
            return PermissionsUtils.isPermitted(this.gwtToolbarItem.getRequiredPermission(), node);
        }
        return true;
    }

    public boolean hasPermission(GWTBitSet permissions) {
        if (this.gwtToolbarItem.getRequiredPermission() != null) {
            return PermissionsUtils.isPermitted(this.gwtToolbarItem.getRequiredPermission(), permissions);
        }
        return true;
    }

    protected void updateTitle(String title) {
        if (this.textToolitem != null) {
            ((Button)this.textToolitem).setText(title);
        }
        if (this.menuItem != null) {
            this.menuItem.setText(title);
            if (this.menuItem.getParentMenu() != null) {
                this.menuItem.getParentMenu().recalculate();
            }
        }
        if (this.contextMenuItem != null) {
            this.contextMenuItem.setText(title);
            if (this.menuItem != null && this.menuItem.getParentMenu() != null) {
                this.menuItem.getParentMenu().recalculate();
            }
        }
    }
}

