/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.contentengine.TranslateContentEngine;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class TranslateMenuActionItem
extends BaseActionItem {
    private transient Menu menu;

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        this.setEnabled(false);
        this.menu = new Menu();
    }

    private void initMenu(final Linker linker) {
        boolean notEmpty = false;
        String currentLanguage = JahiaGWTParameters.getLanguage();
        for (final GWTJahiaLanguage sourceLang : JahiaGWTParameters.getSiteLanguages()) {
            for (final GWTJahiaLanguage destLang : JahiaGWTParameters.getSiteLanguages()) {
                GWTJahiaNode selection;
                if (destLang.getDisplayName().equals(sourceLang.getDisplayName()) || !destLang.getLanguage().equals(currentLanguage) && !sourceLang.getLanguage().equals(currentLanguage)) continue;
                LinkerSelectionContext lh = linker.getSelectionContext();
                if (!PermissionsUtils.isPermitted("jcr:modifyProperties_" + JahiaGWTParameters.getWorkspace() + "_" + destLang.getLanguage(), lh.getSelectionPermissions()) || (selection = lh.getSingleSelection()) == null || selection.isLocked().booleanValue() && selection.getLockInfos().containsKey(destLang.getLanguage())) continue;
                MenuItem item = new MenuItem(sourceLang.getDisplayName() + "->" + destLang.getDisplayName());
                item.addSelectionListener((SelectionListener)new SelectionListener<MenuEvent>(){

                    public void componentSelected(MenuEvent ce) {
                        new TranslateContentEngine(selection, linker, sourceLang, destLang).show();
                    }
                });
                item.addStyleName("toolbar-item-translatemenu-item");
                this.menu.add((Component)item);
                notEmpty = true;
            }
        }
        if (notEmpty) {
            this.setSubMenu(this.menu);
        }
        this.setEnabled(notEmpty);
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        this.setEnabled(lh.getSingleSelection() != null && this.hasPermission(lh.getSingleSelection()) && !lh.isRootNode());
        this.menu.removeAll();
        this.initMenu(this.linker);
    }
}

