/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.layout.HBoxLayout;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class WebdavUrlCopyActionItem
extends NodeTypeAwareBaseActionItem {
    @Override
    public void onComponentSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        JahiaContentManagementService.App.getInstance().getAbsolutePath(lh.getSingleSelection().getPath(), (AsyncCallback<String>)new BaseAsyncCallback<String>(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                Log.error((String)throwable.getMessage(), (Throwable)throwable);
                MessageBox.alert((String)Messages.get("label.error", "Error"), (String)throwable.getMessage(), null);
            }

            public void onSuccess(String s) {
                Dialog dl = new Dialog();
                dl.setHeadingHtml(Messages.get("label.webdav.url"));
                dl.setModal(true);
                dl.setHideOnButtonClick(true);
                dl.setLayout((Layout)new HBoxLayout());
                dl.setWidth(500);
                dl.setScrollMode(Style.Scroll.NONE);
                final TextBox textBox = new TextBox();
                textBox.setValue((Object)s);
                textBox.setWidth("460px");
                textBox.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        textBox.selectAll();
                    }
                });
                dl.add((Widget)textBox);
                dl.add((Widget)new HTML("<span class=\"copy-to-clipboard\" title=\"" + Messages.get("label.copyToClipboard", "") + "\">" + s + "</span>"));
                dl.setHeight(102);
                dl.show();
                WebdavUrlCopyActionItem.this.initClippy(JahiaGWTParameters.getContextPath());
            }
        });
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        this.setEnabled(lh.getSingleSelection() != null && this.isNodeTypeAllowed(lh.getSingleSelection()));
    }

    private native void initClippy(String var1);
}

