/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.Button;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.job.GWTJahiaJobDetail;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.job.JobListWindow;
import org.jahia.ajax.gwt.client.widget.poller.Poller;
import org.jahia.ajax.gwt.client.widget.poller.ProcessPollingEvent;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class WorkInProgressActionItem
extends BaseActionItem
implements Poller.PollListener<ProcessPollingEvent> {
    private static WorkInProgressActionItem instance;
    private List<String> statuses = new ArrayList<String>();
    private List<GWTJahiaJobDetail> lastStartedJobs = new ArrayList<GWTJahiaJobDetail>();
    private List<GWTJahiaJobDetail> lastEndedJobs = new ArrayList<GWTJahiaJobDetail>();
    private int processesCount = 0;
    private boolean adminMode = true;

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        instance = this;
        this.refreshStatus();
        Poller.getInstance().registerListener(this, ProcessPollingEvent.class);
    }

    @Override
    public void handlePollingResult(ProcessPollingEvent result) {
        this.lastStartedJobs = result.getStartedJob();
        this.lastEndedJobs = result.getEndedJob();
        if (!this.lastStartedJobs.isEmpty() || !this.lastEndedJobs.isEmpty() || this.processesCount != result.getTotalCount()) {
            this.processesCount = result.getTotalCount();
            this.refreshStatus();
        }
    }

    public static void removeStatus(String status) {
        if (instance != null) {
            WorkInProgressActionItem.instance.statuses.remove(status);
            instance.refreshStatus();
        }
    }

    public static void setStatus(String status) {
        if (instance != null) {
            WorkInProgressActionItem.instance.statuses.add(status);
            instance.refreshStatus();
        }
    }

    private void refreshStatus() {
        Button b = (Button)this.getTextToolItem();
        if (this.statuses.isEmpty() && this.processesCount == 0) {
            b.setText(this.getMenuItem().getHtml());
            b.setIcon(this.getMenuItem().getIcon());
            b.setEnabled(true);
        } else if (this.statuses.size() == 1) {
            b.setIconStyle("x-status-busy");
            b.setText(this.statuses.get(0) + " ...");
            b.setEnabled(true);
        } else if (this.processesCount == 1 && this.lastStartedJobs.size() == 1) {
            b.setIconStyle("x-status-busy");
            b.setText(Messages.get(this.lastStartedJobs.get(0).getLabelKey()) + " ...");
            b.setEnabled(true);
        } else {
            b.setIconStyle("x-status-busy");
            b.setText(this.statuses.size() + this.processesCount + " " + Messages.get("label.tasksExecuting", "tasks running") + " ...");
            b.setEnabled(true);
        }
        HashMap<String, Object> refreshData = new HashMap<String, Object>();
        if (!this.lastEndedJobs.isEmpty()) {
            for (GWTJahiaJobDetail endedJob : this.lastEndedJobs) {
                if (endedJob.getSite() != null && !endedJob.getSite().equals(JahiaGWTParameters.getSiteKey()) || !endedJob.getGroup().equals("PublicationJob")) continue;
                if (endedJob.getUser().equals(JahiaGWTParameters.getCurrentUser())) {
                    refreshData.put("publishedNodes", endedJob.getTargetPaths());
                }
                refreshData.put("event", "publicationSuccess");
                refreshData.put("externalRefresh", Boolean.TRUE);
            }
        }
        if (!refreshData.isEmpty()) {
            this.linker.refresh(refreshData);
        }
    }

    @Override
    public Component createNewToolItem() {
        Button b = (Button)super.createNewToolItem();
        b.setEnabled(false);
        return b;
    }

    @Override
    public void onComponentSelection() {
        new JobListWindow(this.linker, this.adminMode).show();
    }

    public void setAdminMode(boolean adminMode) {
        this.adminMode = adminMode;
    }
}

