/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.usergroup;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BasePagingLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadConfig;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.PagingLoader;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.PagingToolBar;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.GWTJahiaSite;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.widget.SearchField;
import org.jahia.ajax.gwt.client.widget.usergroup.UserGroupAdder;

public class UserGroupSelect
extends Window {
    public static final int VIEW_USERS = 1;
    public static final int VIEW_GROUPS = 2;
    public static final int VIEW_TABS = 3;
    public static final int VIEW_ROLES = 4;
    private SearchField userSearchField;
    private String lastUserSearchValue;
    private SearchField groupSearchField;
    private String lastGroupSearchValue;
    private ListStore<GWTJahiaSite> sites;
    private String selectedSite;
    private Grid<GWTJahiaNode> userGrid;
    private Grid<GWTJahiaNode> groupGrid;
    private String siteKey;
    private boolean singleSelectionMode;

    public UserGroupSelect(UserGroupAdder target, int viewMode, String siteKey) {
        this(target, viewMode, siteKey, false);
    }

    public UserGroupSelect(final UserGroupAdder target, int viewMode, String siteKey, boolean singleSelectionMode) {
        this.addStyleName("user-group-select");
        this.siteKey = siteKey;
        this.singleSelectionMode = singleSelectionMode;
        this.setModal(true);
        this.setSize(500, 500);
        this.setLayout((Layout)new FitLayout());
        this.setId("JahiaGxtUserGroupSelect");
        switch (viewMode) {
            case 3: {
                ContentPanel userPanel = this.getUserPanel(target);
                TabItem userTab = new TabItem(Messages.get("label.users", "Users"));
                userTab.setLayout((Layout)new FitLayout());
                userTab.add((Widget)userPanel);
                ContentPanel groupsPanel = this.getGroupsPanel(target);
                TabItem groupsTab = new TabItem(Messages.get("label.groups", "Groups"));
                groupsTab.setLayout((Layout)new FitLayout());
                groupsTab.add((Widget)groupsPanel);
                TabPanel tabs = new TabPanel();
                tabs.add(userTab);
                tabs.add(groupsTab);
                this.add((Component)tabs);
                break;
            }
            case 1: {
                this.add((Component)this.getUserPanel(target));
                break;
            }
            case 2: {
                this.add((Component)this.getGroupsPanel(target));
            }
        }
        Button add = new Button(Messages.get("label.add", "Add"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                if (UserGroupSelect.this.userGrid != null) {
                    target.addUsersGroups(UserGroupSelect.this.userGrid.getSelectionModel().getSelectedItems());
                }
                if (UserGroupSelect.this.groupGrid != null) {
                    target.addUsersGroups(UserGroupSelect.this.groupGrid.getSelectionModel().getSelectedItems());
                }
                UserGroupSelect.this.hide();
            }
        });
        add.addStyleName("button-add");
        this.addButton(add);
        Button cancel = new Button(Messages.get("label.cancel", "Cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                UserGroupSelect.this.hide();
            }
        });
        cancel.addStyleName("button-cancel");
        this.addButton(cancel);
        this.setButtonAlign(Style.HorizontalAlignment.CENTER);
        this.show();
    }

    private ContentPanel getUserPanel(final UserGroupAdder target) {
        RpcProxy<PagingLoadResult<GWTJahiaNode>> proxy = new RpcProxy<PagingLoadResult<GWTJahiaNode>>(){

            protected void load(Object pageLoaderConfig, AsyncCallback<PagingLoadResult<GWTJahiaNode>> callback) {
                JahiaContentManagementServiceAsync service = JahiaContentManagementService.App.getInstance();
                String newSearch = UserGroupSelect.this.userSearchField.getText().trim().replace("'", "''");
                String query = "select * from [jnt:user] as u where (isdescendantnode(u,'/users/') or isdescendantnode(u,'/sites/" + UserGroupSelect.this.siteKey.replace("'", "''") + "/users/'))";
                if (newSearch.length() > 0) {
                    query = query + " and (CONTAINS(u.*,'%" + newSearch + "%') OR LOWER(u.[j:nodename]) LIKE '%" + newSearch.toLowerCase() + "%') ";
                }
                query = query + " ORDER BY u.[j:nodename]";
                int offset = UserGroupSelect.this.lastUserSearchValue != null && UserGroupSelect.this.lastUserSearchValue.equals(newSearch) ? ((PagingLoadConfig)pageLoaderConfig).getOffset() : 0;
                service.searchSQL(query, ((PagingLoadConfig)pageLoaderConfig).getLimit(), offset, null, GWTJahiaNode.DEFAULT_USER_FIELDS, false, callback);
                UserGroupSelect.this.lastUserSearchValue = newSearch;
            }
        };
        BasePagingLoader loader = new BasePagingLoader((DataProxy)proxy);
        this.userSearchField = new SearchField(Messages.get("label.search", "Search: "), false, (PagingLoader)loader){
            final /* synthetic */ PagingLoader val$loader;
            {
                this.val$loader = pagingLoader;
                super(name, saveSearchbutton);
            }

            @Override
            public void onFieldValidation(String value) {
                this.val$loader.load();
            }

            @Override
            public void onSaveButtonClicked(String value) {
            }
        };
        this.userSearchField.setWidth(250);
        loader.setLimit(15);
        loader.load();
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Widget)this.userSearchField);
        if ("siteSelector".equals(this.siteKey)) {
            ComboBox<GWTJahiaSite> siteMenu = this.createMenu((PagingLoader)loader);
            panel.add(siteMenu);
        }
        ListStore store = new ListStore((ListLoader)loader);
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        columns.add(new ColumnConfig("displayName", Messages.get("label.username", "User name"), 120));
        columns.add(new ColumnConfig("j:lastName", Messages.get("label.lastName", "Last name"), 140));
        columns.add(new ColumnConfig("j:firstName", Messages.get("label.firstName", "First name"), 140));
        columns.add(new ColumnConfig("providerKey", Messages.get("column.provider.label", "Provider"), 80));
        ColumnModel cm = new ColumnModel(columns);
        PagingToolBar toolBar = new PagingToolBar(15);
        toolBar.bind((PagingLoader)loader);
        this.userGrid = new Grid(store, cm);
        if (this.singleSelectionMode) {
            this.userGrid.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        }
        this.userGrid.setLoadMask(true);
        this.userGrid.setBorders(true);
        this.userGrid.addListener(Events.RowDoubleClick, (Listener)new Listener<GridEvent>(){

            public void handleEvent(GridEvent event) {
                target.addUsersGroups(UserGroupSelect.this.userGrid.getSelectionModel().getSelectedItems());
                if (UserGroupSelect.this.singleSelectionMode) {
                    UserGroupSelect.this.hide();
                }
            }
        });
        ContentPanel userPanel = new ContentPanel();
        userPanel.setButtonAlign(Style.HorizontalAlignment.CENTER);
        userPanel.setHeadingHtml(Messages.get("label.userSelect", "Select users"));
        userPanel.setLayout((Layout)new FitLayout());
        userPanel.add(this.userGrid);
        userPanel.setSize(480, 350);
        userPanel.setBottomComponent((Component)toolBar);
        userPanel.setTopComponent((Component)panel);
        return userPanel;
    }

    private ContentPanel getGroupsPanel(final UserGroupAdder target) {
        RpcProxy<PagingLoadResult<GWTJahiaNode>> proxy = new RpcProxy<PagingLoadResult<GWTJahiaNode>>(){

            protected void load(Object pageLoaderConfig, AsyncCallback<PagingLoadResult<GWTJahiaNode>> callback) {
                String newSearch = UserGroupSelect.this.groupSearchField.getText().trim().replace("'", "''");
                String query = "select * from [jnt:group] as g where ";
                query = !UserGroupSelect.this.siteKey.equals("systemsite") ? query + "(isdescendantnode(g,'/groups') or isdescendantnode(g,'/sites/" + UserGroupSelect.this.siteKey.replace("'", "''") + "/groups'))" : query + "isdescendantnode(g,'/groups')";
                if (newSearch.length() > 0) {
                    query = query + " and (CONTAINS(g.*,'%" + newSearch + "%') OR LOWER(g.[j:nodename]) LIKE '%" + newSearch.toLowerCase() + "%') ";
                }
                query = query + " ORDER BY g.[j:nodename]";
                int offset = UserGroupSelect.this.lastGroupSearchValue != null && UserGroupSelect.this.lastGroupSearchValue.equals(newSearch) ? ((PagingLoadConfig)pageLoaderConfig).getOffset() : 0;
                JahiaContentManagementServiceAsync service = JahiaContentManagementService.App.getInstance();
                service.searchSQL(query, ((PagingLoadConfig)pageLoaderConfig).getLimit(), offset, null, GWTJahiaNode.DEFAULT_USER_FIELDS, false, callback);
                UserGroupSelect.this.lastGroupSearchValue = newSearch;
            }
        };
        final BasePagingLoader loader = new BasePagingLoader((DataProxy)proxy);
        this.groupSearchField = new SearchField(Messages.get("label.search", "Search: "), false){

            @Override
            public void onFieldValidation(String value) {
                loader.load();
            }

            @Override
            public void onSaveButtonClicked(String value) {
            }
        };
        this.groupSearchField.setWidth(250);
        loader.setLimit(15);
        loader.load();
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Widget)this.groupSearchField);
        if ("siteSelector".equals(this.siteKey)) {
            ComboBox<GWTJahiaSite> siteMenu = this.createMenu((PagingLoader)loader);
            panel.add(siteMenu);
        }
        ListStore store = new ListStore((ListLoader)loader);
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        columns.add(new ColumnConfig("displayName", "Group name", 240));
        columns.add(new ColumnConfig("siteKey", "Site name", 120));
        columns.add(new ColumnConfig("providerKey", "Provider", 120));
        ColumnModel cm = new ColumnModel(columns);
        PagingToolBar toolBar = new PagingToolBar(15);
        toolBar.bind((PagingLoader)loader);
        this.groupGrid = new Grid(store, cm);
        if (this.singleSelectionMode) {
            this.groupGrid.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        }
        this.groupGrid.setLoadMask(true);
        this.groupGrid.setBorders(true);
        this.groupGrid.addListener(Events.RowDoubleClick, (Listener)new Listener<GridEvent>(){

            public void handleEvent(GridEvent event) {
                target.addUsersGroups(UserGroupSelect.this.groupGrid.getSelectionModel().getSelectedItems());
                if (UserGroupSelect.this.singleSelectionMode) {
                    UserGroupSelect.this.hide();
                }
            }
        });
        ContentPanel groupsPanel = new ContentPanel();
        groupsPanel.setButtonAlign(Style.HorizontalAlignment.CENTER);
        groupsPanel.setHeadingHtml(Messages.get("label.groupSelect", "Select groups"));
        groupsPanel.setLayout((Layout)new FitLayout());
        groupsPanel.add(this.groupGrid);
        groupsPanel.setSize(480, 350);
        groupsPanel.setBottomComponent((Component)toolBar);
        groupsPanel.setTopComponent((Component)panel);
        return groupsPanel;
    }

    protected ComboBox<GWTJahiaSite> createMenu(final PagingLoader loader) {
        if ("siteSelector".equals(this.siteKey)) {
            this.sites = new ListStore();
            final ComboBox siteMenu = new ComboBox();
            siteMenu.setEmptyText("Select a site...");
            siteMenu.setDisplayField("siteKey");
            siteMenu.setStore(this.sites);
            siteMenu.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaSite>(){

                public void selectionChanged(SelectionChangedEvent<GWTJahiaSite> se) {
                    UserGroupSelect.this.selectedSite = ((GWTJahiaSite)se.getSelectedItem()).getSiteKey();
                    loader.load();
                }
            });
            JahiaContentManagementService.App.getInstance().getAvailableSites((AsyncCallback<List<GWTJahiaSite>>)new BaseAsyncCallback<List<GWTJahiaSite>>(){

                public void onSuccess(List<GWTJahiaSite> gwtJahiaSites) {
                    UserGroupSelect.this.sites.add(gwtJahiaSites);
                    if (gwtJahiaSites.size() > 0) {
                        siteMenu.setValue((ModelData)gwtJahiaSites.get(0));
                    }
                }
            });
            return siteMenu;
        }
        return null;
    }
}

